/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermal.expansion.compat.jei.machine;

import cofh.core.util.helpers.RenderHelper;
import cofh.lib.util.helpers.StringHelper;
import cofh.thermal.core.compat.jei.TCoreJeiPlugin;
import cofh.thermal.core.util.managers.machine.InsolatorRecipeManager;
import cofh.thermal.core.util.recipes.machine.InsolatorRecipe;
import cofh.thermal.expansion.client.gui.machine.MachineInsolatorScreen;
import cofh.thermal.expansion.init.TExpReferences;
import cofh.thermal.lib.compat.jei.Drawables;
import cofh.thermal.lib.compat.jei.ThermalRecipeCategory;
import cofh.thermal.lib.util.recipes.ThermalRecipe;
import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.List;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.drawable.IDrawableAnimated;
import mezz.jei.api.gui.drawable.IDrawableStatic;
import mezz.jei.api.gui.ingredient.IGuiFluidStackGroup;
import mezz.jei.api.gui.ingredient.IGuiItemStackGroup;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredients;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fluids.FluidStack;

public class InsolatorRecipeCategory
extends ThermalRecipeCategory<InsolatorRecipe> {
    protected IDrawableStatic tankBackground;
    protected IDrawableStatic tankOverlay;

    public InsolatorRecipeCategory(IGuiHelper guiHelper, ItemStack icon, ResourceLocation uid) {
        super(guiHelper, icon, uid);
        this.background = guiHelper.drawableBuilder(MachineInsolatorScreen.TEXTURE, 26, 11, 130, 62).addPadding(0, 0, 16, 18).build();
        this.name = StringHelper.getTextComponent((String)TExpReferences.MACHINE_INSOLATOR_BLOCK.func_149739_a());
        this.progressBackground = Drawables.getDrawables((IGuiHelper)guiHelper).getProgress(0);
        this.progressFluidBackground = Drawables.getDrawables((IGuiHelper)guiHelper).getProgressFill(1);
        this.speedBackground = Drawables.getDrawables((IGuiHelper)guiHelper).getScale(9);
        this.tankBackground = Drawables.getDrawables((IGuiHelper)guiHelper).getTank(1);
        this.tankOverlay = Drawables.getDrawables((IGuiHelper)guiHelper).getTankOverlay(1);
        this.progress = guiHelper.createAnimatedDrawable(Drawables.getDrawables((IGuiHelper)guiHelper).getProgressFill(0), 200, IDrawableAnimated.StartDirection.LEFT, false);
        this.progressFluid = guiHelper.createAnimatedDrawable(Drawables.getDrawables((IGuiHelper)guiHelper).getProgress(1), 200, IDrawableAnimated.StartDirection.LEFT, true);
        this.speed = guiHelper.createAnimatedDrawable(Drawables.getDrawables((IGuiHelper)guiHelper).getScaleFill(9), 400, IDrawableAnimated.StartDirection.TOP, true);
    }

    public Class<? extends InsolatorRecipe> getRecipeClass() {
        return InsolatorRecipe.class;
    }

    public void setIngredients(InsolatorRecipe recipe, IIngredients ingredients) {
        ingredients.setInputIngredients(recipe.getInputItems());
        ingredients.setInputs(VanillaTypes.FLUID, recipe.getInputFluids());
        ingredients.setOutputs(VanillaTypes.ITEM, recipe.getOutputItems());
    }

    public void setRecipe(IRecipeLayout layout, InsolatorRecipe recipe, IIngredients ingredients) {
        List inputs = ingredients.getInputs(VanillaTypes.ITEM);
        List inputFluids = ingredients.getInputs(VanillaTypes.FLUID);
        List outputs = ingredients.getOutputs(VanillaTypes.ITEM);
        List catalysts = InsolatorRecipeManager.instance().getCatalysts();
        for (int i = 0; i < outputs.size(); ++i) {
            float chance = ((Float)recipe.getOutputItemChances().get(i)).floatValue();
            if (!(chance > 1.0f)) continue;
            for (ItemStack stack : (List)outputs.get(i)) {
                stack.func_190920_e((int)chance);
            }
        }
        IGuiItemStackGroup guiItemStacks = layout.getItemStacks();
        IGuiFluidStackGroup guiFluidStacks = layout.getFluidStacks();
        guiItemStacks.init(0, true, 51, 5);
        guiItemStacks.init(1, true, 51, 41);
        guiItemStacks.init(2, false, 105, 14);
        guiItemStacks.init(3, false, 123, 14);
        guiItemStacks.init(4, false, 105, 32);
        guiItemStacks.init(5, false, 123, 32);
        guiFluidStacks.init(0, false, 25, 11, 16, 40, TCoreJeiPlugin.tankSize((int)8000), false, TCoreJeiPlugin.tankOverlay((IDrawable)this.tankOverlay));
        guiItemStacks.set(0, (List)inputs.get(0));
        guiFluidStacks.set(0, (List)inputFluids.get(0));
        if (recipe.isCatalyzable()) {
            guiItemStacks.set(1, catalysts);
        }
        for (int i = 0; i < outputs.size(); ++i) {
            guiItemStacks.set(i + 2, (List)outputs.get(i));
        }
        this.addCatalyzedItemTooltipCallback(guiItemStacks, recipe.getOutputItemChances(), 2);
        TCoreJeiPlugin.addDefaultFluidTooltipCallback((IGuiFluidStackGroup)guiFluidStacks);
    }

    public void draw(InsolatorRecipe recipe, MatrixStack matrixStack, double mouseX, double mouseY) {
        super.draw((ThermalRecipe)recipe, matrixStack, mouseX, mouseY);
        this.progressBackground.draw(matrixStack, 76, 23);
        this.tankBackground.draw(matrixStack, 24, 10);
        this.speedBackground.draw(matrixStack, 52, 24);
        if (!recipe.getInputFluids().isEmpty()) {
            RenderHelper.drawFluid((MatrixStack)matrixStack, (int)76, (int)23, (FluidStack)((FluidStack)recipe.getInputFluids().get(0)), (int)24, (int)16);
            this.progressFluidBackground.draw(matrixStack, 76, 23);
            this.progressFluid.draw(matrixStack, 76, 23);
        } else {
            this.progress.draw(matrixStack, 76, 23);
        }
        this.speed.draw(matrixStack, 52, 24);
    }
}

