/*
 * Decompiled with CFR 0.152.
 */
package com.baguchan.enchantwithmob.mobenchant;

import com.baguchan.enchantwithmob.EnchantWithMob;
import com.baguchan.enchantwithmob.capability.ItemMobEnchantCapability;
import com.baguchan.enchantwithmob.mobenchant.MobEnchant;
import com.baguchan.enchantwithmob.registry.MobEnchants;
import com.baguchan.enchantwithmob.utils.MobEnchantUtils;
import java.util.UUID;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.projectile.AbstractArrowEntity;
import net.minecraft.entity.projectile.DamagingProjectileEntity;
import net.minecraft.entity.projectile.ProjectileEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.ProjectileImpactEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="enchantwithmob")
public class MultiShotMobEnchant
extends MobEnchant {
    private static boolean isAdding = false;

    public MultiShotMobEnchant(MobEnchant.Properties properties) {
        super(properties);
    }

    @Override
    public int getMinEnchantability(int enchantmentLevel) {
        return 10;
    }

    @Override
    public int getMaxEnchantability(int enchantmentLevel) {
        return this.getMinEnchantability(enchantmentLevel) + 40;
    }

    @SubscribeEvent
    public static void onEntityJoinWorld(EntityJoinWorldEvent event) {
        Entity entity = event.getEntity();
        if (entity instanceof ProjectileEntity) {
            ProjectileEntity projectile = (ProjectileEntity)entity;
            if (!MultiShotMobEnchant.shooterIsLiving(projectile)) {
                return;
            }
            LivingEntity owner = (LivingEntity)projectile.func_234616_v_();
            MobEnchantUtils.executeIfPresent(owner, MobEnchants.MULTISHOT, () -> {
                if (!projectile.field_70170_p.field_72995_K && projectile.field_70173_aa == 0 && !isAdding) {
                    isAdding = true;
                    CompoundNBT compoundNBT = new CompoundNBT();
                    compoundNBT = projectile.func_189511_e(compoundNBT);
                    MultiShotMobEnchant.addProjectile(projectile, compoundNBT, 15.0f);
                    MultiShotMobEnchant.addProjectile(projectile, compoundNBT, -15.0f);
                    isAdding = false;
                }
            });
        }
    }

    private static void addProjectile(ProjectileEntity projectile, CompoundNBT compoundNBT, float rotation) {
        ProjectileEntity newProjectile = (ProjectileEntity)projectile.func_200600_R().func_200721_a(projectile.field_70170_p);
        UUID uuid = newProjectile.func_110124_au();
        newProjectile.func_70020_e(compoundNBT);
        newProjectile.func_184221_a(uuid);
        Vector3d vector3d = newProjectile.func_213322_ci().func_178785_b((float)(Math.PI / (double)rotation));
        newProjectile.func_213317_d(vector3d);
        float f = MathHelper.func_76133_a((double)Entity.func_213296_b((Vector3d)vector3d));
        newProjectile.field_70177_z = (float)(MathHelper.func_181159_b((double)vector3d.field_72450_a, (double)vector3d.field_72449_c) * 57.2957763671875);
        newProjectile.field_70125_A = (float)(MathHelper.func_181159_b((double)vector3d.field_72448_b, (double)f) * 57.2957763671875);
        newProjectile.field_70126_B = newProjectile.field_70177_z;
        newProjectile.field_70127_C = newProjectile.field_70125_A;
        if (newProjectile instanceof DamagingProjectileEntity) {
            DamagingProjectileEntity newDamagingProjectile = (DamagingProjectileEntity)newProjectile;
            Vector3d newPower = new Vector3d(newDamagingProjectile.field_70232_b, newDamagingProjectile.field_70233_c, newDamagingProjectile.field_70230_d).func_178785_b((float)(Math.PI / (double)rotation));
            newDamagingProjectile.field_70232_b = newPower.field_72450_a;
            newDamagingProjectile.field_70233_c = newPower.field_72448_b;
            newDamagingProjectile.field_70230_d = newPower.field_72449_c;
        }
        newProjectile.getCapability(EnchantWithMob.ITEM_MOB_ENCHANT_CAP).ifPresent(cap -> cap.setHasEnchant(true));
        projectile.field_70170_p.func_217376_c((Entity)newProjectile);
    }

    @SubscribeEvent
    public static void onHit(ProjectileImpactEvent.Arrow event) {
        AbstractArrowEntity projectile = event.getArrow();
        projectile.getCapability(EnchantWithMob.ITEM_MOB_ENCHANT_CAP).ifPresent(arg_0 -> MultiShotMobEnchant.lambda$onHit$2((ProjectileEntity)projectile, arg_0));
    }

    public static boolean shooterIsLiving(ProjectileEntity projectile) {
        return projectile.func_234616_v_() != null && projectile.func_234616_v_() instanceof LivingEntity;
    }

    private static /* synthetic */ void lambda$onHit$2(ProjectileEntity projectile, ItemMobEnchantCapability cap) {
        if (cap.hasEnchant()) {
            projectile.func_70106_y();
        }
    }
}

