/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.block.subtile.functional;

import com.google.common.collect.MapMaker;
import java.util.Collections;
import java.util.Set;
import net.minecraft.entity.Entity;
import net.minecraft.tileentity.TileEntityType;
import vazkii.botania.api.subtile.RadiusDescriptor;
import vazkii.botania.api.subtile.TileEntityFunctionalFlower;
import vazkii.botania.common.block.ModSubtiles;

public class SubTileSolegnolia
extends TileEntityFunctionalFlower {
    private static final double RANGE = 5.0;
    private static final double RANGE_MINI = 1.0;
    private static final Set<SubTileSolegnolia> existingFlowers = Collections.newSetFromMap(new MapMaker().concurrencyLevel(2).weakKeys().makeMap());

    public SubTileSolegnolia(TileEntityType<?> type) {
        super(type);
    }

    public SubTileSolegnolia() {
        this(ModSubtiles.SOLEGNOLIA);
    }

    @Override
    public void tickFlower() {
        super.tickFlower();
        if (!existingFlowers.contains(this)) {
            existingFlowers.add(this);
        }
    }

    public void func_145843_s() {
        super.func_145843_s();
        existingFlowers.remove(this);
    }

    @Override
    public boolean acceptsRedstone() {
        return true;
    }

    public static boolean hasSolegnoliaAround(Entity e) {
        return existingFlowers.stream().filter(f -> f.redstoneSignal == 0).filter(f -> f.func_145831_w() == e.field_70170_p).anyMatch(f -> f.getEffectivePos().func_218140_a(e.func_226277_ct_(), e.func_226278_cu_(), e.func_226281_cx_(), true) <= f.getRange() * f.getRange());
    }

    @Override
    public int getMaxMana() {
        return 1;
    }

    @Override
    public int getColor() {
        return 13212749;
    }

    public double getRange() {
        return 5.0;
    }

    @Override
    public RadiusDescriptor getRadius() {
        return new RadiusDescriptor.Circle(this.getEffectivePos(), this.getRange());
    }

    public static class Mini
    extends SubTileSolegnolia {
        public Mini() {
            super(ModSubtiles.SOLEGNOLIA_CHIBI);
        }

        @Override
        public double getRange() {
            return 1.0;
        }
    }
}

