/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.client.patchouli.component;

import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.List;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.item.crafting.Ingredient;
import vazkii.botania.common.core.handler.ConfigHandler;
import vazkii.patchouli.api.IComponentRenderContext;
import vazkii.patchouli.api.ICustomComponent;

abstract class RotatingItemListComponentBase
implements ICustomComponent {
    protected transient List<Ingredient> ingredients;
    protected transient int x;
    protected transient int y;

    RotatingItemListComponentBase() {
    }

    public void build(int componentX, int componentY, int pageNum) {
        this.x = componentX != -1 ? componentX : 17;
        this.y = componentY;
        this.ingredients = this.makeIngredients();
    }

    protected abstract List<Ingredient> makeIngredients();

    public void render(MatrixStack ms, IComponentRenderContext context, float pticks, int mouseX, int mouseY) {
        int degreePerInput = (int)(360.0f / (float)this.ingredients.size());
        int ticksElapsed = context.getTicksInBook();
        float currentDegree = ((Boolean)ConfigHandler.CLIENT.lexiconRotatingItems.get()).booleanValue() ? (Screen.func_231173_s_() ? (float)ticksElapsed : (float)ticksElapsed + pticks) : 0.0f;
        for (Ingredient input : this.ingredients) {
            this.renderIngredientAtAngle(ms, context, currentDegree, input, mouseX, mouseY);
            currentDegree += (float)degreePerInput;
        }
    }

    private void renderIngredientAtAngle(MatrixStack ms, IComponentRenderContext context, float angle, Ingredient ingredient, int mouseX, int mouseY) {
        if (ingredient.func_203189_d()) {
            return;
        }
        int radius = 32;
        double xPos = (double)this.x + Math.cos((double)(angle -= 90.0f) * Math.PI / 180.0) * (double)radius + 32.0;
        double yPos = (double)this.y + Math.sin((double)angle * Math.PI / 180.0) * (double)radius + 32.0;
        ms.func_227860_a_();
        ms.func_227861_a_(xPos - (double)((int)xPos), yPos - (double)((int)yPos), 0.0);
        context.renderIngredient(ms, (int)xPos, (int)yPos, mouseX, mouseY, ingredient);
        ms.func_227865_b_();
    }
}

