/*
 * Decompiled with CFR 0.152.
 */
package com.sunekaer.mods.toolkit.commands;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import java.util.Objects;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.command.CommandSource;
import net.minecraft.command.Commands;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.server.ServerWorld;

public class CommandClear {
    public static ArgumentBuilder<CommandSource, ?> register() {
        return ((LiteralArgumentBuilder)Commands.func_197057_a((String)"clear").requires(cs -> cs.func_197034_c(2))).then(Commands.func_197056_a((String)"ClearSize", (ArgumentType)IntegerArgumentType.integer()).executes(ctx -> CommandClear.remove((CommandSource)ctx.getSource(), (PlayerEntity)((CommandSource)ctx.getSource()).func_197035_h(), IntegerArgumentType.getInteger((CommandContext)ctx, (String)"ClearSize"))));
    }

    private static int remove(CommandSource source, PlayerEntity player, int size) {
        ServerWorld world = source.func_197023_e();
        double removeSize = (float)(16 * size) / 2.0f;
        double startX = player.func_213303_ch().func_82615_a() - removeSize;
        double startZ = player.func_213303_ch().func_82616_c() - removeSize;
        double endX = player.func_213303_ch().func_82615_a() + removeSize;
        double endZ = player.func_213303_ch().func_82616_c() + removeSize;
        source.func_197030_a((ITextComponent)new TranslationTextComponent("commands.toolkit.remove.lagwarring"), true);
        for (int y = 0; y < 255; ++y) {
            for (double x = startX; x < endX; x += 1.0) {
                for (double z = startZ; z < endZ; z += 1.0) {
                    BlockPos tBlockPos = new BlockPos(x, (double)y, z);
                    BlockState tBlockState = world.func_180495_p(tBlockPos);
                    Block tBlock = tBlockState.func_177230_c();
                    if (tBlock.equals(Blocks.field_150350_a) || tBlock.equals(Blocks.field_150357_h) || !Objects.requireNonNull(tBlock.getRegistryName()).func_110624_b().equals("minecraft")) continue;
                    world.func_180501_a(tBlockPos, Blocks.field_150350_a.func_176223_P(), 2);
                }
            }
        }
        source.func_197030_a((ITextComponent)new TranslationTextComponent("commands.toolkit.remove.done"), true);
        return 1;
    }
}

