/*
 * Decompiled with CFR 0.152.
 */
package com.sunekaer.mods.toolkit;

import com.sunekaer.mods.toolkit.config.TKConfig;
import com.sunekaer.mods.toolkit.event.PlayerEvents;
import com.sunekaer.mods.toolkit.network.Handler;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.server.FMLServerStartingEvent;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="toolkit")
public class ToolKit {
    public static final String MODID = "toolkit";
    public static final Logger LOGGER = LogManager.getLogger((String)"ToolKit");

    public ToolKit() {
        LOGGER.log(Level.INFO, "Loading mod");
        MinecraftForge.EVENT_BUS.register((Object)this);
        Handler.init();
        TKConfig.register(ModLoadingContext.get());
    }

    public static void sendChatMessage(PlayerEntity entity, String message) {
        entity.func_145747_a((ITextComponent)new StringTextComponent(message), entity.func_110124_au());
    }

    public static void sendChatMessage(PlayerEntity entity, ITextComponent message) {
        entity.func_145747_a(message, entity.func_110124_au());
    }

    @SubscribeEvent
    public void onServerStarting(FMLServerStartingEvent event) {
        LOGGER.log(Level.INFO, "Loading server stuff");
        MinecraftForge.EVENT_BUS.addListener(new PlayerEvents()::onPlayerJoin);
    }
}

