/*
 * Decompiled with CFR 0.152.
 */
package stormedpanda.simplyjetpacks.lists;

import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.IArmorMaterial;
import net.minecraft.item.Item;
import net.minecraft.item.Items;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public enum ArmorMaterialList implements IArmorMaterial
{
    PILOT_GOGGLES("pilot_goggles", 0, new int[]{0, 0, 0, 0}, 0, Items.field_151042_j, "item.armor.equip_leather", 0.0f, 0.0f),
    JETPACK("jetpack", 0, new int[]{0, 0, 2, 0}, 10, Items.field_151042_j, "item.armor.equip_iron", 0.0f, 0.0f),
    JETPACK_ARMORED("jetpack_armored", 0, new int[]{0, 0, 4, 0}, 10, Items.field_151042_j, "item.armor.equip_iron", 0.0f, 0.0f),
    JETPLATE("jetplate", 0, new int[]{0, 0, 12, 0}, 10, Items.field_151042_j, "item.armor.equip_iron", 3.0f, 3.0f);

    private final String name;
    private final int durability;
    private final int[] damageReductionAmounts;
    private int enchantability;
    private final Item repairItem;
    private final String equipSound;
    private final float toughness;
    private final float knockbackResistance;
    private static final int[] max_damage_array;

    private ArmorMaterialList(String name, int durability, int[] damageReductionAmounts, int enchantability, Item repairItem, String equipSound, float toughness, float knockbackResistance) {
        this.name = name;
        this.durability = durability;
        this.damageReductionAmounts = damageReductionAmounts;
        this.enchantability = enchantability;
        this.repairItem = repairItem;
        this.equipSound = equipSound;
        this.toughness = toughness;
        this.knockbackResistance = knockbackResistance;
    }

    public static void setStats(ArmorMaterialList armor, boolean isArmored, int enchant, int defense) {
        defense = isArmored ? defense : (defense - 1) / 2;
        armor.enchantability = enchant;
        armor.damageReductionAmounts[EquipmentSlotType.CHEST.func_188454_b()] = defense;
    }

    @OnlyIn(value=Dist.CLIENT)
    public String func_200897_d() {
        return "simplyjetpacks:" + this.name;
    }

    public int func_200896_a(EquipmentSlotType slotIn) {
        return max_damage_array[slotIn.func_188454_b()] * this.durability;
    }

    public int func_200902_b(EquipmentSlotType slotIn) {
        return this.damageReductionAmounts[slotIn.func_188454_b()];
    }

    public int func_200900_a() {
        return this.enchantability;
    }

    public Ingredient func_200898_c() {
        return Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{this.repairItem});
    }

    public SoundEvent func_200899_b() {
        return new SoundEvent(new ResourceLocation(this.equipSound));
    }

    public float func_200901_e() {
        return this.toughness;
    }

    public float func_230304_f_() {
        return this.knockbackResistance;
    }

    static {
        max_damage_array = new int[]{13, 15, 16, 11};
    }
}

