/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.common.loot;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import net.minecraft.loot.ILootSerializer;
import net.minecraft.loot.LootConditionType;
import net.minecraft.loot.LootContext;
import net.minecraft.loot.conditions.ILootCondition;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;

public class LootTableIdCondition
implements ILootCondition {
    public static final LootConditionType LOOT_TABLE_ID = new LootConditionType((ILootSerializer)new Serializer());
    public static final ResourceLocation UNKNOWN_LOOT_TABLE = new ResourceLocation("forge", "unknown_loot_table");
    private final ResourceLocation targetLootTableId;

    private LootTableIdCondition(ResourceLocation targetLootTableId) {
        this.targetLootTableId = targetLootTableId;
    }

    public LootConditionType func_230419_b_() {
        return LOOT_TABLE_ID;
    }

    public boolean test(LootContext lootContext) {
        return lootContext.getQueriedLootTableId().equals((Object)this.targetLootTableId);
    }

    public static Builder builder(ResourceLocation targetLootTableId) {
        return new Builder(targetLootTableId);
    }

    public static class Serializer
    implements ILootSerializer<LootTableIdCondition> {
        public void serialize(JsonObject object, LootTableIdCondition instance, JsonSerializationContext ctx) {
            object.addProperty("loot_table_id", instance.targetLootTableId.toString());
        }

        public LootTableIdCondition deserialize(JsonObject object, JsonDeserializationContext ctx) {
            return new LootTableIdCondition(new ResourceLocation(JSONUtils.func_151200_h((JsonObject)object, (String)"loot_table_id")));
        }
    }

    public static class Builder
    implements ILootCondition.IBuilder {
        private final ResourceLocation targetLootTableId;

        public Builder(ResourceLocation targetLootTableId) {
            if (targetLootTableId == null) {
                throw new IllegalArgumentException("Target loot table must not be null");
            }
            this.targetLootTableId = targetLootTableId;
        }

        public ILootCondition build() {
            return new LootTableIdCondition(this.targetLootTableId);
        }
    }
}

