/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.common.extensions;

import java.util.Collection;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityClassification;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.item.ArmorStandEntity;
import net.minecraft.entity.item.BoatEntity;
import net.minecraft.entity.item.EnderCrystalEntity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.item.ItemFrameEntity;
import net.minecraft.entity.item.LeashKnotEntity;
import net.minecraft.entity.item.PaintingEntity;
import net.minecraft.entity.item.minecart.AbstractMinecartEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.item.SpawnEggItem;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.entity.PartEntity;

public interface IForgeEntity
extends ICapabilitySerializable<CompoundNBT> {
    default public Entity getEntity() {
        return (Entity)this;
    }

    @Override
    default public void deserializeNBT(CompoundNBT nbt) {
        this.getEntity().func_70020_e(nbt);
    }

    @Override
    default public CompoundNBT serializeNBT() {
        CompoundNBT ret = new CompoundNBT();
        String id = this.getEntity().func_70022_Q();
        if (id != null) {
            ret.func_74778_a("id", this.getEntity().func_70022_Q());
        }
        return this.getEntity().func_189511_e(ret);
    }

    public boolean canUpdate();

    public void canUpdate(boolean var1);

    @Nullable
    public Collection<ItemEntity> captureDrops();

    public Collection<ItemEntity> captureDrops(@Nullable Collection<ItemEntity> var1);

    public CompoundNBT getPersistentData();

    default public boolean shouldRiderSit() {
        return true;
    }

    default public ItemStack getPickedResult(RayTraceResult target) {
        if (this instanceof PaintingEntity) {
            return new ItemStack((IItemProvider)Items.field_151159_an);
        }
        if (this instanceof LeashKnotEntity) {
            return new ItemStack((IItemProvider)Items.field_151058_ca);
        }
        if (this instanceof ItemFrameEntity) {
            ItemStack held = ((ItemFrameEntity)this).func_82335_i();
            if (held.func_190926_b()) {
                return new ItemStack((IItemProvider)Items.field_151160_bD);
            }
            return held.func_77946_l();
        }
        if (this instanceof AbstractMinecartEntity) {
            return ((AbstractMinecartEntity)this).getCartItem();
        }
        if (this instanceof BoatEntity) {
            return new ItemStack((IItemProvider)((BoatEntity)this).func_184455_j());
        }
        if (this instanceof ArmorStandEntity) {
            return new ItemStack((IItemProvider)Items.field_179565_cj);
        }
        if (this instanceof EnderCrystalEntity) {
            return new ItemStack((IItemProvider)Items.field_185158_cP);
        }
        SpawnEggItem egg = SpawnEggItem.func_200889_b((EntityType)this.getEntity().func_200600_R());
        if (egg != null) {
            return new ItemStack((IItemProvider)egg);
        }
        return ItemStack.field_190927_a;
    }

    default public boolean canRiderInteract() {
        return false;
    }

    default public boolean canBeRiddenInWater(Entity rider) {
        return this.getEntity().func_205710_ba();
    }

    public boolean canTrample(BlockState var1, BlockPos var2, float var3);

    default public EntityClassification getClassification(boolean forSpawnCount) {
        return this.getEntity().func_200600_R().func_220339_d();
    }

    public boolean isAddedToWorld();

    public void onAddedToWorld();

    public void onRemovedFromWorld();

    public void revive();

    default public boolean isMultipartEntity() {
        return false;
    }

    @Nullable
    default public PartEntity<?>[] getParts() {
        return null;
    }
}

