/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.common.brewing;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.NonNullList;
import net.minecraftforge.common.brewing.BrewingRecipe;
import net.minecraftforge.common.brewing.IBrewingRecipe;
import net.minecraftforge.common.brewing.VanillaBrewingRecipe;

public class BrewingRecipeRegistry {
    private static List<IBrewingRecipe> recipes = new ArrayList<IBrewingRecipe>();

    public static boolean addRecipe(Ingredient input, Ingredient ingredient, ItemStack output) {
        return BrewingRecipeRegistry.addRecipe(new BrewingRecipe(input, ingredient, output));
    }

    public static boolean addRecipe(IBrewingRecipe recipe) {
        return recipes.add(recipe);
    }

    public static ItemStack getOutput(ItemStack input, ItemStack ingredient) {
        if (input.func_190926_b() || input.func_190916_E() != 1) {
            return ItemStack.field_190927_a;
        }
        if (ingredient.func_190926_b()) {
            return ItemStack.field_190927_a;
        }
        for (IBrewingRecipe recipe : recipes) {
            ItemStack output = recipe.getOutput(input, ingredient);
            if (output.func_190926_b()) continue;
            return output;
        }
        return ItemStack.field_190927_a;
    }

    public static boolean hasOutput(ItemStack input, ItemStack ingredient) {
        return !BrewingRecipeRegistry.getOutput(input, ingredient).func_190926_b();
    }

    public static boolean canBrew(NonNullList<ItemStack> inputs, ItemStack ingredient, int[] inputIndexes) {
        if (ingredient.func_190926_b()) {
            return false;
        }
        for (int i : inputIndexes) {
            if (!BrewingRecipeRegistry.hasOutput((ItemStack)inputs.get(i), ingredient)) continue;
            return true;
        }
        return false;
    }

    public static void brewPotions(NonNullList<ItemStack> inputs, ItemStack ingredient, int[] inputIndexes) {
        for (int i : inputIndexes) {
            ItemStack output = BrewingRecipeRegistry.getOutput((ItemStack)inputs.get(i), ingredient);
            if (output.func_190926_b()) continue;
            inputs.set(i, (Object)output);
        }
    }

    public static boolean isValidIngredient(ItemStack stack) {
        if (stack.func_190926_b()) {
            return false;
        }
        for (IBrewingRecipe recipe : recipes) {
            if (!recipe.isIngredient(stack)) continue;
            return true;
        }
        return false;
    }

    public static boolean isValidInput(ItemStack stack) {
        if (stack.func_190916_E() != 1) {
            return false;
        }
        for (IBrewingRecipe recipe : recipes) {
            if (!recipe.isInput(stack)) continue;
            return true;
        }
        return false;
    }

    public static List<IBrewingRecipe> getRecipes() {
        return Collections.unmodifiableList(recipes);
    }

    static {
        BrewingRecipeRegistry.addRecipe(new VanillaBrewingRecipe());
    }
}

