/*
 * Decompiled with CFR 0.152.
 */
package owmii.losttrinkets.entity;

import java.util.EnumSet;
import javax.annotation.Nullable;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.ILivingEntityData;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.controller.MovementController;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.HurtByTargetGoal;
import net.minecraft.entity.ai.goal.LookAtGoal;
import net.minecraft.entity.ai.goal.SwimGoal;
import net.minecraft.entity.monster.MonsterEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.util.DamageSource;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.World;
import owmii.losttrinkets.entity.DarkEntity;

public class DarkVexEntity
extends DarkEntity {
    protected static final DataParameter<Byte> VEX_FLAGS = EntityDataManager.func_187226_a(DarkVexEntity.class, (IDataSerializer)DataSerializers.field_187191_a);
    @Nullable
    private BlockPos boundOrigin;

    public DarkVexEntity(EntityType<? extends CreatureEntity> type, World world) {
        super(type, world);
        this.field_70765_h = new MoveHelperController(this);
    }

    public static AttributeModifierMap.MutableAttribute getAttribute() {
        return MonsterEntity.func_234295_eP_().func_233815_a_(Attributes.field_233818_a_, 20.0).func_233815_a_(Attributes.field_233823_f_, 8.0);
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(0, (Goal)new SwimGoal((MobEntity)this));
        this.field_70714_bg.func_75776_a(4, (Goal)new ChargeAttackGoal());
        this.field_70714_bg.func_75776_a(8, (Goal)new MoveRandomGoal());
        this.field_70714_bg.func_75776_a(9, (Goal)new LookAtGoal((MobEntity)this, MobEntity.class, 3.0f, 1.0f));
        this.field_70714_bg.func_75776_a(10, (Goal)new LookAtGoal((MobEntity)this, PlayerEntity.class, 8.0f));
        this.field_70715_bh.func_75776_a(1, (Goal)new HurtByTargetGoal((CreatureEntity)this, new Class[]{PlayerEntity.class}).func_220794_a(new Class[0]));
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(VEX_FLAGS, (Object)0);
    }

    @Override
    public void func_70071_h_() {
        this.field_70145_X = true;
        super.func_70071_h_();
        this.field_70145_X = false;
        this.func_189654_d(true);
    }

    @Nullable
    public BlockPos getBoundOrigin() {
        return this.boundOrigin;
    }

    public void setBoundOrigin(@Nullable BlockPos boundOriginIn) {
        this.boundOrigin = boundOriginIn;
    }

    private boolean getVexFlag(int mask) {
        byte i = (Byte)this.field_70180_af.func_187225_a(VEX_FLAGS);
        return (i & mask) != 0;
    }

    private void setVexFlag(int mask, boolean value) {
        int i = ((Byte)this.field_70180_af.func_187225_a(VEX_FLAGS)).byteValue();
        i = value ? (i |= mask) : (i &= ~mask);
        this.field_70180_af.func_187227_b(VEX_FLAGS, (Object)((byte)(i & 0xFF)));
    }

    public boolean isCharging() {
        return this.getVexFlag(1);
    }

    public void setCharging(boolean charging) {
        this.setVexFlag(1, charging);
    }

    public void func_70642_aH() {
        if (this.field_70146_Z.nextInt(7) == 0) {
            super.func_70642_aH();
        }
    }

    protected SoundEvent func_184639_G() {
        return SoundEvents.field_191264_hc;
    }

    protected SoundEvent func_184615_bR() {
        return SoundEvents.field_191266_he;
    }

    protected SoundEvent func_184601_bQ(DamageSource source) {
        return SoundEvents.field_191267_hf;
    }

    public float func_70013_c() {
        return 1.0f;
    }

    @Nullable
    public ILivingEntityData func_213386_a(IServerWorld world, DifficultyInstance difficulty, SpawnReason reason, @Nullable ILivingEntityData data, @Nullable CompoundNBT nbt) {
        this.func_180481_a(difficulty);
        this.func_180483_b(difficulty);
        return super.func_213386_a(world, difficulty, reason, data, nbt);
    }

    protected void func_180481_a(DifficultyInstance difficulty) {
        this.func_184201_a(EquipmentSlotType.MAINHAND, new ItemStack((IItemProvider)Items.field_151040_l));
        this.func_184642_a(EquipmentSlotType.MAINHAND, 0.0f);
    }

    class MoveRandomGoal
    extends Goal {
        public MoveRandomGoal() {
            this.func_220684_a(EnumSet.of(Goal.Flag.MOVE));
        }

        public boolean func_75250_a() {
            return !DarkVexEntity.this.func_70605_aq().func_75640_a() && DarkVexEntity.this.field_70146_Z.nextInt(7) == 0;
        }

        public boolean func_75253_b() {
            return false;
        }

        public void func_75246_d() {
            BlockPos blockpos = DarkVexEntity.this.getBoundOrigin();
            if (blockpos == null) {
                blockpos = DarkVexEntity.this.func_233580_cy_();
            }
            for (int i = 0; i < 3; ++i) {
                BlockPos pos = blockpos.func_177982_a(DarkVexEntity.this.field_70146_Z.nextInt(15) - 7, DarkVexEntity.this.field_70146_Z.nextInt(11) - 5, DarkVexEntity.this.field_70146_Z.nextInt(15) - 7);
                if (!DarkVexEntity.this.field_70170_p.func_175623_d(pos)) continue;
                DarkVexEntity.this.field_70765_h.func_75642_a((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5, 0.25);
                if (DarkVexEntity.this.func_70638_az() != null) break;
                DarkVexEntity.this.func_70671_ap().func_75650_a((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5, 180.0f, 20.0f);
                break;
            }
        }
    }

    class MoveHelperController
    extends MovementController {
        public MoveHelperController(DarkVexEntity vex) {
            super((MobEntity)vex);
        }

        public void func_75641_c() {
            if (this.field_188491_h == MovementController.Action.MOVE_TO) {
                Vector3d vector3d = new Vector3d(this.field_75646_b - DarkVexEntity.this.func_226277_ct_(), this.field_75647_c - DarkVexEntity.this.func_226278_cu_(), this.field_75644_d - DarkVexEntity.this.func_226281_cx_());
                double d0 = vector3d.func_72433_c();
                if (d0 < DarkVexEntity.this.func_174813_aQ().func_72320_b()) {
                    this.field_188491_h = MovementController.Action.WAIT;
                    DarkVexEntity.this.func_213317_d(DarkVexEntity.this.func_213322_ci().func_186678_a(0.5));
                } else {
                    DarkVexEntity.this.func_213317_d(DarkVexEntity.this.func_213322_ci().func_178787_e(vector3d.func_186678_a(this.field_75645_e * 0.05 / d0)));
                    if (DarkVexEntity.this.func_70638_az() == null) {
                        Vector3d vector3d1 = DarkVexEntity.this.func_213322_ci();
                        DarkVexEntity.this.field_70761_aq = DarkVexEntity.this.field_70177_z = -((float)MathHelper.func_181159_b((double)vector3d1.field_72450_a, (double)vector3d1.field_72449_c)) * 57.295776f;
                    } else {
                        double d2 = DarkVexEntity.this.func_70638_az().func_226277_ct_() - DarkVexEntity.this.func_226277_ct_();
                        double d1 = DarkVexEntity.this.func_70638_az().func_226281_cx_() - DarkVexEntity.this.func_226281_cx_();
                        DarkVexEntity.this.field_70761_aq = DarkVexEntity.this.field_70177_z = -((float)MathHelper.func_181159_b((double)d2, (double)d1)) * 57.295776f;
                    }
                }
            }
        }
    }

    class ChargeAttackGoal
    extends Goal {
        public ChargeAttackGoal() {
            this.func_220684_a(EnumSet.of(Goal.Flag.MOVE));
        }

        public boolean func_75250_a() {
            if (DarkVexEntity.this.func_70638_az() != null && !DarkVexEntity.this.func_70605_aq().func_75640_a() && DarkVexEntity.this.field_70146_Z.nextInt(7) == 0) {
                return DarkVexEntity.this.func_70068_e((Entity)DarkVexEntity.this.func_70638_az()) > 4.0;
            }
            return false;
        }

        public boolean func_75253_b() {
            return DarkVexEntity.this.func_70605_aq().func_75640_a() && DarkVexEntity.this.isCharging() && DarkVexEntity.this.func_70638_az() != null && DarkVexEntity.this.func_70638_az().func_70089_S();
        }

        public void func_75249_e() {
            LivingEntity livingentity = DarkVexEntity.this.func_70638_az();
            if (livingentity != null) {
                Vector3d vector3d = livingentity.func_174824_e(1.0f);
                DarkVexEntity.this.field_70765_h.func_75642_a(vector3d.field_72450_a, vector3d.field_72448_b, vector3d.field_72449_c, 1.0);
                DarkVexEntity.this.setCharging(true);
                DarkVexEntity.this.func_184185_a(SoundEvents.field_191265_hd, 1.0f, 1.0f);
            }
        }

        public void func_75251_c() {
            DarkVexEntity.this.setCharging(false);
        }

        public void func_75246_d() {
            LivingEntity livingentity = DarkVexEntity.this.func_70638_az();
            if (livingentity != null) {
                if (DarkVexEntity.this.func_174813_aQ().func_72326_a(livingentity.func_174813_aQ())) {
                    DarkVexEntity.this.func_70652_k((Entity)livingentity);
                    DarkVexEntity.this.setCharging(false);
                } else {
                    double d0 = DarkVexEntity.this.func_70068_e((Entity)livingentity);
                    if (d0 < 9.0) {
                        Vector3d vector3d = livingentity.func_174824_e(1.0f);
                        DarkVexEntity.this.field_70765_h.func_75642_a(vector3d.field_72450_a, vector3d.field_72448_b, vector3d.field_72449_c, 1.0);
                    }
                }
            }
        }
    }
}

