/*
 * Decompiled with CFR 0.152.
 */
package com.unrealdinnerbone.jamd;

import com.unrealdinnerbone.jamd.JAMDRegistry;
import com.unrealdinnerbone.jamd.data.DataEvent;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.gen.GenerationStage;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.world.BiomeLoadingEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;

@Mod(value="jamd")
public class JAMD {
    public static final String MOD_ID = "jamd";
    private static final ForgeConfigSpec.Builder builder = new ForgeConfigSpec.Builder();
    private static final ForgeConfigSpec.BooleanValue FLOWERS = builder.comment("Stop mods from adding custom flowers").define("flowers", true);
    private static final ForgeConfigSpec.BooleanValue STRUCTURES = builder.comment("Stop mods from adding surface structures").define("surface_structures", true);
    private static final ForgeConfigSpec.BooleanValue ENTITIES = builder.comment("Stop mods from adding entities").define("entities", true);
    private static final ForgeConfigSpec.BooleanValue LAKES = builder.comment("Stop mods from adding lakes").define("lakes", true);
    private static final ForgeConfigSpec.BooleanValue CARVERS_AIR = builder.comment("Stop mods air carvers").define("carvers_air", true);
    public static final ResourceLocation DIM_ID = new ResourceLocation("jamd", "mining");

    public JAMD() {
        JAMDRegistry.REGISTRIES.forEach(deferredRegister -> deferredRegister.register(FMLJavaModLoadingContext.get().getModEventBus()));
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, builder.build());
        MinecraftForge.EVENT_BUS.addListener(EventPriority.LOWEST, this::onBiomesLoad);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(DataEvent::onData);
    }

    public void onBiomesLoad(BiomeLoadingEvent biomeLoadingEvent) {
        if (biomeLoadingEvent.getName() != null && biomeLoadingEvent.getName().toString().equals(DIM_ID.toString())) {
            biomeLoadingEvent.getGeneration().getStructures().clear();
            if (((Boolean)FLOWERS.get()).booleanValue()) {
                biomeLoadingEvent.getGeneration().getFeatures(GenerationStage.Decoration.VEGETAL_DECORATION).clear();
            }
            if (((Boolean)STRUCTURES.get()).booleanValue()) {
                biomeLoadingEvent.getGeneration().getFeatures(GenerationStage.Decoration.SURFACE_STRUCTURES).clear();
            }
            if (((Boolean)ENTITIES.get()).booleanValue()) {
                biomeLoadingEvent.getSpawns().getSpawnerTypes().forEach(spawnerType -> biomeLoadingEvent.getSpawns().getSpawner(spawnerType).clear());
            }
            if (((Boolean)LAKES.get()).booleanValue()) {
                biomeLoadingEvent.getGeneration().getFeatures(GenerationStage.Decoration.LAKES).clear();
            }
            if (((Boolean)CARVERS_AIR.get()).booleanValue()) {
                biomeLoadingEvent.getGeneration().getCarvers(GenerationStage.Carving.AIR).clear();
            }
        }
    }
}

