/*
 * Decompiled with CFR 0.152.
 */
package xyz.brassgoggledcoders.transport.tileentity.boat;

import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import xyz.brassgoggledcoders.transport.api.TransportCapabilities;
import xyz.brassgoggledcoders.transport.api.navigation.INavigationNetwork;
import xyz.brassgoggledcoders.transport.api.navigation.INavigationPoint;
import xyz.brassgoggledcoders.transport.content.TransportNavigationPoints;

public class BuoyTileEntity
extends TileEntity {
    private UUID navigationPointUniqueId;

    public BuoyTileEntity(TileEntityType<?> tileEntityType) {
        super(tileEntityType);
    }

    public void interact(PlayerEntity playerEntity) {
        if (this.navigationPointUniqueId == null) {
            this.create(playerEntity);
        }
        if (this.navigationPointUniqueId != null && this.func_145831_w() != null) {
            this.func_145831_w().getCapability(TransportCapabilities.NAVIGATION_NETWORK).ifPresent(network -> {
                INavigationPoint navigationPoint = network.getNavigationPoint(this.navigationPointUniqueId);
                if (navigationPoint != null) {
                    network.setKnownNavigationPoint(playerEntity, navigationPoint, true);
                }
            });
        }
    }

    public void setup(@Nullable PlayerEntity playerEntity) {
        this.create(playerEntity);
    }

    public void destroy() {
        if (this.navigationPointUniqueId != null && this.func_145831_w() != null) {
            this.func_145831_w().getCapability(TransportCapabilities.NAVIGATION_NETWORK).ifPresent(network -> network.removeNavigationPoint(this.navigationPointUniqueId));
        }
    }

    protected void create(@Nullable PlayerEntity playerEntity) {
        if (this.func_145831_w() != null) {
            this.navigationPointUniqueId = this.func_145831_w().getCapability(TransportCapabilities.NAVIGATION_NETWORK).resolve().flatMap(network -> this.createNavigationPoint((INavigationNetwork)network).map(navigationPoint -> {
                network.addNavigationPoint((INavigationPoint)navigationPoint);
                navigationPoint.setPosition(this.func_174877_v());
                if (playerEntity != null) {
                    network.setKnownNavigationPoint(playerEntity, (INavigationPoint)navigationPoint, true);
                }
                return navigationPoint.getUniqueId();
            })).orElse(null);
        }
    }

    protected Optional<INavigationPoint> createNavigationPoint(INavigationNetwork navigationNetwork) {
        return TransportNavigationPoints.RANDOM.map(navigationNetwork::createPoint);
    }
}

