/*
 * Decompiled with CFR 0.152.
 */
package xyz.brassgoggledcoders.transport.screen.locomotive;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.IGuiEventListener;
import net.minecraft.client.gui.screen.inventory.ContainerScreen;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.fluid.Fluid;
import net.minecraft.inventory.container.Container;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.client.gui.GuiUtils;
import xyz.brassgoggledcoders.transport.Transport;
import xyz.brassgoggledcoders.transport.api.engine.EngineState;
import xyz.brassgoggledcoders.transport.container.locomotive.SteamLocomotiveContainer;
import xyz.brassgoggledcoders.transport.content.TransportFluids;
import xyz.brassgoggledcoders.transport.content.TransportText;
import xyz.brassgoggledcoders.transport.screen.locomotive.PowerButton;
import xyz.brassgoggledcoders.transport.screen.locomotive.SpeedWidget;
import xyz.brassgoggledcoders.transport.screen.util.FluidRenderer;

public class SteamLocomotiveScreen
extends ContainerScreen<SteamLocomotiveContainer> {
    private static final ResourceLocation BACKGROUND = Transport.rl("textures/screen/steam_locomotive.png");
    private SpeedWidget speedWidget;

    public SteamLocomotiveScreen(SteamLocomotiveContainer screenContainer, PlayerInventory playerInventory, ITextComponent title) {
        super((Container)screenContainer, playerInventory, title);
    }

    protected void func_231160_c_() {
        super.func_231160_c_();
        this.func_230480_a_((Widget)new PowerButton(this.field_147003_i + 73, this.field_147009_r + 36, 12, 12, ((SteamLocomotiveContainer)this.func_212873_a_()).getOn(), ((SteamLocomotiveContainer)this.func_212873_a_()).getPropertyManager()));
        this.speedWidget = new SpeedWidget(this, this.field_147003_i + 91, this.field_147009_r + 17, 77, 43);
        this.func_230480_a_(this.speedWidget);
    }

    protected void func_230450_a_(@Nonnull MatrixStack matrixStack, float partialTicks, int x, int y) {
        int burnedAmount;
        RenderSystem.pushMatrix();
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.getMinecraft().func_110434_K().func_110577_a(BACKGROUND);
        int i = (this.field_230708_k_ - this.field_146999_f) / 2;
        int j = (this.field_230709_l_ - this.field_147000_g) / 2;
        this.func_238474_b_(matrixStack, i, j, 0, 0, this.field_146999_f, this.field_147000_g);
        if (!((SteamLocomotiveContainer)this.func_212873_a_()).isLocomotiveOn()) {
            this.func_238474_b_(matrixStack, i + 73, j + 36, 210, 30, 12, 12);
        }
        if ((burnedAmount = ((SteamLocomotiveContainer)this.func_212873_a_()).getFuelBurnedScaled()) > 0) {
            this.func_238474_b_(matrixStack, i + 76, j + 55, 184, 15, 7, burnedAmount);
        }
        FluidRenderer.renderFluid(matrixStack, ((SteamLocomotiveContainer)this.func_212873_a_()).getWater(), 7000, i + 30, j + 19, 20, 49);
        FluidRenderer.renderFluid(matrixStack, new FluidStack((Fluid)TransportFluids.STEAM.get(), ((SteamLocomotiveContainer)this.func_212873_a_()).getSteam()), 4000, i + 55, j + 21, 7, 47);
        this.getMinecraft().func_110434_K().func_110577_a(BACKGROUND);
        this.func_238474_b_(matrixStack, i + 30, j + 19, 177, 31, 20, 51);
        RenderSystem.popMatrix();
    }

    public void func_230430_a_(@Nonnull MatrixStack matrixStack, int mouseX, int mouseY, float partialTicks) {
        EngineState engineState;
        this.func_230446_a_(matrixStack);
        super.func_230430_a_(matrixStack, mouseX, mouseY, partialTicks);
        this.func_230459_a_(matrixStack, mouseX, mouseY);
        if (this.speedWidget.func_230449_g_() && (engineState = this.speedWidget.getEngineState()) != null) {
            GuiUtils.drawHoveringText((MatrixStack)matrixStack, Collections.singletonList(new TranslationTextComponent("screen.transport.speed", new Object[]{engineState.getDisplayName()})), (int)mouseX, (int)mouseY, (int)this.field_230708_k_, (int)this.field_230709_l_, (int)-1, (FontRenderer)Minecraft.func_71410_x().field_71466_p);
        }
        if (this.isIn(mouseX, mouseY, 30, 19, 20, 49)) {
            FluidStack waterStack = ((SteamLocomotiveContainer)this.func_212873_a_()).getWater();
            ArrayList tooltip = !waterStack.isEmpty() ? Lists.newArrayList((Object[])new ITextComponent[]{waterStack.getDisplayName(), new TranslationTextComponent("screen.transport.fluid.capacity", new Object[]{waterStack.getAmount(), 7000})}) : Lists.newArrayList((Object[])new ITextComponent[]{TransportText.SCREEN_FLUID_EMPTY});
            GuiUtils.drawHoveringText((MatrixStack)matrixStack, (List)tooltip, (int)mouseX, (int)mouseY, (int)this.field_230708_k_, (int)this.field_230709_l_, (int)-1, (FontRenderer)Minecraft.func_71410_x().field_71466_p);
        }
    }

    private boolean isIn(int mouseX, int mouseY, int xOffset, int yOffset, int width, int height) {
        return mouseX > xOffset + this.field_147003_i && mouseX < xOffset + this.field_147003_i + width && mouseY > yOffset + this.field_147009_r && mouseY < yOffset + this.field_147009_r + height;
    }

    protected void func_230451_b_(@Nonnull MatrixStack matrixStack, int x, int y) {
        this.field_230712_o_.func_243248_b(matrixStack, this.field_230704_d_, (float)this.field_238742_p_, (float)this.field_238743_q_, 0x404040);
    }

    public boolean func_231045_a_(double mouseX, double mouseY, int button, double dragX, double dragY) {
        if (!this.field_147007_t) {
            for (IGuiEventListener eventListener : this.func_231039_at__()) {
                if (!eventListener.func_231047_b_(mouseX, mouseY) || !eventListener.func_231045_a_(mouseX, mouseY, button, dragX, dragY)) continue;
                return true;
            }
        }
        return super.func_231045_a_(mouseX, mouseY, button, dragX, dragY);
    }
}

