/*
 * Decompiled with CFR 0.152.
 */
package xyz.brassgoggledcoders.transport.screen.locomotive;

import com.google.common.collect.Maps;
import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.Collections;
import java.util.EnumMap;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.fml.client.gui.GuiUtils;
import xyz.brassgoggledcoders.transport.api.engine.EngineState;
import xyz.brassgoggledcoders.transport.container.locomotive.SteamLocomotiveContainer;
import xyz.brassgoggledcoders.transport.network.property.Property;
import xyz.brassgoggledcoders.transport.network.property.PropertyManager;
import xyz.brassgoggledcoders.transport.screen.locomotive.SteamLocomotiveScreen;

public class SpeedWidget
extends Widget {
    private final SteamLocomotiveScreen screen;
    private final Property<Integer> speed;
    private final PropertyManager propertyManager;
    private final int originX;
    private final int originY;
    private final EnumMap<EngineState, Double> stateAngles;
    private double angle;

    public SpeedWidget(SteamLocomotiveScreen screen, int x, int y, int width, int height) {
        super(x, y, width, height, (ITextComponent)new StringTextComponent(""));
        this.screen = screen;
        this.originX = x + width / 2;
        this.originY = y + height;
        this.speed = ((SteamLocomotiveContainer)screen.func_212873_a_()).getSpeed();
        this.propertyManager = ((SteamLocomotiveContainer)screen.func_212873_a_()).getPropertyManager();
        this.stateAngles = Maps.newEnumMap(EngineState.class);
        for (EngineState engineState : EngineState.values()) {
            this.stateAngles.put(engineState, Math.toRadians((float)engineState.ordinal() * 30.0f - 90.0f));
        }
        this.angle = this.stateAngles.get((Object)EngineState.byId(this.speed.get()));
    }

    public void func_230430_a_(@Nonnull MatrixStack matrixStack, int mouseX, int mouseY, float partialTicks) {
        this.field_230692_n_ = mouseX >= this.field_230690_l_ && mouseY >= this.field_230691_m_ && mouseX < this.field_230690_l_ + this.field_230688_j_ && mouseY < this.field_230691_m_ + this.field_230689_k_;
        Integer speed = this.speed.get();
        if (!this.screen.func_231041_ay__()) {
            EngineState engineState = this.getEngineState();
            if (engineState == null) {
                if (speed != null) {
                    this.angle = this.stateAngles.get((Object)EngineState.byId(speed));
                }
            } else if (speed != null && engineState.ordinal() != speed.intValue()) {
                this.angle = this.stateAngles.get((Object)EngineState.byId(speed));
            }
        }
        matrixStack.func_227860_a_();
        matrixStack.func_227861_a_((double)(this.originX + 1), (double)(this.originY - 2), 0.0);
        matrixStack.func_227863_a_(Vector3f.field_229182_e_.func_229193_c_((float)this.angle));
        matrixStack.func_227861_a_(-3.5, -44.0, 0.0);
        this.func_238474_b_(matrixStack, 0, 0, 230, 8, 7, 46);
        matrixStack.func_227865_b_();
    }

    public void func_231000_a__(double mouseX, double mouseY) {
        EngineState newEngineState = this.getEngineState();
        Integer currentSpeed = this.speed.get();
        if (newEngineState != null) {
            this.angle = this.stateAngles.get((Object)newEngineState);
            this.propertyManager.updateServer(this.speed, newEngineState.ordinal());
        } else if (currentSpeed != null) {
            this.angle = this.stateAngles.get((Object)EngineState.byId(currentSpeed));
        }
    }

    protected void func_230983_a_(double mouseX, double mouseY, double dragX, double dragY) {
        this.angle = Math.atan2((double)this.originY - mouseY, mouseX - (double)this.originX) - 1.5707963267948966;
    }

    public void func_230443_a_(@Nonnull MatrixStack matrixStack, int mouseX, int mouseY) {
        EngineState engineState = this.getEngineState();
        if (engineState != null) {
            GuiUtils.drawHoveringText((MatrixStack)matrixStack, Collections.singletonList(new TranslationTextComponent("screen.transport.speed", new Object[]{engineState.getDisplayName()})), (int)mouseX, (int)mouseY, (int)this.screen.field_230708_k_, (int)this.screen.field_230709_l_, (int)-1, (FontRenderer)Minecraft.func_71410_x().field_71466_p);
        }
    }

    public EngineState getEngineState() {
        EngineState newEngineState = null;
        double shortedDistance = 1.0471975511965976;
        for (EngineState engineState : EngineState.values()) {
            double distance = Math.abs(this.angle - this.stateAngles.get((Object)engineState));
            if (!(distance < shortedDistance)) continue;
            shortedDistance = distance;
            newEngineState = engineState;
        }
        return newEngineState;
    }
}

