/*
 * Decompiled with CFR 0.152.
 */
package xyz.brassgoggledcoders.transport.recipe.jobsite;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.Objects;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.AdvancementRewards;
import net.minecraft.advancements.ICriterionInstance;
import net.minecraft.advancements.IRequirementsStrategy;
import net.minecraft.advancements.criterion.RecipeUnlockedTrigger;
import net.minecraft.data.IFinishedRecipe;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistryEntry;
import xyz.brassgoggledcoders.transport.recipe.SizedIngredient;

public class SingleItemSizedRecipeBuilder {
    private final ItemStack result;
    private final SizedIngredient ingredient;
    private final IRecipeSerializer<?> serializer;
    private Advancement.Builder advancementBuilder = null;

    public SingleItemSizedRecipeBuilder(IRecipeSerializer<?> serializerIn, SizedIngredient ingredient, ItemStack result) {
        this.serializer = serializerIn;
        this.result = result;
        this.ingredient = ingredient;
    }

    public SingleItemSizedRecipeBuilder addCriterion(String name, ICriterionInstance criterionIn) {
        if (this.advancementBuilder == null) {
            this.advancementBuilder = Advancement.Builder.func_200278_a();
        }
        this.advancementBuilder.func_200275_a(name, criterionIn);
        return this;
    }

    public void build(Consumer<IFinishedRecipe> consumer, String save) {
        ResourceLocation resourcelocation = ForgeRegistries.ITEMS.getKey((IForgeRegistryEntry)this.result.func_77973_b());
        if (new ResourceLocation(save).equals((Object)resourcelocation)) {
            throw new IllegalStateException("Single Item Sized Recipe " + save + " should remove its 'save' argument");
        }
        this.build(consumer, new ResourceLocation(save));
    }

    public void build(Consumer<IFinishedRecipe> consumer, ResourceLocation id) {
        this.validate(id);
        if (this.advancementBuilder != null) {
            this.advancementBuilder.func_200272_a(new ResourceLocation("recipes/root")).func_200275_a("has_the_recipe", (ICriterionInstance)RecipeUnlockedTrigger.func_235675_a_((ResourceLocation)id)).func_200271_a(AdvancementRewards.Builder.func_200280_c((ResourceLocation)id)).func_200270_a(IRequirementsStrategy.field_223215_b_);
        }
        consumer.accept(new Result(id, this.serializer, "", this.ingredient, this.result, this.advancementBuilder, new ResourceLocation(id.func_110624_b(), "recipes/" + this.getGroupPath(this.result) + id.func_110623_a())));
    }

    private String getGroupPath(ItemStack itemStack) {
        ItemGroup itemGroup = itemStack.func_77973_b().func_77640_w();
        if (itemGroup != null) {
            return itemGroup.func_200300_c() + "/";
        }
        return "";
    }

    private void validate(ResourceLocation id) {
        if (this.advancementBuilder != null && this.advancementBuilder.func_200277_c().isEmpty()) {
            throw new IllegalStateException("No way of obtaining recipe " + id);
        }
        if (this.result.func_190926_b()) {
            throw new IllegalStateException("Recipe has empty output");
        }
    }

    public static class Result
    implements IFinishedRecipe {
        private static final Gson GSON = new Gson();
        private final ResourceLocation id;
        private final String group;
        private final SizedIngredient ingredient;
        private final ItemStack result;
        private final Advancement.Builder advancementBuilder;
        private final ResourceLocation advancementId;
        private final IRecipeSerializer<?> serializer;

        public Result(ResourceLocation id, IRecipeSerializer<?> serializer, String group, SizedIngredient ingredient, ItemStack result, Advancement.Builder advancementBuilder, ResourceLocation advancementId) {
            this.id = id;
            this.serializer = serializer;
            this.group = group;
            this.ingredient = ingredient;
            this.result = result;
            this.advancementBuilder = advancementBuilder;
            this.advancementId = advancementId;
        }

        public void func_218610_a(@Nonnull JsonObject json) {
            if (!this.group.isEmpty()) {
                json.addProperty("group", this.group);
            }
            json.add("ingredient", this.ingredient.toJson());
            JsonObject resultElement = new JsonObject();
            resultElement.addProperty("item", Objects.requireNonNull(this.result.func_77973_b().getRegistryName()).toString());
            resultElement.addProperty("count", (Number)this.result.func_190916_E());
            if (this.result.func_77978_p() != null) {
                resultElement.add("nbt", (JsonElement)GSON.fromJson(this.result.func_77978_p().toString(), JsonObject.class));
            }
            json.add("result", (JsonElement)resultElement);
        }

        @Nonnull
        public ResourceLocation func_200442_b() {
            return this.id;
        }

        @Nonnull
        public IRecipeSerializer<?> func_218609_c() {
            return this.serializer;
        }

        @Nullable
        public JsonObject func_200440_c() {
            return this.advancementBuilder.func_200273_b();
        }

        @Nullable
        public ResourceLocation func_200443_d() {
            return this.advancementId;
        }
    }
}

