/*
 * Decompiled with CFR 0.152.
 */
package xyz.brassgoggledcoders.transport.network.property;

import java.util.function.Supplier;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.container.Container;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.fml.network.NetworkEvent;
import xyz.brassgoggledcoders.transport.network.property.IPropertyManaged;
import xyz.brassgoggledcoders.transport.network.property.PropertyType;
import xyz.brassgoggledcoders.transport.network.property.PropertyTypes;

public class UpdateServerContainerPropertyMessage {
    private final short windowId;
    private final PropertyType<?> propertyType;
    private final short property;
    private final Object value;

    public UpdateServerContainerPropertyMessage(short windowId, PropertyType<?> propertyType, short property, Object value) {
        this.windowId = windowId;
        this.propertyType = propertyType;
        this.property = property;
        this.value = value;
    }

    public static UpdateServerContainerPropertyMessage decode(PacketBuffer packetBuffer) {
        short windowId = packetBuffer.readShort();
        PropertyType<?> propertyType = PropertyTypes.getByIndex(packetBuffer.readShort());
        short property = packetBuffer.readShort();
        Object value = propertyType.getReader().apply(packetBuffer);
        return new UpdateServerContainerPropertyMessage(windowId, propertyType, property, value);
    }

    public void encode(PacketBuffer packetBuffer) {
        packetBuffer.writeShort((int)this.windowId);
        packetBuffer.writeShort((int)PropertyTypes.getIndex(this.propertyType));
        packetBuffer.writeShort((int)this.property);
        this.propertyType.attemptWrite(packetBuffer, this.value);
    }

    public boolean consume(Supplier<NetworkEvent.Context> contextSupplier) {
        contextSupplier.get().enqueueWork(() -> {
            ServerPlayerEntity playerEntity = ((NetworkEvent.Context)contextSupplier.get()).getSender();
            if (playerEntity != null) {
                Container container = playerEntity.field_71070_bA;
                if (container.field_75152_c == this.windowId && container instanceof IPropertyManaged) {
                    ((IPropertyManaged)container).getPropertyManager().update(this.propertyType, this.property, this.value);
                }
            }
        });
        return true;
    }
}

