/*
 * Decompiled with CFR 0.152.
 */
package xyz.brassgoggledcoders.transport.network.property;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.inventory.container.Container;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.fml.network.NetworkEvent;
import org.apache.commons.lang3.tuple.Triple;
import xyz.brassgoggledcoders.transport.Transport;
import xyz.brassgoggledcoders.transport.network.property.IPropertyManaged;
import xyz.brassgoggledcoders.transport.network.property.PropertyManager;
import xyz.brassgoggledcoders.transport.network.property.PropertyType;
import xyz.brassgoggledcoders.transport.network.property.PropertyTypes;

public class UpdateClientContainerPropertiesMessage {
    private final short windowId;
    private final List<Triple<PropertyType<?>, Short, Object>> updates;

    public UpdateClientContainerPropertiesMessage(short windowId, List<Triple<PropertyType<?>, Short, Object>> updates) {
        this.windowId = windowId;
        this.updates = updates;
    }

    public void encode(PacketBuffer packetBuffer) {
        packetBuffer.writeShort((int)this.windowId);
        ArrayList validUpdates = Lists.newArrayList();
        for (Triple<PropertyType<?>, Short, Object> triple : this.updates) {
            if (!((PropertyType)triple.getLeft()).isValid(triple.getRight())) continue;
            validUpdates.add(triple);
        }
        packetBuffer.writeShort(validUpdates.size());
        for (Triple triple : validUpdates) {
            packetBuffer.writeShort((int)PropertyTypes.getIndex((PropertyType)triple.getLeft()));
            packetBuffer.writeShort((int)((Short)triple.getMiddle()).shortValue());
            ((PropertyType)triple.getLeft()).attemptWrite(packetBuffer, triple.getRight());
        }
    }

    public boolean consume(Supplier<NetworkEvent.Context> contextSupplier) {
        contextSupplier.get().enqueueWork(() -> {
            ClientPlayerEntity playerEntity = Minecraft.func_71410_x().field_71439_g;
            if (playerEntity != null && playerEntity.field_71070_bA != null) {
                Container container = playerEntity.field_71070_bA;
                if (container.field_75152_c == this.windowId) {
                    if (container instanceof IPropertyManaged) {
                        PropertyManager propertyManager = ((IPropertyManaged)container).getPropertyManager();
                        for (Triple<PropertyType<?>, Short, Object> update : this.updates) {
                            propertyManager.update((PropertyType)update.getLeft(), (Short)update.getMiddle(), update.getRight());
                        }
                    } else {
                        Transport.LOGGER.info("Container is not instance of IPropertyManaged");
                    }
                }
            }
        });
        return true;
    }

    public static UpdateClientContainerPropertiesMessage decode(PacketBuffer packetBuffer) {
        short windowId = packetBuffer.readShort();
        short updateAmount = packetBuffer.readShort();
        ArrayList updates = Lists.newArrayList();
        for (short i = 0; i < updateAmount; i = (short)(i + 1)) {
            PropertyType<?> propertyType = PropertyTypes.getByIndex(packetBuffer.readShort());
            short propertyLocation = packetBuffer.readShort();
            Object object = propertyType.getReader().apply(packetBuffer);
            updates.add(Triple.of(propertyType, (Object)propertyLocation, object));
        }
        return new UpdateClientContainerPropertiesMessage(windowId, updates);
    }
}

