/*
 * Decompiled with CFR 0.152.
 */
package xyz.brassgoggledcoders.transport.network.property;

import java.util.function.Consumer;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import xyz.brassgoggledcoders.transport.network.property.PropertyType;

public final class Property<T> {
    private final PropertyType<T> propertyType;
    private final Supplier<T> getter;
    private final Consumer<T> setter;
    private T currentValue;
    private T lastKnownValue;

    public Property(PropertyType<T> propertyType) {
        this.propertyType = propertyType;
        this.getter = () -> this.currentValue;
        this.setter = value -> {
            this.currentValue = value;
        };
    }

    public Property(PropertyType<T> propertyType, Supplier<T> getter, Consumer<T> setter) {
        this.propertyType = propertyType;
        this.getter = getter;
        this.setter = setter;
    }

    public boolean isDirty() {
        T value = this.getter.get();
        boolean dirty = this.lastKnownValue == null || !this.propertyType.getEquals().test(value, this.lastKnownValue);
        this.lastKnownValue = value;
        return dirty;
    }

    @Nullable
    public T get() {
        return this.getter.get();
    }

    @Nonnull
    public T getOrElse(T other) {
        T gotten = this.getter.get();
        if (gotten != null) {
            return gotten;
        }
        return other;
    }

    public void set(T value) {
        this.setter.accept(value);
    }

    public PropertyType<T> getPropertyType() {
        return this.propertyType;
    }
}

