/*
 * Decompiled with CFR 0.152.
 */
package xyz.brassgoggledcoders.transport.network;

import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.fml.network.NetworkEvent;
import xyz.brassgoggledcoders.transport.api.TransportAPI;

public class ModuleTabClickedMessage {
    private final int entityId;
    private final UUID uniqueId;

    public ModuleTabClickedMessage(int entityId, UUID uniqueId) {
        this.entityId = entityId;
        this.uniqueId = uniqueId;
    }

    public void encode(PacketBuffer packetBuffer) {
        packetBuffer.writeInt(this.entityId);
        packetBuffer.func_179252_a(this.uniqueId);
    }

    public boolean consume(Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        context.setPacketHandled(true);
        context.enqueueWork(() -> {
            Entity entity;
            ServerPlayerEntity serverPlayerEntity = context.getSender();
            if (serverPlayerEntity != null && (entity = serverPlayerEntity.func_130014_f_().func_73045_a(this.entityId)) != null) {
                if (entity.func_110124_au().equals(this.uniqueId)) {
                    entity.getCapability(TransportAPI.MODULAR_ENTITY).ifPresent(modularEntity -> modularEntity.onTabClicked(serverPlayerEntity));
                } else {
                    entity.getCapability(TransportAPI.MODULAR_ENTITY).map(modularEntity -> modularEntity.getModuleInstance(this.uniqueId)).ifPresent(moduleInstance -> moduleInstance.onTabClicked(serverPlayerEntity));
                }
            }
        });
        return true;
    }

    public static ModuleTabClickedMessage decode(PacketBuffer packetBuffer) {
        return new ModuleTabClickedMessage(packetBuffer.readInt(), packetBuffer.func_179253_g());
    }
}

