/*
 * Decompiled with CFR 0.152.
 */
package xyz.brassgoggledcoders.transport.item;

import java.util.List;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.stats.Stats;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EntityPredicates;
import net.minecraft.util.Hand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.RayTraceContext;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.World;

public abstract class GenericBoatItem
extends Item {
    private static final Predicate<Entity> CAN_COLLIDE = EntityPredicates.field_180132_d.and(Entity::func_70067_L);

    public GenericBoatItem(Item.Properties properties) {
        super(properties);
    }

    @Nonnull
    public ActionResult<ItemStack> func_77659_a(@Nonnull World world, PlayerEntity player, @Nonnull Hand hand) {
        ItemStack itemStack = player.func_184586_b(hand);
        BlockRayTraceResult rayTraceResult = GenericBoatItem.func_219968_a((World)world, (PlayerEntity)player, (RayTraceContext.FluidMode)RayTraceContext.FluidMode.ANY);
        if (rayTraceResult.func_216346_c() == RayTraceResult.Type.MISS) {
            return ActionResult.func_226250_c_((Object)itemStack);
        }
        Vector3d vector3d = player.func_70676_i(1.0f);
        List list = world.func_175674_a((Entity)player, player.func_174813_aQ().func_216361_a(vector3d.func_186678_a(5.0)).func_186662_g(1.0), CAN_COLLIDE);
        if (!list.isEmpty()) {
            Vector3d vector3d1 = player.func_174824_e(1.0f);
            for (Entity entity : list) {
                AxisAlignedBB axisalignedbb = entity.func_174813_aQ().func_186662_g((double)entity.func_70111_Y());
                if (!axisalignedbb.func_72318_a(vector3d1)) continue;
                return ActionResult.func_226250_c_((Object)itemStack);
            }
        }
        if (rayTraceResult.func_216346_c() == RayTraceResult.Type.BLOCK) {
            Entity boatEntity = this.createBoatEntity(itemStack, world, (RayTraceResult)rayTraceResult);
            boatEntity.field_70177_z = player.field_70177_z;
            if (!world.func_226665_a__(boatEntity, boatEntity.func_174813_aQ().func_186662_g(-0.1))) {
                return ActionResult.func_226251_d_((Object)itemStack);
            }
            if (!world.field_72995_K) {
                world.func_217376_c(boatEntity);
                if (!player.field_71075_bZ.field_75098_d) {
                    itemStack.func_190918_g(1);
                }
            }
            player.func_71029_a(Stats.field_75929_E.func_199076_b((Object)this));
            return ActionResult.func_233538_a_((Object)itemStack, (boolean)world.func_201670_d());
        }
        return ActionResult.func_226250_c_((Object)itemStack);
    }

    @Nonnull
    protected abstract Entity createBoatEntity(ItemStack var1, World var2, RayTraceResult var3);
}

