/*
 * Decompiled with CFR 0.152.
 */
package xyz.brassgoggledcoders.transport.event;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.Iterator;
import java.util.List;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.screen.inventory.ContainerScreen;
import net.minecraft.client.renderer.ItemRenderer;
import net.minecraft.inventory.container.Container;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.GuiContainerEvent;
import net.minecraftforge.client.event.GuiScreenEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import xyz.brassgoggledcoders.transport.Transport;
import xyz.brassgoggledcoders.transport.api.module.ModuleTab;
import xyz.brassgoggledcoders.transport.screen.ModularScreenInfo;

@Mod.EventBusSubscriber(modid="transport", value={Dist.CLIENT}, bus=Mod.EventBusSubscriber.Bus.FORGE)
public class ClientForgeEventHandler {
    private static final ResourceLocation TABS = Transport.rl("textures/screen/components.png");

    @SubscribeEvent
    public static void onModuleTabClick(GuiScreenEvent.MouseClickedEvent mouseClickedEvent) {
        Screen screen = mouseClickedEvent.getGui();
        if (mouseClickedEvent.getButton() == 0 && screen instanceof ContainerScreen) {
            ContainerScreen containerScreen = (ContainerScreen)screen;
            Container container = containerScreen.func_212873_a_();
            ModularScreenInfo modularScreenInfo = ModularScreenInfo.getCurrent();
            if (modularScreenInfo.matches(container)) {
                int screenLeft = containerScreen.getGuiLeft();
                double mouseX = mouseClickedEvent.getMouseX();
                if (mouseX < (double)screenLeft && mouseX > (double)(screenLeft - 32)) {
                    ModuleTab moduleTab;
                    double difference;
                    int tab;
                    int screenTop = containerScreen.getGuiTop();
                    double mouseY = mouseClickedEvent.getMouseY();
                    if (mouseY > (double)screenTop && (tab = Math.floorDiv((int)Math.floor(difference = mouseY - (double)screenTop), 28)) >= 0 && tab < modularScreenInfo.getModuleTabList().size() && !(moduleTab = modularScreenInfo.getModuleTabList().get(tab)).getUniqueId().equals(modularScreenInfo.getPicked())) {
                        Transport.instance.networkHandler.sendTabClickedMessage(modularScreenInfo.getEntityId(), modularScreenInfo.getModuleTabList().get(tab));
                    }
                }
            }
        }
    }

    @SubscribeEvent
    public static void renderModuleTabs(GuiContainerEvent.DrawBackground drawScreenEvent) {
        ContainerScreen screen = drawScreenEvent.getGuiContainer();
        Container container = screen.func_212873_a_();
        ModularScreenInfo modularScreenInfo = ModularScreenInfo.getCurrent();
        if (modularScreenInfo.matches(container)) {
            ClientForgeEventHandler.loopTabs(screen, drawScreenEvent.getMatrixStack(), modularScreenInfo.getModuleTabList(), modularScreenInfo.getPicked());
        }
    }

    private static void loopTabs(ContainerScreen<?> screen, MatrixStack matrixStack, List<ModuleTab> tabs, UUID current) {
        if (!tabs.isEmpty()) {
            Iterator<ModuleTab> iterator = tabs.iterator();
            for (int i = 0; i < 5 && iterator.hasNext(); ++i) {
                ModuleTab moduleTab = iterator.next();
                ClientForgeEventHandler.renderTab(screen, moduleTab, matrixStack, moduleTab.getUniqueId().equals(current), i, screen.getGuiLeft() - 28, screen.getGuiTop() + i * 28);
            }
        }
    }

    private static void renderTab(ContainerScreen<?> screen, ModuleTab moduleTab, MatrixStack matrixStack, boolean selected, int tab, int x, int y) {
        RenderSystem.color3f((float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.enableBlend();
        Minecraft minecraft = Minecraft.func_71410_x();
        minecraft.func_110434_K().func_110577_a(TABS);
        screen.func_238474_b_(matrixStack, x, y, selected ? 32 : 0, tab * 28, 32, 28);
        ItemRenderer itemRenderer = minecraft.func_175599_af();
        itemRenderer.field_77023_b = 100.0f;
        RenderSystem.enableRescaleNormal();
        ItemStack itemstack = moduleTab.getDisplayStack();
        itemRenderer.func_180450_b(itemstack, x + 9, y + 6);
        itemRenderer.func_175030_a(minecraft.field_71466_p, itemstack, x + 9, y + 6);
        itemRenderer.field_77023_b = 0.0f;
    }
}

