/*
 * Decompiled with CFR 0.152.
 */
package xyz.brassgoggledcoders.transport.entity;

import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.item.BoatEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.network.IPacket;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.network.play.client.CSteerBoatPacket;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fml.network.NetworkHooks;
import xyz.brassgoggledcoders.transport.api.TransportCapabilities;
import xyz.brassgoggledcoders.transport.api.navigation.INavigationNetwork;
import xyz.brassgoggledcoders.transport.api.navigation.INavigationPoint;
import xyz.brassgoggledcoders.transport.api.navigation.INavigator;
import xyz.brassgoggledcoders.transport.api.navigation.Navigator;

public class TugBoatEntity
extends BoatEntity {
    private static final DataParameter<Optional<BlockPos>> TARGET_POS = EntityDataManager.func_187226_a(TugBoatEntity.class, (IDataSerializer)DataSerializers.field_187201_k);
    private final INavigator navigator = new Navigator();
    private final LazyOptional<INavigator> navigatorLazy = LazyOptional.of(() -> this.navigator);
    private LazyOptional<INavigationNetwork> navigationNetwork;

    public TugBoatEntity(EntityType<? extends BoatEntity> type, World world) {
        super(type, world);
    }

    public TugBoatEntity(EntityType<? extends TugBoatEntity> entityType, World world, double x, double y, double z) {
        this(entityType, world);
        this.func_70107_b(x, y, z);
        this.func_213317_d(Vector3d.field_186680_a);
        this.field_70169_q = x;
        this.field_70167_r = y;
        this.field_70166_s = z;
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(TARGET_POS, Optional.empty());
    }

    @Nonnull
    public IPacket<?> func_213297_N() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    public void func_184232_k(@Nonnull Entity passenger) {
        if (this.func_184196_w(passenger)) {
            float f = 0.8f;
            float f1 = (float)((!this.func_70089_S() ? (double)0.01f : this.func_70042_X()) + passenger.func_70033_W());
            Vector3d vector3d = new Vector3d((double)f, 0.0, 0.0).func_178785_b(-this.field_70177_z * ((float)Math.PI / 180) - 1.5707964f);
            passenger.func_70107_b(this.func_226277_ct_() + vector3d.field_72450_a, this.func_226278_cu_() + (double)f1, this.func_226281_cx_() + vector3d.field_72449_c);
            passenger.field_70177_z += this.field_184475_as;
            passenger.func_70034_d(passenger.func_70079_am() + this.field_184475_as);
            this.func_184454_a(passenger);
        }
    }

    public double func_70042_X() {
        return 0.0;
    }

    public void func_70071_h_() {
        Optional<INavigationPoint> currentPoint;
        INavigationNetwork navigationNetwork = this.func_130014_f_().getCapability(TransportCapabilities.NAVIGATION_NETWORK).resolve().orElse(null);
        if (!this.navigator.getCurrentPoint(navigationNetwork).isPresent()) {
            this.navigator.setCurrentPoint(this.func_130014_f_().getCapability(TransportCapabilities.NAVIGATION_NETWORK).map(INavigationNetwork::getNavigationPoints).flatMap(collection -> collection.stream().findFirst()).orElse(null));
        }
        if ((currentPoint = this.navigator.getCurrentPoint(navigationNetwork)).isPresent()) {
            if (this.getTargetPos().isPresent()) {
                BlockPos targetPos = this.getTargetPos().get();
                if (!targetPos.equals((Object)currentPoint.get().getPosition())) {
                    this.setTargetPos(currentPoint.get().getPosition());
                }
            } else {
                this.setTargetPos(currentPoint.get().getPosition());
            }
        } else {
            this.setTargetPos(null);
        }
        this.field_184471_aG = this.field_184469_aF;
        this.field_184469_aF = this.func_184449_t();
        this.field_184474_h = this.field_184469_aF != BoatEntity.Status.UNDER_WATER && this.field_184469_aF != BoatEntity.Status.UNDER_FLOWING_WATER ? 0.0f : (this.field_184474_h += 1.0f);
        if (!this.field_70170_p.field_72995_K && this.field_184474_h >= 60.0f) {
            this.func_184226_ay();
        }
        if (this.func_70268_h() > 0) {
            this.func_70265_b(this.func_70268_h() - 1);
        }
        if (this.func_70271_g() > 0.0f) {
            this.func_70266_a(this.func_70271_g() - 1.0f);
        }
        this.entityTick();
        this.func_184447_s();
        if (this.func_184186_bw()) {
            if (this.func_184188_bt().isEmpty() || !(this.func_184188_bt().get(0) instanceof PlayerEntity)) {
                this.func_184445_a(false, false);
            }
            this.func_184450_w();
            if (this.field_70170_p.field_72995_K) {
                this.func_184443_x();
                this.field_70170_p.func_184135_a((IPacket)new CSteerBoatPacket(this.func_184457_a(0), this.func_184457_a(1)));
            }
            this.func_213315_a(MoverType.SELF, this.func_213322_ci());
        } else if (this.getTargetPos().isPresent()) {
            this.func_184450_w();
            this.moveTowardsTarget();
            this.func_213315_a(MoverType.SELF, this.func_213322_ci());
        } else {
            this.func_213317_d(Vector3d.field_186680_a);
        }
        this.func_203057_r();
        this.func_145775_I();
    }

    public void entityTick() {
        if (!this.field_70170_p.field_72995_K) {
            this.func_70052_a(6, this.func_225510_bt_());
        }
        this.func_70030_z();
    }

    public boolean func_184186_bw() {
        Entity entity = this.func_184179_bs();
        if (this.getTargetPos().isPresent()) {
            return false;
        }
        if (entity instanceof PlayerEntity) {
            return ((PlayerEntity)entity).func_175144_cb();
        }
        return !this.field_70170_p.field_72995_K;
    }

    public void moveTowardsTarget() {
        this.getTargetPos().ifPresent(target -> {
            BlockPos entityPos = this.func_233580_cy_();
            int xOffset = entityPos.func_177958_n() - target.func_177958_n();
            int zOffset = entityPos.func_177952_p() - target.func_177952_p();
            float expectedYaw = (float)(-Math.toDegrees(Math.atan2(xOffset, zOffset)) + 180.0);
            this.field_70126_B = this.field_70177_z;
            if (Math.abs(xOffset) + Math.abs(zOffset) > 5) {
                float delta = expectedYaw - this.field_70177_z;
                if (delta < 0.0f) {
                    delta += 360.0f;
                } else if (delta > 360.0f) {
                    delta -= 360.0f;
                }
                if (delta < 180.0f && delta > 1.0f) {
                    this.field_70177_z += 1.0f;
                } else if (delta > 180.0f && delta < 359.0f) {
                    this.field_70177_z -= 1.0f;
                }
                float f = 0.05f;
                this.func_213317_d(this.func_213322_ci().func_72441_c((double)(MathHelper.func_76126_a((float)(-this.field_70177_z * ((float)Math.PI / 180))) * f), 0.0, (double)(MathHelper.func_76134_b((float)(this.field_70177_z * ((float)Math.PI / 180))) * f)));
            } else {
                this.getNavigationNetwork().map(this.navigator::getCurrentPoint).orElseGet(Optional::empty).ifPresent(point -> point.alertApproach(this.navigator, (Entity)this));
            }
        });
    }

    public void setTargetPos(BlockPos blockPos) {
        this.func_184212_Q().func_187227_b(TARGET_POS, Optional.ofNullable(blockPos));
    }

    public Optional<BlockPos> getTargetPos() {
        return (Optional)this.func_184212_Q().func_187225_a(TARGET_POS);
    }

    @Nonnull
    private LazyOptional<INavigationNetwork> getNavigationNetwork() {
        if (this.navigationNetwork == null) {
            this.navigationNetwork = this.func_130014_f_().getCapability(TransportCapabilities.NAVIGATION_NETWORK);
        }
        return this.navigationNetwork;
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
        if (cap == TransportCapabilities.NAVIGATOR) {
            return this.navigatorLazy.cast();
        }
        return super.getCapability(cap, side);
    }
}

