/*
 * Decompiled with CFR 0.152.
 */
package xyz.brassgoggledcoders.transport.entity;

import java.util.List;
import java.util.Objects;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.network.IPacket;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.GameRules;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fml.common.registry.IEntityAdditionalSpawnData;
import net.minecraftforge.fml.network.NetworkHooks;
import xyz.brassgoggledcoders.transport.api.TransportAPI;
import xyz.brassgoggledcoders.transport.api.TransportObjects;
import xyz.brassgoggledcoders.transport.api.cargo.CargoModuleInstance;
import xyz.brassgoggledcoders.transport.api.entity.IComparatorEntity;
import xyz.brassgoggledcoders.transport.api.entity.IHoldable;
import xyz.brassgoggledcoders.transport.api.entity.IModularEntity;
import xyz.brassgoggledcoders.transport.api.entity.ModularEntity;
import xyz.brassgoggledcoders.transport.api.module.ModuleInstance;
import xyz.brassgoggledcoders.transport.api.module.ModuleType;
import xyz.brassgoggledcoders.transport.content.TransportEntities;
import xyz.brassgoggledcoders.transport.content.TransportModuleSlots;
import xyz.brassgoggledcoders.transport.content.TransportModuleTypes;
import xyz.brassgoggledcoders.transport.entity.HulledBoatEntity;

public class ModularBoatEntity
extends HulledBoatEntity
implements IHoldable,
IEntityAdditionalSpawnData,
IItemProvider,
IComparatorEntity {
    private final LazyOptional<IModularEntity> modularEntityLazy;
    private final ModularEntity<ModularBoatEntity> modularEntity = new ModularEntity<ModularBoatEntity>(this, TransportModuleSlots.CARGO);

    public ModularBoatEntity(EntityType<? extends ModularBoatEntity> type, World world) {
        super(type, world);
        this.modularEntityLazy = LazyOptional.of(() -> this.modularEntity);
    }

    public ModularBoatEntity(World world, double x, double y, double z) {
        this((EntityType<? extends ModularBoatEntity>)TransportEntities.MODULAR_BOAT.get(), world);
        this.func_70107_b(x, y, z);
        this.func_213317_d(Vector3d.field_186680_a);
        this.field_70169_q = x;
        this.field_70167_r = y;
        this.field_70166_s = z;
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        this.modularEntity.getModuleInstances().forEach(ModuleInstance::tick);
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
        LazyOptional<T> capability;
        if (cap == TransportAPI.MODULAR_ENTITY) {
            return this.modularEntityLazy.cast();
        }
        if (side == Direction.DOWN || this.func_174811_aO().func_176734_d() == side) {
            List<LazyOptional<T>> preferredCapabilities = this.modularEntity.getCapabilities(cap, side, TransportModuleSlots.BACK.get());
            for (LazyOptional<T> lazyOptional : preferredCapabilities) {
                if (!lazyOptional.isPresent()) continue;
                return lazyOptional;
            }
        }
        if ((capability = this.modularEntity.getCapability(cap, side)).isPresent()) {
            return capability;
        }
        return super.getCapability(cap, side);
    }

    @Nonnull
    @ParametersAreNonnullByDefault
    public ActionResultType func_184199_a(PlayerEntity player, Vector3d vec, Hand hand) {
        ActionResultType actionResultType;
        CargoModuleInstance cargoModuleInstance = (CargoModuleInstance)this.getModularEntity().getModuleInstance(TransportModuleTypes.CARGO);
        if (cargoModuleInstance != null && (actionResultType = cargoModuleInstance.applyInteraction(player, vec, hand)) != ActionResultType.PASS) {
            return actionResultType;
        }
        return super.func_184199_a(player, vec, hand);
    }

    protected boolean func_184219_q(@Nonnull Entity passenger) {
        return this.modularEntity.getModuleInstance(TransportModuleSlots.CARGO.get()) == null && super.func_184219_q(passenger);
    }

    @Override
    public boolean showPaddles() {
        return this.getModularEntity().getModuleInstance(TransportModuleSlots.CARGO.get()) == null;
    }

    public boolean func_70097_a(@Nonnull DamageSource source, float amount) {
        if (this.func_180431_b(source)) {
            return false;
        }
        if (!this.field_70170_p.field_72995_K && this.func_70089_S()) {
            boolean flag;
            this.func_70269_c(-this.func_70267_i());
            this.func_70265_b(10);
            this.func_70266_a(this.func_70271_g() + amount * 10.0f);
            this.func_70018_K();
            boolean bl = flag = source.func_76346_g() instanceof PlayerEntity && ((PlayerEntity)source.func_76346_g()).field_71075_bZ.field_75098_d;
            if (flag || this.func_70271_g() > 40.0f) {
                if (!flag && this.field_70170_p.func_82736_K().func_223586_b(GameRules.field_223604_g)) {
                    CompoundNBT tagNBT;
                    ItemStack itemStack = this.modularEntity.asItemStack();
                    if (this.func_145818_k_()) {
                        itemStack.func_200302_a(this.func_200201_e());
                    }
                    if ((tagNBT = itemStack.func_77978_p()) == null) {
                        tagNBT = new CompoundNBT();
                    }
                    tagNBT.func_74778_a("hull_type", Objects.requireNonNull(this.getHullType().getRegistryName()).toString());
                    itemStack.func_77982_d(tagNBT);
                    this.func_199701_a_(itemStack);
                }
                this.func_70106_y();
            }
            return true;
        }
        return true;
    }

    @Override
    protected void func_70037_a(@Nonnull CompoundNBT compound) {
        super.func_70037_a(compound);
        this.modularEntity.deserializeNBT(compound.func_74775_l("modules"));
    }

    @Override
    protected void func_213281_b(@Nonnull CompoundNBT compound) {
        super.func_213281_b(compound);
        compound.func_218657_a("modules", (INBT)this.modularEntity.serializeNBT());
    }

    @Override
    @Nonnull
    public IPacket<?> func_213297_N() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    @Override
    public void writeSpawnData(PacketBuffer spawnData) {
        super.writeSpawnData(spawnData);
        this.modularEntity.write(spawnData);
    }

    @Override
    public void readSpawnData(PacketBuffer spawnData) {
        super.readSpawnData(spawnData);
        this.modularEntity.read(spawnData);
    }

    @Override
    public void onHeld() {
        for (ModuleInstance<?> moduleInstance : this.modularEntity.getModuleInstances()) {
            if (!(moduleInstance instanceof IHoldable)) continue;
            ((IHoldable)((Object)moduleInstance)).onHeld();
        }
    }

    @Override
    public void onRelease() {
        for (ModuleInstance<?> moduleInstance : this.modularEntity.getModuleInstances()) {
            if (!(moduleInstance instanceof IHoldable)) continue;
            ((IHoldable)((Object)moduleInstance)).onRelease();
        }
    }

    @Override
    public void push(float xPush, float zPush) {
        for (ModuleInstance<?> moduleInstance : this.modularEntity.getModuleInstances()) {
            if (!(moduleInstance instanceof IHoldable)) continue;
            ((IHoldable)((Object)moduleInstance)).push(xPush, zPush);
        }
    }

    @Nonnull
    public Item func_199767_j() {
        return (Item)TransportEntities.MODULAR_BOAT_ITEM.get();
    }

    @Override
    public int getComparatorLevel() {
        CargoModuleInstance cargoModuleInstance = (CargoModuleInstance)this.modularEntity.getModuleInstance((Supplier<ModuleType>)TransportObjects.CARGO_TYPE);
        return cargoModuleInstance != null ? cargoModuleInstance.getComparatorLevel() : -1;
    }

    public ModularEntity<ModularBoatEntity> getModularEntity() {
        return this.modularEntity;
    }
}

