/*
 * Decompiled with CFR 0.152.
 */
package xyz.brassgoggledcoders.transport.entity;

import java.util.List;
import java.util.Objects;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.block.AbstractRailBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.item.minecart.AbstractMinecartEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.network.IPacket;
import net.minecraft.network.PacketBuffer;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.ITag;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.GameRules;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fml.common.registry.IEntityAdditionalSpawnData;
import net.minecraftforge.fml.network.NetworkHooks;
import net.minecraftforge.registries.IForgeRegistry;
import xyz.brassgoggledcoders.transport.api.TransportAPI;
import xyz.brassgoggledcoders.transport.api.TransportObjects;
import xyz.brassgoggledcoders.transport.api.cargo.CargoModule;
import xyz.brassgoggledcoders.transport.api.cargo.CargoModuleInstance;
import xyz.brassgoggledcoders.transport.api.engine.EngineModuleInstance;
import xyz.brassgoggledcoders.transport.api.engine.PoweredState;
import xyz.brassgoggledcoders.transport.api.entity.HullType;
import xyz.brassgoggledcoders.transport.api.entity.IHoldable;
import xyz.brassgoggledcoders.transport.api.entity.IModularEntity;
import xyz.brassgoggledcoders.transport.api.entity.ModularEntity;
import xyz.brassgoggledcoders.transport.api.module.ModuleInstance;
import xyz.brassgoggledcoders.transport.api.module.ModuleType;
import xyz.brassgoggledcoders.transport.content.TransportEntities;
import xyz.brassgoggledcoders.transport.content.TransportHullTypes;
import xyz.brassgoggledcoders.transport.content.TransportItemTags;
import xyz.brassgoggledcoders.transport.content.TransportModuleSlots;
import xyz.brassgoggledcoders.transport.content.TransportModuleTypes;

public class CargoCarrierMinecartEntity
extends AbstractMinecartEntity
implements IHoldable,
IEntityAdditionalSpawnData,
IItemProvider {
    private final LazyOptional<IModularEntity> modularEntityLazy;
    private final ModularEntity<CargoCarrierMinecartEntity> modularEntity;
    private HullType hullType = TransportHullTypes.IRON.get();
    private double originalPushX;
    private double originalPushZ;
    private double pushX;
    private double pushZ;

    public CargoCarrierMinecartEntity(EntityType<CargoCarrierMinecartEntity> entityType, World world) {
        super(entityType, world);
        this.modularEntity = new ModularEntity<CargoCarrierMinecartEntity>(this, TransportModuleSlots.CARGO, TransportModuleSlots.BACK);
        this.modularEntityLazy = LazyOptional.of(() -> this.modularEntity);
    }

    public CargoCarrierMinecartEntity(World world, double x, double y, double z) {
        this(TransportEntities.CARGO_MINECART.get(), world, x, y, z);
    }

    public CargoCarrierMinecartEntity(EntityType<CargoCarrierMinecartEntity> entityType, World world, double x, double y, double z) {
        super(entityType, world, x, y, z);
        this.modularEntity = new ModularEntity<CargoCarrierMinecartEntity>(this, TransportModuleSlots.CARGO, TransportModuleSlots.BACK);
        this.modularEntityLazy = LazyOptional.of(() -> this.modularEntity);
    }

    @Nonnull
    public IPacket<?> func_213297_N() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    @Nonnull
    public AbstractMinecartEntity.Type func_184264_v() {
        return this.getModularEntity().getModuleInstance(TransportModuleTypes.CARGO) != null ? AbstractMinecartEntity.Type.CHEST : AbstractMinecartEntity.Type.RIDEABLE;
    }

    @Nonnull
    @ParametersAreNonnullByDefault
    public ActionResultType func_184199_a(PlayerEntity player, Vector3d vector3d, Hand hand) {
        EngineModuleInstance engineModuleInstance = (EngineModuleInstance)this.modularEntity.getModuleInstance((Supplier<ModuleType>)TransportObjects.ENGINE_TYPE);
        if (engineModuleInstance != null) {
            if (this.originalPushX == 0.0 && this.originalPushZ == 0.0) {
                this.originalPushX = this.func_226277_ct_() - player.func_226277_ct_();
                this.originalPushZ = this.func_226281_cx_() - player.func_226281_cx_();
            } else {
                ItemStack itemStack = player.func_184586_b(hand);
                if (!itemStack.func_190926_b() && itemStack.func_77973_b().func_206844_a(TransportItemTags.WRENCHES)) {
                    this.originalPushX = -this.originalPushX;
                    this.originalPushZ = -this.originalPushZ;
                    this.func_213317_d(this.func_213322_ci().func_216372_d(-1.0, 0.0, -1.0));
                    this.field_70177_z -= 180.0f;
                    return ActionResultType.SUCCESS;
                }
            }
        }
        if (vector3d.field_72448_b < 0.7) {
            switch (this.func_174811_aO()) {
                case NORTH: {
                    ActionResultType actionResultType;
                    if (!(vector3d.field_72450_a <= -0.49) || (actionResultType = this.modularEntity.applyPlayerInteraction(TransportModuleSlots.BACK, player, vector3d, hand)) == ActionResultType.PASS) break;
                    return actionResultType;
                }
                case SOUTH: {
                    ActionResultType actionResultType;
                    if (!(vector3d.field_72450_a >= 0.49) || (actionResultType = this.modularEntity.applyPlayerInteraction(TransportModuleSlots.BACK, player, vector3d, hand)) == ActionResultType.PASS) break;
                    return actionResultType;
                }
                case WEST: {
                    ActionResultType actionResultType;
                    if (!(vector3d.field_72449_c >= 0.49) || (actionResultType = this.modularEntity.applyPlayerInteraction(TransportModuleSlots.BACK, player, vector3d, hand)) == ActionResultType.PASS) break;
                    return actionResultType;
                }
                case EAST: {
                    ActionResultType actionResultType;
                    if (!(vector3d.field_72449_c <= -0.49) || (actionResultType = this.modularEntity.applyPlayerInteraction(TransportModuleSlots.BACK, player, vector3d, hand)) == ActionResultType.PASS) break;
                    return actionResultType;
                }
            }
        }
        return this.modularEntity.applyPlayerInteraction(TransportModuleSlots.CARGO, player, vector3d, hand);
    }

    @Nonnull
    @ParametersAreNonnullByDefault
    public ActionResultType func_184230_a(PlayerEntity player, Hand hand) {
        ActionResultType ret = super.func_184230_a(player, hand);
        if (ret.func_226246_a_() || !this.canBeRidden()) {
            return ret;
        }
        if (player.func_226563_dT_()) {
            return ActionResultType.PASS;
        }
        if (this.func_184207_aI()) {
            return ActionResultType.PASS;
        }
        if (!this.field_70170_p.field_72995_K) {
            return player.func_184220_m((Entity)this) ? ActionResultType.CONSUME : ActionResultType.PASS;
        }
        return ActionResultType.SUCCESS;
    }

    public boolean isPoweredCart() {
        return this.modularEntity.getModuleInstance((Supplier<ModuleType>)TransportObjects.ENGINE_TYPE) != null;
    }

    @Nonnull
    public BlockState func_174897_t() {
        CargoModuleInstance cargoModuleInstance = (CargoModuleInstance)this.modularEntity.getModuleInstance((Supplier<ModuleType>)TransportObjects.CARGO_TYPE);
        return cargoModuleInstance != null ? cargoModuleInstance.getBlockState() : super.func_174897_t();
    }

    protected void func_70037_a(@Nonnull CompoundNBT compound) {
        CargoModule cargoModule;
        CompoundNBT cargoNBT;
        super.func_70037_a(compound);
        this.pushX = compound.func_74769_h("pushX");
        this.pushZ = compound.func_74769_h("pushZ");
        this.originalPushX = compound.func_74769_h("originalPushX");
        this.originalPushZ = compound.func_74769_h("originalPushZ");
        this.setHullType((HullType)((IForgeRegistry)TransportAPI.HULL_TYPE.get()).getValue(new ResourceLocation(compound.func_74779_i("hull_type"))));
        if (compound.func_74764_b("modules")) {
            this.modularEntity.deserializeNBT(compound.func_74775_l("modules"));
        } else if (compound.func_74764_b("cargo") && (cargoNBT = compound.func_74775_l("cargo")).func_74764_b("name") && (cargoModule = TransportAPI.getCargo(cargoNBT.func_74779_i("name"))) != null) {
            this.modularEntity.add(cargoModule, TransportModuleSlots.CARGO.get(), false, moduleInstance -> {
                CompoundNBT compoundNBT = cargoNBT.func_74775_l("instance");
                if (compoundNBT.func_150296_c().size() > 0) {
                    moduleInstance.deserializeNBT(compoundNBT);
                }
            });
        }
    }

    protected void func_213281_b(@Nonnull CompoundNBT compound) {
        super.func_213281_b(compound);
        compound.func_218657_a("modules", (INBT)this.modularEntity.serializeNBT());
        compound.func_74780_a("pushX", this.pushX);
        compound.func_74780_a("pushZ", this.pushZ);
        compound.func_74780_a("originalPushX", this.originalPushX);
        compound.func_74780_a("originalPushZ", this.originalPushZ);
        compound.func_74778_a("hull_type", Objects.requireNonNull(this.hullType.getRegistryName()).toString());
    }

    public ItemStack getCartItem() {
        return this.modularEntity.asItemStack();
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
        LazyOptional<T> capability;
        if (cap == TransportAPI.MODULAR_ENTITY) {
            return this.modularEntityLazy.cast();
        }
        if (side == Direction.DOWN || this.func_174811_aO().func_176734_d() == side) {
            List<LazyOptional<T>> preferredCapabilities = this.modularEntity.getCapabilities(cap, side, TransportModuleSlots.BACK.get());
            for (LazyOptional<T> lazyOptional : preferredCapabilities) {
                if (!lazyOptional.isPresent()) continue;
                return lazyOptional;
            }
        }
        if ((capability = this.modularEntity.getCapability(cap, side)).isPresent()) {
            return capability;
        }
        return super.getCapability(cap, side);
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        this.modularEntity.getModuleInstances().forEach(ModuleInstance::tick);
        if (!this.field_70170_p.func_201670_d()) {
            EngineModuleInstance engineModuleInstance = (EngineModuleInstance)this.modularEntity.getModuleInstance((Supplier<ModuleType>)TransportObjects.ENGINE_TYPE);
            if (engineModuleInstance == null || engineModuleInstance.getPoweredState() != PoweredState.RUNNING || !engineModuleInstance.isRunning()) {
                if (this.pushX != 0.0 && this.pushZ != 0.0) {
                    this.originalPushX = this.pushX;
                    this.originalPushZ = this.pushZ;
                }
                this.pushX = 0.0;
                this.pushZ = 0.0;
            } else if (this.pushX == 0.0 && this.pushZ == 0.0) {
                this.pushX = this.originalPushX;
                this.pushZ = this.originalPushZ;
            }
        }
    }

    @ParametersAreNonnullByDefault
    protected void func_180460_a(BlockPos pos, BlockState state) {
        super.func_180460_a(pos, state);
        Vector3d vec3d = this.func_213322_ci();
        double d2 = CargoCarrierMinecartEntity.func_213296_b((Vector3d)vec3d);
        double d3 = this.pushX * this.pushX + this.pushZ * this.pushZ;
        if (d3 > 1.0E-4 && d2 > 0.001) {
            double d4 = MathHelper.func_76133_a((double)d2);
            double d5 = MathHelper.func_76133_a((double)d3);
            this.pushX = vec3d.field_72450_a / d4 * d5;
            this.pushZ = vec3d.field_72449_c / d4 * d5;
        }
    }

    protected void func_94101_h() {
        if (this.isPoweredCart()) {
            double d0 = this.pushX * this.pushX + this.pushZ * this.pushZ;
            if (d0 > 1.0E-7) {
                d0 = MathHelper.func_76133_a((double)d0);
                this.pushX /= d0;
                this.pushZ /= d0;
                this.func_213317_d(this.func_213322_ci().func_216372_d(0.8, 0.0, 0.8).func_72441_c(this.pushX, 0.0, this.pushZ));
            } else {
                this.func_213317_d(this.func_213322_ci().func_216372_d(0.98, 0.0, 0.98));
            }
        }
        super.func_94101_h();
    }

    public void func_94095_a(@Nonnull DamageSource source) {
        this.func_70106_y();
        if (this.field_70170_p.func_82736_K().func_223586_b(GameRules.field_223604_g)) {
            CompoundNBT tagNBT;
            ItemStack itemStack = this.modularEntity.asItemStack();
            if (this.func_145818_k_()) {
                itemStack.func_200302_a(this.func_200201_e());
            }
            if ((tagNBT = itemStack.func_77978_p()) == null) {
                tagNBT = new CompoundNBT();
            }
            tagNBT.func_74778_a("hull_type", Objects.requireNonNull(this.getHullType().getRegistryName()).toString());
            itemStack.func_77982_d(tagNBT);
            this.func_199701_a_(itemStack);
        }
    }

    public void func_96095_a(int x, int y, int z, boolean receivingPower) {
        super.func_96095_a(x, y, z, receivingPower);
        for (ModuleInstance<?> moduleInstance : this.modularEntity.getModuleInstances()) {
            moduleInstance.onActivatorPass(receivingPower);
        }
    }

    public int getComparatorLevel() {
        CargoModuleInstance cargoModuleInstance = (CargoModuleInstance)this.modularEntity.getModuleInstance((Supplier<ModuleType>)TransportObjects.CARGO_TYPE);
        return cargoModuleInstance != null ? cargoModuleInstance.getComparatorLevel() : -1;
    }

    protected double getEngineMaxSpeed() {
        return this.modularEntity.callModule((Supplier<ModuleType>)TransportObjects.ENGINE_TYPE, EngineModuleInstance::getMaximumSpeed, () -> 0.4);
    }

    protected double func_174898_m() {
        return this.getEngineMaxSpeed();
    }

    public double getMaxSpeedWithRail() {
        if (this.canUseRail()) {
            BlockPos pos = this.getCurrentRailPosition();
            BlockState state = this.getMinecart().field_70170_p.func_180495_p(pos);
            Block block = state.func_177230_c();
            if (state.func_235714_a_((ITag)BlockTags.field_203437_y) && block instanceof AbstractRailBlock) {
                float railMaxSpeed = ((AbstractRailBlock)block).getRailMaxSpeed(state, this.func_130014_f_(), pos, (AbstractMinecartEntity)this);
                double maxSpeed = Math.min((double)railMaxSpeed, this.getEngineMaxSpeed());
                return Math.min(maxSpeed, (double)this.getCurrentCartSpeedCapOnRail());
            }
        }
        return this.func_174898_m();
    }

    @Nonnull
    public Item func_199767_j() {
        return (Item)TransportEntities.CARGO_MINECART_ITEM.get();
    }

    public void writeSpawnData(PacketBuffer buffer) {
        this.modularEntity.write(buffer);
        buffer.func_192572_a(Objects.requireNonNull(this.getHullType().getRegistryName()));
    }

    public void readSpawnData(PacketBuffer additionalData) {
        this.modularEntity.read(additionalData);
        this.setHullType((HullType)((IForgeRegistry)TransportAPI.HULL_TYPE.get()).getValue(additionalData.func_192575_l()));
    }

    @Override
    public void onHeld() {
        for (ModuleInstance<?> moduleInstance : this.modularEntity.getModuleInstances()) {
            if (!(moduleInstance instanceof IHoldable)) continue;
            ((IHoldable)((Object)moduleInstance)).onHeld();
        }
    }

    @Override
    public void onRelease() {
        for (ModuleInstance<?> moduleInstance : this.modularEntity.getModuleInstances()) {
            if (!(moduleInstance instanceof IHoldable)) continue;
            ((IHoldable)((Object)moduleInstance)).onRelease();
        }
    }

    @Override
    public void push(float xPush, float zPush) {
        this.setOriginalPushes(xPush, zPush);
        for (ModuleInstance<?> moduleInstance : this.modularEntity.getModuleInstances()) {
            if (!(moduleInstance instanceof IHoldable)) continue;
            ((IHoldable)((Object)moduleInstance)).push(xPush, zPush);
        }
    }

    public void remove(boolean keepData) {
        super.remove(keepData);
        if (!keepData) {
            this.modularEntityLazy.invalidate();
            this.modularEntity.invalidateCapabilities();
        }
    }

    public void setOriginalPushes(PlayerEntity playerEntity) {
        this.setOriginalPushes(this.func_226277_ct_() - playerEntity.func_226277_ct_(), this.func_226281_cx_() - playerEntity.func_226281_cx_());
    }

    public void setOriginalPushes(double pushX, double pushZ) {
        this.originalPushX = pushX;
        this.originalPushZ = pushZ;
    }

    public IModularEntity getModularEntity() {
        return this.modularEntity;
    }

    public void setHullType(@Nullable HullType hullType) {
        this.hullType = hullType != null ? hullType : TransportHullTypes.IRON.get();
    }

    public HullType getHullType() {
        return this.hullType;
    }
}

