/*
 * Decompiled with CFR 0.152.
 */
package xyz.brassgoggledcoders.transport.container.locomotive;

import java.util.Collections;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.ContainerType;
import net.minecraft.inventory.container.IContainerListener;
import net.minecraft.inventory.container.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IWorldPosCallable;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.templates.FluidTank;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;
import xyz.brassgoggledcoders.transport.api.engine.EngineState;
import xyz.brassgoggledcoders.transport.api.entity.EntityWorldPosCallable;
import xyz.brassgoggledcoders.transport.container.slot.FuelSlot;
import xyz.brassgoggledcoders.transport.content.TransportContainers;
import xyz.brassgoggledcoders.transport.engine.SteamEngine;
import xyz.brassgoggledcoders.transport.entity.locomotive.SteamLocomotiveEntity;
import xyz.brassgoggledcoders.transport.network.property.IPropertyManaged;
import xyz.brassgoggledcoders.transport.network.property.Property;
import xyz.brassgoggledcoders.transport.network.property.PropertyManager;
import xyz.brassgoggledcoders.transport.network.property.PropertyTypes;
import xyz.brassgoggledcoders.transport.util.WorldHelper;

public class SteamLocomotiveContainer
extends Container
implements IPropertyManaged {
    private final IWorldPosCallable worldPosCallable;
    private final PropertyManager propertyManager;
    private final Property<Boolean> on;
    private final Property<Integer> burnRemaining;
    private final Property<Integer> maxBurn;
    private final Property<FluidStack> water;
    private final Property<Integer> speed;
    private final Property<Double> steam;

    public SteamLocomotiveContainer(@Nullable ContainerType<?> type, int windowId, PlayerInventory playerInventory) {
        super(type, windowId);
        this.propertyManager = new PropertyManager((short)windowId);
        this.on = this.propertyManager.addTrackedProperty(PropertyTypes.BOOLEAN.create());
        this.burnRemaining = this.propertyManager.addTrackedProperty(PropertyTypes.INTEGER.create());
        this.maxBurn = this.propertyManager.addTrackedProperty(PropertyTypes.INTEGER.create());
        this.water = this.propertyManager.addTrackedProperty(PropertyTypes.FLUID_STACK.create());
        this.speed = this.propertyManager.addTrackedProperty(PropertyTypes.INTEGER.create());
        this.steam = this.propertyManager.addTrackedProperty(PropertyTypes.DOUBLE.create());
        this.worldPosCallable = IWorldPosCallable.field_221489_a;
        this.addSlots((IItemHandler)new ItemStackHandler(1), playerInventory);
    }

    public SteamLocomotiveContainer(int windowId, PlayerInventory playerInventory, SteamLocomotiveEntity locomotiveEntity) {
        super((ContainerType)TransportContainers.STEAM_LOCOMOTIVE.get(), windowId);
        this.propertyManager = new PropertyManager((short)windowId);
        this.on = this.propertyManager.addTrackedProperty(PropertyTypes.BOOLEAN.create(locomotiveEntity::isOn, locomotiveEntity::setOn));
        this.burnRemaining = this.propertyManager.addTrackedProperty(PropertyTypes.INTEGER.create(((SteamEngine)locomotiveEntity.getEngine())::getBurnRemaining));
        this.maxBurn = this.propertyManager.addTrackedProperty(PropertyTypes.INTEGER.create(((SteamEngine)locomotiveEntity.getEngine())::getMaxBurn));
        this.water = this.propertyManager.addTrackedProperty(PropertyTypes.FLUID_STACK.create(() -> ((FluidTank)((SteamEngine)locomotiveEntity.getEngine()).getWaterTank()).getFluid()));
        this.speed = this.propertyManager.addTrackedProperty(PropertyTypes.INTEGER.create(() -> locomotiveEntity.getEngineState().ordinal(), id -> locomotiveEntity.alterEngineState(EngineState.byId(id))));
        this.steam = this.propertyManager.addTrackedProperty(PropertyTypes.DOUBLE.create(((SteamEngine)locomotiveEntity.getEngine())::getSteam));
        this.worldPosCallable = new EntityWorldPosCallable((Entity)locomotiveEntity);
        this.addSlots(((SteamEngine)locomotiveEntity.getEngine()).getFuelHandler(), playerInventory);
    }

    public void addSlots(IItemHandler handler, PlayerInventory playerInventory) {
        this.func_75146_a((Slot)new FuelSlot(handler, 0, 11, 53));
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < 9; ++j) {
                this.func_75146_a(new Slot((IInventory)playerInventory, j + i * 9 + 9, 8 + j * 18, 85 + i * 18));
            }
        }
        for (int k = 0; k < 9; ++k) {
            this.func_75146_a(new Slot((IInventory)playerInventory, k, 8 + k * 18, 143));
        }
    }

    public boolean func_75145_c(@Nonnull PlayerEntity player) {
        return (Boolean)this.worldPosCallable.func_221485_a(WorldHelper.isPlayerNear(player)::test, (Object)true);
    }

    public void func_75142_b() {
        super.func_75142_b();
        this.propertyManager.sendChanges(this.field_75149_d, false);
    }

    public void func_75132_a(@Nonnull IContainerListener listener) {
        super.func_75132_a(listener);
        this.propertyManager.sendChanges(Collections.singletonList(listener), true);
    }

    public boolean isLocomotiveOn() {
        return this.on.get() == Boolean.TRUE;
    }

    public int getFuelBurnedScaled() {
        Integer maxBurnValue = this.maxBurn.get();
        Integer burnRemainingValue = this.burnRemaining.get();
        if (maxBurnValue != null && burnRemainingValue != null && maxBurnValue > 0) {
            int burned = maxBurnValue - burnRemainingValue;
            float percentBurned = (float)burned / (float)maxBurnValue.intValue();
            return (int)Math.ceil(percentBurned * 10.0f);
        }
        return 10;
    }

    public int getSteam() {
        Double steamAmount = this.steam.get();
        if (steamAmount != null) {
            return (int)Math.floor(steamAmount);
        }
        return 0;
    }

    @Nonnull
    public FluidStack getWater() {
        return this.water.getOrElse(FluidStack.EMPTY);
    }

    @Override
    public PropertyManager getPropertyManager() {
        return this.propertyManager;
    }

    @Nonnull
    public ItemStack func_82846_b(@Nonnull PlayerEntity player, int index) {
        ItemStack itemstack = ItemStack.field_190927_a;
        Slot slot = (Slot)this.field_75151_b.get(index);
        if (slot != null && slot.func_75216_d()) {
            ItemStack slotItemStack = slot.func_75211_c();
            itemstack = slotItemStack.func_77946_l();
            int containerSlots = this.field_75151_b.size() - player.field_71071_by.field_70462_a.size();
            if (index < containerSlots ? !this.func_75135_a(slotItemStack, containerSlots, this.field_75151_b.size(), true) : !this.func_75135_a(slotItemStack, 0, containerSlots, false)) {
                return ItemStack.field_190927_a;
            }
            if (slotItemStack.func_190916_E() == 0) {
                slot.func_75215_d(ItemStack.field_190927_a);
            } else {
                slot.func_75218_e();
            }
            if (slotItemStack.func_190916_E() == itemstack.func_190916_E()) {
                return ItemStack.field_190927_a;
            }
            slot.func_190901_a(player, slotItemStack);
        }
        return itemstack;
    }

    public Property<Boolean> getOn() {
        return this.on;
    }

    public Property<Integer> getSpeed() {
        return this.speed;
    }
}

