/*
 * Decompiled with CFR 0.152.
 */
package xyz.brassgoggledcoders.transport.container.loader;

import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.ContainerType;
import net.minecraft.util.IWorldPosCallable;
import net.minecraftforge.fluids.FluidStack;
import xyz.brassgoggledcoders.transport.api.helper.ContainerHelper;
import xyz.brassgoggledcoders.transport.container.BasicContainer;
import xyz.brassgoggledcoders.transport.network.property.Property;
import xyz.brassgoggledcoders.transport.network.property.PropertyTypes;

public class FluidLoaderContainer
extends BasicContainer {
    private final Property<FluidStack> fluidStack;
    private final Property<Integer> tankSize;

    public FluidLoaderContainer(@Nullable ContainerType<?> type, int id, PlayerInventory playerInventory, IWorldPosCallable worldPosCallable, Supplier<FluidStack> fluidStackSupplier, int tankSize) {
        super(type, id, worldPosCallable);
        this.fluidStack = this.getPropertyManager().addTrackedProperty(PropertyTypes.FLUID_STACK.create(fluidStackSupplier));
        this.tankSize = this.getPropertyManager().addTrackedProperty(PropertyTypes.INTEGER.create(() -> tankSize));
        ContainerHelper.addPlayerSlots(playerInventory, arg_0 -> ((FluidLoaderContainer)this).func_75146_a(arg_0));
    }

    public FluidLoaderContainer(@Nullable ContainerType<?> type, int id, PlayerInventory playerInventory) {
        super(type, id, IWorldPosCallable.field_221489_a);
        this.fluidStack = this.getPropertyManager().addTrackedProperty(PropertyTypes.FLUID_STACK.create());
        this.tankSize = this.getPropertyManager().addTrackedProperty(PropertyTypes.INTEGER.create());
        ContainerHelper.addPlayerSlots(playerInventory, arg_0 -> ((FluidLoaderContainer)this).func_75146_a(arg_0));
    }

    @Nonnull
    public FluidStack getFluidStack() {
        return this.fluidStack.getOrElse(FluidStack.EMPTY);
    }

    public int getTankSize() {
        return this.tankSize.getOrElse(1000);
    }
}

