/*
 * Decompiled with CFR 0.152.
 */
package xyz.brassgoggledcoders.transport.container.loader;

import java.util.function.IntSupplier;
import javax.annotation.Nullable;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.ContainerType;
import net.minecraft.util.IWorldPosCallable;
import xyz.brassgoggledcoders.transport.api.helper.ContainerHelper;
import xyz.brassgoggledcoders.transport.container.BasicContainer;
import xyz.brassgoggledcoders.transport.network.property.Property;
import xyz.brassgoggledcoders.transport.network.property.PropertyTypes;

public class EnergyLoaderContainer
extends BasicContainer {
    private final Property<Integer> energy;
    private final Property<Integer> tankSize;

    public EnergyLoaderContainer(@Nullable ContainerType<?> type, int id, PlayerInventory playerInventory, IWorldPosCallable worldPosCallable, IntSupplier energySupplier, int maxEnergy) {
        super(type, id, worldPosCallable);
        this.energy = this.getPropertyManager().addTrackedProperty(PropertyTypes.INTEGER.create(energySupplier::getAsInt));
        this.tankSize = this.getPropertyManager().addTrackedProperty(PropertyTypes.INTEGER.create(() -> maxEnergy));
        ContainerHelper.addPlayerSlots(playerInventory, arg_0 -> ((EnergyLoaderContainer)this).func_75146_a(arg_0));
    }

    public EnergyLoaderContainer(@Nullable ContainerType<?> type, int id, PlayerInventory playerInventory) {
        super(type, id, IWorldPosCallable.field_221489_a);
        this.energy = this.getPropertyManager().addTrackedProperty(PropertyTypes.INTEGER.create());
        this.tankSize = this.getPropertyManager().addTrackedProperty(PropertyTypes.INTEGER.create());
        ContainerHelper.addPlayerSlots(playerInventory, arg_0 -> ((EnergyLoaderContainer)this).func_75146_a(arg_0));
    }

    public int getEnergy() {
        return this.energy.getOrElse(0);
    }

    public int getMaxEnergy() {
        return this.tankSize.getOrElse(1000);
    }
}

