/*
 * Decompiled with CFR 0.152.
 */
package xyz.brassgoggledcoders.transport.compat.vanilla.module.cargo;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.WeightedSpawnerEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.spawner.AbstractSpawner;
import xyz.brassgoggledcoders.transport.api.cargo.CargoModule;
import xyz.brassgoggledcoders.transport.api.cargo.CargoModuleInstance;
import xyz.brassgoggledcoders.transport.api.entity.IModularEntity;
import xyz.brassgoggledcoders.transport.api.module.ModuleInstance;

public class SpawnerCargoModuleInstance
extends CargoModuleInstance {
    private final AbstractSpawner spawner;

    public SpawnerCargoModuleInstance(CargoModule cargoModule, IModularEntity modularEntity) {
        super(cargoModule, modularEntity);
        this.spawner = new CargoSpawner(modularEntity, this);
    }

    @Override
    public void tick() {
        super.tick();
        this.spawner.func_98278_g();
    }

    @Override
    public void write(PacketBuffer packetBuffer) {
        super.write(packetBuffer);
        CompoundNBT compoundNBT = this.spawner.func_189530_b(new CompoundNBT());
        compoundNBT.func_82580_o("SpawnPotentials");
        packetBuffer.func_150786_a(compoundNBT);
    }

    @Override
    public void read(PacketBuffer packetBuffer) {
        super.read(packetBuffer);
        CompoundNBT compoundNBT = packetBuffer.func_150793_b();
        if (compoundNBT != null) {
            this.spawner.func_98270_a(compoundNBT);
        }
    }

    @Override
    public void receiveClientUpdate(int type, @Nullable CompoundNBT compoundNBT) {
        super.receiveClientUpdate(type, compoundNBT);
        if (compoundNBT != null) {
            this.spawner.func_98270_a(compoundNBT);
        } else {
            this.spawner.func_98268_b(type);
        }
    }

    @Override
    public CompoundNBT serializeNBT() {
        CompoundNBT compoundNBT = super.serializeNBT();
        this.spawner.func_189530_b(compoundNBT);
        return compoundNBT;
    }

    @Override
    public void deserializeNBT(CompoundNBT nbt) {
        super.deserializeNBT(nbt);
        this.spawner.func_98270_a(nbt);
    }

    @Override
    public void readFromItemStack(ItemStack itemStack) {
        super.readFromItemStack(itemStack);
        CompoundNBT blockEntityTag = itemStack.func_179543_a("BlockEntityTag");
        if (blockEntityTag != null) {
            this.spawner.func_98270_a(blockEntityTag);
        }
    }

    @Override
    @Nonnull
    public ItemStack asItemStack() {
        ItemStack itemStack = super.asItemStack();
        this.spawner.func_189530_b(itemStack.func_190925_c("BlockEntityTag"));
        return itemStack;
    }

    public AbstractSpawner getSpawner() {
        return this.spawner;
    }

    private static final class CargoSpawner
    extends AbstractSpawner {
        private final IModularEntity entity;
        private final ModuleInstance<?> moduleInstance;

        private CargoSpawner(IModularEntity entity, ModuleInstance<?> moduleInstance) {
            this.entity = entity;
            this.moduleInstance = moduleInstance;
        }

        public void func_98267_a(int id) {
            this.entity.sendClientUpdate(this.moduleInstance, id, null);
        }

        @Nonnull
        public World func_98271_a() {
            return this.entity.getTheWorld();
        }

        @Nonnull
        public BlockPos func_177221_b() {
            return this.entity.getSelf().func_233580_cy_();
        }

        public Entity getSpawnerEntity() {
            return this.entity.getSelf();
        }

        public void func_184993_a(@Nonnull WeightedSpawnerEntity nextSpawnData) {
            super.func_184993_a(nextSpawnData);
            CompoundNBT compoundNBT = this.func_189530_b(new CompoundNBT());
            compoundNBT.func_82580_o("SpawnPotentials");
            this.entity.sendClientUpdate(this.moduleInstance, -1, compoundNBT);
        }
    }
}

