/*
 * Decompiled with CFR 0.152.
 */
package xyz.brassgoggledcoders.transport.compat.jei.module;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IGuiItemStackGroup;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import org.apache.commons.lang3.tuple.Pair;
import xyz.brassgoggledcoders.transport.Transport;
import xyz.brassgoggledcoders.transport.api.TransportAPI;
import xyz.brassgoggledcoders.transport.api.entity.IModularEntity;
import xyz.brassgoggledcoders.transport.api.item.IModularItem;
import xyz.brassgoggledcoders.transport.api.module.Module;
import xyz.brassgoggledcoders.transport.api.module.ModuleSlot;
import xyz.brassgoggledcoders.transport.api.module.ModuleType;
import xyz.brassgoggledcoders.transport.compat.jei.module.ModuleRecipe;
import xyz.brassgoggledcoders.transport.content.TransportBlocks;

public class ModuleCategory
implements IRecipeCategory<ModuleRecipe> {
    public static final ResourceLocation UID = Transport.rl("module_configurator");
    private final IDrawable background;
    private final IDrawable icon;
    private final String localizedName;

    public ModuleCategory(IGuiHelper guiHelper) {
        ResourceLocation location = new ResourceLocation("jei", "textures/gui/gui_vanilla.png");
        this.background = guiHelper.drawableBuilder(location, 0, 168, 125, 18).addPadding(0, 20, 0, 0).build();
        this.icon = guiHelper.createDrawableIngredient((Object)new ItemStack((IItemProvider)TransportBlocks.MODULE_CONFIGURATOR.get()));
        this.localizedName = I18n.func_135052_a((String)"screen.transport.jei.category.module_configurator", (Object[])new Object[0]);
    }

    @Nonnull
    public ResourceLocation getUid() {
        return UID;
    }

    @Nonnull
    public Class<? extends ModuleRecipe> getRecipeClass() {
        return ModuleRecipe.class;
    }

    @Nonnull
    public String getTitle() {
        return this.localizedName;
    }

    @Nonnull
    public IDrawable getBackground() {
        return this.background;
    }

    @Nonnull
    public IDrawable getIcon() {
        return this.icon;
    }

    @ParametersAreNonnullByDefault
    public void setIngredients(ModuleRecipe moduleRecipe, IIngredients ingredients) {
        ingredients.setInputs(VanillaTypes.ITEM, (List)Lists.newArrayList((Object[])new ItemStack[]{moduleRecipe.getModuleItem(), moduleRecipe.getModularInput()}));
        ingredients.setOutput(VanillaTypes.ITEM, (Object)moduleRecipe.getModularOutput());
    }

    @ParametersAreNonnullByDefault
    public void setRecipe(IRecipeLayout recipeLayout, ModuleRecipe moduleRecipe, IIngredients ingredients) {
        IGuiItemStackGroup guiItemStacks = recipeLayout.getItemStacks();
        guiItemStacks.init(0, true, 0, 0);
        guiItemStacks.init(1, true, 49, 0);
        guiItemStacks.init(2, false, 107, 0);
        guiItemStacks.set(ingredients);
    }

    @ParametersAreNonnullByDefault
    public void draw(ModuleRecipe recipe, MatrixStack matrixStack, double mouseX, double mouseY) {
        Minecraft.func_71410_x().field_71466_p.func_243248_b(matrixStack, (ITextComponent)new TranslationTextComponent("text.transport.module_slot", new Object[]{recipe.getModuleSlot().getDisplayName()}), 0.0f, 27.0f, 0x404040);
    }

    public static Collection<ModuleRecipe> createRecipes() {
        ArrayList moduleRecipes = Lists.newArrayList();
        List modularEntities = ForgeRegistries.ITEMS.getValues().parallelStream().filter(item -> item instanceof IModularItem).map(item -> {
            Optional optional;
            IModularItem modularItem = (IModularItem)item;
            EntityType entityType = modularItem.getEntityType();
            Entity entity = entityType.func_200721_a((World)Objects.requireNonNull(Minecraft.func_71410_x().field_71441_e));
            if (entity != null && (optional = entity.getCapability(TransportAPI.MODULAR_ENTITY).resolve()).isPresent()) {
                return Pair.of((Object)new ItemStack((IItemProvider)item), (Object)((IModularEntity)optional.get()));
            }
            return null;
        }).filter(Objects::nonNull).collect(Collectors.toList());
        for (ModuleType moduleType : (IForgeRegistry)TransportAPI.MODULE_TYPE.get()) {
            for (Module<?> module : moduleType.getValues()) {
                ItemStack itemStack = new ItemStack((IItemProvider)module.func_199767_j());
                if (itemStack.func_190926_b()) continue;
                for (Pair modularPair : modularEntities) {
                    IModularEntity modularEntity = (IModularEntity)modularPair.getRight();
                    if (!modularEntity.canEquip(module) || !module.isValidFor(modularEntity)) continue;
                    for (ModuleSlot moduleSlot : modularEntity.getModuleSlots()) {
                        if (!moduleSlot.isModuleValid(modularEntity, module)) continue;
                        modularEntity.add(module, moduleSlot, false);
                        moduleRecipes.add(new ModuleRecipe(new ItemStack((IItemProvider)module.func_199767_j()), (ItemStack)modularPair.getLeft(), modularEntity.asItemStack(), moduleSlot));
                        modularEntity.remove(moduleSlot, false);
                    }
                }
            }
        }
        return moduleRecipes;
    }
}

