/*
 * Decompiled with CFR 0.152.
 */
package xyz.brassgoggledcoders.transport.cargoinstance.capability;

import com.mojang.datafixers.util.Function3;
import javax.annotation.Nullable;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.ContainerType;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import xyz.brassgoggledcoders.transport.api.cargo.CargoModule;
import xyz.brassgoggledcoders.transport.api.entity.EntityWorldPosCallable;
import xyz.brassgoggledcoders.transport.api.entity.IModularEntity;
import xyz.brassgoggledcoders.transport.capability.fluid.BasicFluidTank;
import xyz.brassgoggledcoders.transport.cargoinstance.capability.CapabilityCargoModuleInstance;
import xyz.brassgoggledcoders.transport.container.loader.FluidLoaderContainer;
import xyz.brassgoggledcoders.transport.content.TransportContainers;

public class FluidCargoModuleInstance
extends CapabilityCargoModuleInstance<IFluidHandler> {
    private final BasicFluidTank fluidTank;
    private final LazyOptional<IFluidHandler> lazyFluidTank;

    public FluidCargoModuleInstance(CargoModule cargoModule, IModularEntity modularEntity) {
        this(cargoModule, modularEntity, 10);
    }

    public FluidCargoModuleInstance(CargoModule cargoModule, IModularEntity modularEntity, int buckets) {
        super(cargoModule, modularEntity, CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY);
        this.fluidTank = new BasicFluidTank(buckets * 1000);
        this.lazyFluidTank = LazyOptional.of(() -> this.fluidTank);
    }

    @Override
    public ActionResultType applyInteraction(PlayerEntity player, Vector3d vec, Hand hand) {
        if (FluidUtil.interactWithFluidHandler((PlayerEntity)player, (Hand)hand, (IFluidHandler)this.fluidTank)) {
            return ActionResultType.SUCCESS;
        }
        return super.applyInteraction(player, vec, hand);
    }

    @Override
    public int getComparatorLevel() {
        return this.fluidTank.getComparatorLevel();
    }

    @Override
    protected LazyOptional<IFluidHandler> getLazyOptional() {
        return this.lazyFluidTank;
    }

    @Override
    protected CompoundNBT serializeCapability() {
        return this.fluidTank.writeToNBT(new CompoundNBT());
    }

    @Override
    protected void deserializeCapability(CompoundNBT nbt) {
        this.fluidTank.readFromNBT(nbt);
    }

    @Override
    @Nullable
    public Function3<Integer, PlayerInventory, PlayerEntity, ? extends Container> getContainerCreator() {
        return (id, playerInventory, playerEntity) -> new FluidLoaderContainer((ContainerType<?>)((ContainerType)TransportContainers.FLUID_LOADER.get()), (int)id, (PlayerInventory)playerInventory, new EntityWorldPosCallable(this.getModularEntity()), () -> ((BasicFluidTank)this.fluidTank).getFluid(), this.fluidTank.getTankCapacity(0));
    }
}

