/*
 * Decompiled with CFR 0.152.
 */
package xyz.brassgoggledcoders.transport.api.predicate;

import com.mojang.datafixers.util.Either;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import net.minecraft.entity.Entity;
import net.minecraft.item.ItemStack;
import net.minecraft.item.WritableBookItem;
import net.minecraft.item.WrittenBookItem;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.tileentity.LecternTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import xyz.brassgoggledcoders.transport.api.predicate.PredicateParser;
import xyz.brassgoggledcoders.transport.api.predicate.PredicateParserException;

public class PredicateStorage {
    private Either<String, Predicate<Entity>> predicate = null;

    @Nonnull
    public Either<String, Predicate<Entity>> getPredicate(TileEntity tileEntity) {
        if (this.predicate == null) {
            if (tileEntity instanceof LecternTileEntity) {
                LecternTileEntity lecternTileEntity = (LecternTileEntity)tileEntity;
                if (lecternTileEntity.func_214046_f()) {
                    CompoundNBT bookNBT;
                    ItemStack book = lecternTileEntity.func_214033_c();
                    String routingString = null;
                    if (WrittenBookItem.func_77828_a((CompoundNBT)book.func_77978_p())) {
                        bookNBT = book.func_77978_p();
                        ListNBT pagesNBT = bookNBT.func_150295_c("pages", 8);
                        String currentPage = pagesNBT.func_150307_f(lecternTileEntity.func_214041_g());
                        IFormattableTextComponent textComponent = ITextComponent.Serializer.func_240643_a_((String)currentPage);
                        if (textComponent != null) {
                            routingString = textComponent.getString();
                        }
                    } else if (WritableBookItem.func_150930_a((CompoundNBT)book.func_77978_p())) {
                        bookNBT = book.func_77978_p();
                        ListNBT pagesNBT = bookNBT.func_150295_c("pages", 8);
                        routingString = pagesNBT.func_150307_f(lecternTileEntity.func_214041_g());
                    }
                    if (routingString != null) {
                        try {
                            this.predicate = Either.right(PredicateParser.fromString(routingString).getNextEntityPredicate());
                        }
                        catch (PredicateParserException exception) {
                            this.predicate = Either.left((Object)exception.getMessage());
                        }
                    } else {
                        this.predicate = Either.left((Object)"Found Invalid Book");
                    }
                } else {
                    this.predicate = Either.left((Object)"No Book found");
                }
            } else {
                this.predicate = Either.left((Object)"Didn't find Lectern");
            }
        }
        return this.predicate;
    }

    public void invalidate() {
        this.predicate = null;
    }
}

