/*
 * Decompiled with CFR 0.152.
 */
package xyz.brassgoggledcoders.transport.api.navigation;

import java.util.Objects;
import java.util.function.BiFunction;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Util;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.registries.ForgeRegistryEntry;
import xyz.brassgoggledcoders.transport.api.TransportRegistries;
import xyz.brassgoggledcoders.transport.api.navigation.INavigationNetwork;
import xyz.brassgoggledcoders.transport.api.navigation.INavigationPoint;
import xyz.brassgoggledcoders.transport.api.navigation.NavigationPoint;

public class NavigationPointType
extends ForgeRegistryEntry<NavigationPointType> {
    private ITextComponent displayName;
    private String translationKey;
    private final BiFunction<INavigationNetwork, NavigationPointType, NavigationPoint> instanceSupplier;

    public NavigationPointType(BiFunction<INavigationNetwork, NavigationPointType, NavigationPoint> instanceSupplier) {
        this.instanceSupplier = instanceSupplier;
    }

    public String getTranslationKey() {
        if (this.translationKey == null) {
            this.translationKey = Util.func_200697_a((String)"navigation_point", (ResourceLocation)this.getRegistryName());
        }
        return this.translationKey;
    }

    public ITextComponent getDisplayName() {
        if (this.displayName == null) {
            this.displayName = new TranslationTextComponent(this.getTranslationKey());
        }
        return this.displayName;
    }

    public NavigationPoint create(INavigationNetwork navigationNetwork) {
        return this.instanceSupplier.apply(navigationNetwork, this);
    }

    public static NavigationPointType of(BiFunction<INavigationNetwork, NavigationPointType, NavigationPoint> instanceSupplier) {
        return new NavigationPointType(instanceSupplier);
    }

    @Nullable
    public static INavigationPoint deserialize(INavigationNetwork navigationNetwork, CompoundNBT nbt) {
        NavigationPointType pointType = (NavigationPointType)TransportRegistries.NAVIGATION_POINT_TYPES.getValue(new ResourceLocation(nbt.func_74779_i("type")));
        if (pointType != null) {
            NavigationPoint navigationPoint = pointType.create(navigationNetwork);
            navigationPoint.deserializeNBT(nbt);
            return navigationPoint;
        }
        return null;
    }

    @Nonnull
    public static CompoundNBT serialize(@Nonnull INavigationPoint navigationPoint) {
        CompoundNBT nbt = (CompoundNBT)navigationPoint.serializeNBT();
        nbt.func_74778_a("type", Objects.requireNonNull(navigationPoint.getType().getRegistryName()).toString());
        nbt.func_186854_a("uniqueId", navigationPoint.getUniqueId());
        nbt.func_218657_a("blockPos", (INBT)NBTUtil.func_186859_a((BlockPos)navigationPoint.getPosition()));
        return nbt;
    }
}

