/*
 * Decompiled with CFR 0.152.
 */
package xyz.brassgoggledcoders.transport.api.navigation;

import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import xyz.brassgoggledcoders.transport.api.navigation.INavigationNetwork;
import xyz.brassgoggledcoders.transport.api.navigation.INavigationPoint;

public interface INavigator {
    @Nonnull
    default public Optional<INavigationPoint> getCurrentPoint(INavigationNetwork network) {
        UUID currentPointId = this.getCurrentPointId();
        if (currentPointId != null) {
            return Optional.ofNullable(network.getNavigationPoint(currentPointId));
        }
        return Optional.empty();
    }

    @Nullable
    public UUID getCurrentPointId();

    @Nullable
    default public INavigationPoint getLastPoint(INavigationNetwork network) {
        UUID lastPointId = this.getLastPointId();
        if (lastPointId != null) {
            return network.getNavigationPoint(lastPointId);
        }
        return null;
    }

    @Nullable
    public UUID getLastPointId();

    public void setCurrentPoint(@Nullable INavigationPoint var1);
}

