/*
 * Decompiled with CFR 0.152.
 */
package xyz.brassgoggledcoders.transport.api.module;

import java.util.Collection;
import java.util.Optional;
import java.util.function.Function;
import javax.annotation.Nonnull;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Util;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.common.util.NonNullLazy;
import net.minecraftforge.common.util.NonNullSupplier;
import net.minecraftforge.registries.ForgeRegistryEntry;
import xyz.brassgoggledcoders.transport.api.module.Module;

public class ModuleType
extends ForgeRegistryEntry<ModuleType> {
    private final Function<ResourceLocation, Module<?>> loadValue;
    private final NonNullLazy<Collection<Module<?>>> getValues;
    private String translationKey;
    private ITextComponent name;

    public ModuleType(Function<ResourceLocation, Module<?>> loadValue, NonNullSupplier<Collection<Module<?>>> getValues) {
        this.loadValue = loadValue;
        this.getValues = NonNullLazy.of(() -> getValues.get());
    }

    @Nonnull
    public String getTranslationKey() {
        if (this.translationKey == null) {
            this.translationKey = Util.func_200697_a((String)"module_type", (ResourceLocation)this.getRegistryName());
        }
        return this.translationKey;
    }

    @Nonnull
    public ITextComponent getDisplayName() {
        if (this.name == null) {
            this.name = new TranslationTextComponent(this.getTranslationKey());
        }
        return this.name;
    }

    public String getName() {
        return Optional.ofNullable(this.getRegistryName()).map(ResourceLocation::func_110623_a).orElseThrow(() -> new IllegalStateException("No Registry Name Found"));
    }

    public Module<?> load(String registryName) {
        return this.load(new ResourceLocation(registryName));
    }

    public Module<?> load(ResourceLocation registryName) {
        return this.loadValue.apply(registryName);
    }

    public Collection<Module<?>> getValues() {
        return (Collection)this.getValues.get();
    }
}

