/*
 * Decompiled with CFR 0.152.
 */
package xyz.brassgoggledcoders.transport.api.engine;

import java.util.Locale;
import javax.annotation.Nullable;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.common.util.NonNullLazy;
import xyz.brassgoggledcoders.transport.api.engine.EngineDirection;

public enum EngineState {
    FORWARD_3(1.2f, 1.0f, EngineDirection.FORWARD),
    FORWARD_2(0.6f, 0.5f, EngineDirection.FORWARD),
    FORWARD_1(0.3f, 0.25f, EngineDirection.FORWARD),
    NEUTRAL_0(0.1f, 0.0f, EngineDirection.NEUTRAL),
    REVERSE_1(0.3f, 0.25f, EngineDirection.REVERSE),
    REVERSE_2(0.6f, 0.5f, EngineDirection.REVERSE),
    REVERSE_3(1.2f, 1.0f, EngineDirection.REVERSE);

    private final float fuelUseModifier;
    private final float maxSpeedModifier;
    private final EngineDirection direction;
    private final NonNullLazy<String> getTranslationKey;
    private final NonNullLazy<ITextComponent> getDisplayName;

    private EngineState(float fuelUseModifier, float maxSpeedModifier, EngineDirection direction) {
        this.fuelUseModifier = fuelUseModifier;
        this.maxSpeedModifier = maxSpeedModifier;
        this.direction = direction;
        this.getTranslationKey = NonNullLazy.of(() -> "enginestate.transport." + this.name().toLowerCase(Locale.ROOT));
        this.getDisplayName = NonNullLazy.of(() -> new TranslationTextComponent(this.getTranslationKey()));
    }

    public float getFuelUseModifier() {
        return this.fuelUseModifier;
    }

    public float getMaxSpeedModifier() {
        return this.maxSpeedModifier;
    }

    public EngineDirection getDirection() {
        return this.direction;
    }

    @Nullable
    public static EngineState forward(EngineState prior) {
        switch (prior) {
            case FORWARD_3: {
                return null;
            }
            case FORWARD_2: {
                return FORWARD_3;
            }
            case FORWARD_1: {
                return FORWARD_2;
            }
            case NEUTRAL_0: {
                return FORWARD_1;
            }
            case REVERSE_1: {
                return NEUTRAL_0;
            }
            case REVERSE_2: {
                return REVERSE_1;
            }
            case REVERSE_3: {
                return REVERSE_2;
            }
        }
        return null;
    }

    @Nullable
    public static EngineState reverse(EngineState prior) {
        switch (prior) {
            case FORWARD_3: {
                return FORWARD_2;
            }
            case FORWARD_2: {
                return FORWARD_1;
            }
            case FORWARD_1: {
                return NEUTRAL_0;
            }
            case NEUTRAL_0: {
                return REVERSE_1;
            }
            case REVERSE_1: {
                return REVERSE_2;
            }
            case REVERSE_2: {
                return REVERSE_3;
            }
            case REVERSE_3: {
                return null;
            }
        }
        return null;
    }

    public String getTranslationKey() {
        return (String)this.getTranslationKey.get();
    }

    public ITextComponent getDisplayName() {
        return (ITextComponent)this.getDisplayName.get();
    }

    public static EngineState byName(String name) {
        for (EngineState state : EngineState.values()) {
            if (!state.name().equals(name)) continue;
            return state;
        }
        return NEUTRAL_0;
    }

    public static EngineState byId(Integer id) {
        if (id != null && id >= 0 && id < EngineState.values().length) {
            return EngineState.values()[id];
        }
        return NEUTRAL_0;
    }
}

