/*
 * Decompiled with CFR 0.152.
 */
package xyz.brassgoggledcoders.transport.api.connection;

import com.google.common.collect.Lists;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import xyz.brassgoggledcoders.transport.api.connection.IConnectionChecker;

public class ListConnectionChecker
implements IConnectionChecker {
    private final List<IConnectionChecker> connectionCheckerList = Lists.newArrayList();

    @Override
    public boolean areConnected(@Nonnull Entity one, @Nonnull Entity two) {
        for (IConnectionChecker connectionChecker : this.connectionCheckerList) {
            if (!connectionChecker.areConnected(one, two)) continue;
            return true;
        }
        return false;
    }

    @Override
    @Nullable
    public Entity getLeader(@Nullable Entity entity) {
        for (IConnectionChecker connectionChecker : this.connectionCheckerList) {
            Entity leader = connectionChecker.getLeader(entity);
            if (leader == null) continue;
            return leader;
        }
        return null;
    }

    public List<IConnectionChecker> getConnectionCheckers() {
        return this.connectionCheckerList;
    }
}

