/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.kleeslabs.network;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.Supplier;
import net.blay09.mods.kleeslabs.network.NetworkHandler;
import net.blay09.mods.kleeslabs.registry.SlabRegistry;
import net.blay09.mods.kleeslabs.registry.SlabRegistryData;
import net.minecraft.block.Block;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.network.NetworkEvent;
import net.minecraftforge.registries.ForgeRegistries;

public class MessageKleeSlabsRegistry {
    private final boolean isFirst;
    private final List<SlabRegistryData> data;

    public MessageKleeSlabsRegistry(boolean isFirst, List<SlabRegistryData> data) {
        this.isFirst = isFirst;
        this.data = data;
    }

    public static void encode(MessageKleeSlabsRegistry message, PacketBuffer buf) {
        buf.writeBoolean(message.isFirst);
        buf.writeShort(message.data.size());
        for (SlabRegistryData data : message.data) {
            buf.func_180714_a(data.getConverterClass().getName());
            buf.func_192572_a(Objects.requireNonNull(data.getSingleSlab().getRegistryName()));
            buf.func_192572_a(Objects.requireNonNull(data.getDoubleSlab().getRegistryName()));
        }
    }

    public static MessageKleeSlabsRegistry decode(PacketBuffer buf) {
        boolean isFirst = buf.readBoolean();
        int size = buf.readShort();
        ArrayList<SlabRegistryData> data = new ArrayList<SlabRegistryData>();
        for (int i = 0; i < size; ++i) {
            try {
                String converterClassName = buf.func_150789_c(Short.MAX_VALUE);
                ResourceLocation singleBlockId = buf.func_192575_l();
                ResourceLocation doubleBlockId = buf.func_192575_l();
                Class<?> converterClass = Class.forName(converterClassName);
                Block singleSlab = (Block)ForgeRegistries.BLOCKS.getValue(singleBlockId);
                Block doubleSlab = (Block)ForgeRegistries.BLOCKS.getValue(doubleBlockId);
                if (singleSlab == null || doubleSlab == null) continue;
                data.add(new SlabRegistryData(converterClass, singleSlab, doubleSlab));
                continue;
            }
            catch (ClassNotFoundException e) {
                e.printStackTrace();
            }
        }
        return new MessageKleeSlabsRegistry(isFirst, data);
    }

    public static void handle(MessageKleeSlabsRegistry message, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        NetworkHandler.ensureClientSide(context);
        context.enqueueWork(() -> {
            if (message.isFirst) {
                SlabRegistry.clearRegistry();
            }
            for (SlabRegistryData data : message.data) {
                SlabRegistry.registerSlab(data);
            }
        });
    }
}

