/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolspower.modules.powercell.blocks;

import java.util.Collection;
import java.util.Collections;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mcjty.lib.blocks.BaseBlock;
import mcjty.lib.blocks.RotationType;
import mcjty.lib.builder.BlockBuilder;
import mcjty.lib.builder.InfoLine;
import mcjty.lib.builder.TooltipBuilder;
import mcjty.lib.compat.theoneprobe.TOPDriver;
import mcjty.lib.crafting.INBTPreservingIngredient;
import mcjty.rftoolspower.compat.RFToolsPowerTOPDriver;
import mcjty.rftoolspower.modules.powercell.PowerCellConfig;
import mcjty.rftoolspower.modules.powercell.PowerCellModule;
import mcjty.rftoolspower.modules.powercell.blocks.PowerCellTileEntity;
import mcjty.rftoolspower.modules.powercell.data.Tier;
import net.minecraft.block.Block;
import net.minecraft.block.BlockRenderType;
import net.minecraft.block.BlockState;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;

public class PowerCellBlock
extends BaseBlock
implements INBTPreservingIngredient {
    public static BooleanProperty UPPER = BooleanProperty.func_177716_a((String)"upper");
    public static BooleanProperty LOWER = BooleanProperty.func_177716_a((String)"lower");

    public RotationType getRotationType() {
        return RotationType.NONE;
    }

    public PowerCellBlock(Tier tier) {
        super(new BlockBuilder().topDriver((TOPDriver)RFToolsPowerTOPDriver.DRIVER).info(new InfoLine[]{TooltipBuilder.key((String)"message.rftoolspower.shiftmessage")}).infoShift(new InfoLine[]{TooltipBuilder.header(), TooltipBuilder.parameter((String)"info", stack -> {
            long power = 0L;
            CompoundNBT tagCompound = stack.func_77978_p();
            if (tagCompound != null) {
                power = tagCompound.func_74763_f("Energy");
            }
            long totpower = 0L;
            if (stack.func_77973_b() == PowerCellModule.CELL1_ITEM.get()) {
                totpower = PowerCellTileEntity.safeCast(PowerCellConfig.TIER1_MAXRF.get());
            } else if (stack.func_77973_b() == PowerCellModule.CELL2_ITEM.get()) {
                totpower = PowerCellTileEntity.safeCast(PowerCellConfig.TIER2_MAXRF.get());
            } else if (stack.func_77973_b() == PowerCellModule.CELL3_ITEM.get()) {
                totpower = PowerCellTileEntity.safeCast(PowerCellConfig.TIER3_MAXRF.get());
            }
            return Long.toString(power) + " (max " + Long.toString(totpower) + " RF/FE)";
        })}).tileEntitySupplier(() -> new PowerCellTileEntity(tier)));
    }

    public void func_180633_a(World world, BlockPos pos, BlockState state, @Nullable LivingEntity placer, ItemStack stack) {
        TileEntity te;
        super.func_180633_a(world, pos, state, placer, stack);
        if (!world.field_72995_K && (te = world.func_175625_s(pos)) instanceof PowerCellTileEntity) {
            PowerCellTileEntity powercell = (PowerCellTileEntity)te;
            long energy = stack.func_77942_o() ? stack.func_77978_p().func_74763_f("energy") : 0L;
            powercell.setLocalEnergy(energy);
            powercell.getNetwork();
            powercell.markDirtyQuick();
        }
    }

    protected boolean wrenchUse(World world, BlockPos pos, Direction side, PlayerEntity player) {
        TileEntity te;
        if (!world.field_72995_K && (te = world.func_175625_s(pos)) instanceof PowerCellTileEntity) {
            PowerCellTileEntity powerCellTileEntity = (PowerCellTileEntity)te;
            powerCellTileEntity.toggleMode(side);
        }
        return true;
    }

    @Nullable
    public BlockState func_196258_a(BlockItemUseContext context) {
        BlockPos pos;
        BlockState state = super.func_196258_a(context);
        World world = context.func_195991_k();
        return (BlockState)((BlockState)state.func_206870_a((Property)UPPER, (Comparable)Boolean.valueOf(world.func_180495_p((pos = context.func_195995_a()).func_177984_a()).func_177230_c() == this))).func_206870_a((Property)LOWER, (Comparable)Boolean.valueOf(world.func_180495_p(pos.func_177977_b()).func_177230_c() == this));
    }

    public BlockState func_196271_a(BlockState stateIn, Direction facing, BlockState facingState, IWorld world, BlockPos pos, BlockPos facingPos) {
        if (facing == Direction.UP) {
            return (BlockState)stateIn.func_206870_a((Property)UPPER, (Comparable)Boolean.valueOf(facingState.func_177230_c() == this));
        }
        if (facing == Direction.DOWN) {
            return (BlockState)stateIn.func_206870_a((Property)LOWER, (Comparable)Boolean.valueOf(facingState.func_177230_c() == this));
        }
        return stateIn;
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        super.func_206840_a(builder);
        builder.func_206894_a(new Property[]{UPPER, LOWER});
    }

    @Nonnull
    public BlockRenderType func_149645_b(BlockState state) {
        return BlockRenderType.MODEL;
    }

    public Collection<String> getTagsToPreserve() {
        return Collections.singleton("BlockEntityTag");
    }
}

