/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolspower.modules.blazing.blocks;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mcjty.lib.api.container.CapabilityContainerProvider;
import mcjty.lib.api.container.DefaultContainerProvider;
import mcjty.lib.api.infusable.CapabilityInfusable;
import mcjty.lib.api.infusable.DefaultInfusable;
import mcjty.lib.api.infusable.IInfusable;
import mcjty.lib.blocks.BaseBlock;
import mcjty.lib.builder.BlockBuilder;
import mcjty.lib.builder.InfoLine;
import mcjty.lib.builder.TooltipBuilder;
import mcjty.lib.compat.theoneprobe.TOPDriver;
import mcjty.lib.container.AutomationFilterItemHander;
import mcjty.lib.container.ContainerFactory;
import mcjty.lib.container.GenericContainer;
import mcjty.lib.container.NoDirectionItemHander;
import mcjty.lib.container.SlotDefinition;
import mcjty.lib.tileentity.GenericEnergyStorage;
import mcjty.lib.tileentity.GenericTileEntity;
import mcjty.lib.varia.EnergyTools;
import mcjty.lib.varia.RedstoneMode;
import mcjty.rftoolsbase.tools.ManualHelper;
import mcjty.rftoolspower.compat.RFToolsPowerTOPDriver;
import mcjty.rftoolspower.modules.blazing.BlazingConfiguration;
import mcjty.rftoolspower.modules.blazing.BlazingModule;
import mcjty.rftoolspower.modules.blazing.items.BlazingRod;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.inventory.container.ContainerType;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.IntReferenceHolder;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.Lazy;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.items.CapabilityItemHandler;

public class BlazingGeneratorTileEntity
extends GenericTileEntity
implements ITickableTileEntity {
    public static int BUFFER_SIZE = 4;
    public static final BooleanProperty WORKING = BooleanProperty.func_177716_a((String)"working");
    public static final Lazy<ContainerFactory> CONTAINER_FACTORY = Lazy.of(() -> new ContainerFactory(BUFFER_SIZE).slot(SlotDefinition.specific((ItemStack[])new ItemStack[]{new ItemStack((IItemProvider)BlazingModule.BLAZING_ROD.get())}).in(), "container", 0, 10, 7).slot(SlotDefinition.specific((ItemStack[])new ItemStack[]{new ItemStack((IItemProvider)BlazingModule.BLAZING_ROD.get())}).in(), "container", 1, 82, 7).slot(SlotDefinition.specific((ItemStack[])new ItemStack[]{new ItemStack((IItemProvider)BlazingModule.BLAZING_ROD.get())}).in(), "container", 2, 10, 43).slot(SlotDefinition.specific((ItemStack[])new ItemStack[]{new ItemStack((IItemProvider)BlazingModule.BLAZING_ROD.get())}).in(), "container", 3, 82, 43).playerSlots(10, 70));
    private final NoDirectionItemHander items = this.createItemHandler();
    private final LazyOptional<AutomationFilterItemHander> itemHandler = LazyOptional.of(() -> new AutomationFilterItemHander(this.items));
    private final GenericEnergyStorage energyStorage = new GenericEnergyStorage((GenericTileEntity)this, false, (long)((Integer)BlazingConfiguration.GENERATOR_MAXENERGY.get()).intValue(), 0L);
    private final LazyOptional<GenericEnergyStorage> energyHandler = LazyOptional.of(() -> this.energyStorage);
    private final IInfusable infusable = new DefaultInfusable((TileEntity)this);
    private final LazyOptional<IInfusable> infusableHandler = LazyOptional.of(() -> this.infusable);
    private final LazyOptional<INamedContainerProvider> screenHandler = LazyOptional.of(() -> new DefaultContainerProvider("Blazing Generator").containerSupplier((windowId, player) -> new GenericContainer((ContainerType)BlazingModule.CONTAINER_BLAZING_GENERATOR.get(), windowId.intValue(), (ContainerFactory)CONTAINER_FACTORY.get(), this.func_174877_v(), (GenericTileEntity)this)).itemHandler(() -> this.items).energyHandler(() -> this.energyStorage).shortListener(this.getRfPerTickHolder(0)).shortListener(this.getRfPerTickHolder(1)).shortListener(this.getRfPerTickHolder(2)).shortListener(this.getRfPerTickHolder(3)));
    private int[] rfPerTickMax = new int[BUFFER_SIZE];
    private float[] rfPerTick = new float[BUFFER_SIZE];
    private int[] ticksRemaining = new int[BUFFER_SIZE];

    private IntReferenceHolder getRfPerTickHolder(final int slot) {
        return new IntReferenceHolder(){

            public int func_221495_b() {
                return (int)BlazingGeneratorTileEntity.this.rfPerTick[slot];
            }

            public void func_221494_a(int value) {
                ((BlazingGeneratorTileEntity)BlazingGeneratorTileEntity.this).rfPerTick[slot] = value;
            }
        };
    }

    public BlazingGeneratorTileEntity() {
        super((TileEntityType)BlazingModule.TYPE_BLAZING_GENERATOR.get());
    }

    public static BaseBlock createBlock() {
        return new BaseBlock(new BlockBuilder().properties(AbstractBlock.Properties.func_200945_a((Material)Material.field_151573_f).func_200943_b(2.0f).func_200947_a(SoundType.field_185852_e)).topDriver((TOPDriver)RFToolsPowerTOPDriver.DRIVER).infusable().manualEntry(ManualHelper.create((String)"rftoolspower:powergeneration/blazinggenerator")).info(new InfoLine[]{TooltipBuilder.key((String)"message.rftoolspower.shiftmessage")}).infoShift(new InfoLine[]{TooltipBuilder.header(), TooltipBuilder.gold()}).tileEntitySupplier(BlazingGeneratorTileEntity::new)){

            protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
                super.func_206840_a(builder);
                builder.func_206894_a(new Property[]{WORKING});
            }
        };
    }

    protected boolean needsRedstoneMode() {
        return true;
    }

    public void func_73660_a() {
        if (!this.field_145850_b.field_72995_K) {
            this.handleSendingEnergy();
            this.handlePowerGeneration();
        }
    }

    public void setPowerInput(int powered) {
        if (this.powerLevel != powered) {
            super.setPowerInput(powered);
            for (int i = 0; i < BUFFER_SIZE; ++i) {
                this.updateSlot(i);
            }
        }
    }

    public void setRSMode(RedstoneMode redstoneMode) {
        super.setRSMode(redstoneMode);
        for (int i = 0; i < BUFFER_SIZE; ++i) {
            this.updateSlot(i);
        }
    }

    public float getRfPerTick(int slot) {
        return this.rfPerTick[slot];
    }

    private void handleSendingEnergy() {
        long storedPower = this.energyStorage.getEnergy();
        EnergyTools.handleSendingEnergy((World)this.field_145850_b, (BlockPos)this.field_174879_c, (long)storedPower, (long)((Integer)BlazingConfiguration.GENERATOR_SENDPERTICK.get()).intValue(), (GenericEnergyStorage)this.energyStorage);
    }

    private void handlePowerGeneration() {
        int totalRfGenerated = 0;
        for (int i = 0; i < BUFFER_SIZE; ++i) {
            if (this.rfPerTick[i] > (float)this.rfPerTickMax[i]) {
                int n = i;
                this.rfPerTick[n] = this.rfPerTick[n] + ((float)this.rfPerTickMax[i] - this.rfPerTick[i]) / 30.0f;
                if (this.rfPerTick[i] < (float)this.rfPerTickMax[i]) {
                    this.rfPerTick[i] = this.rfPerTickMax[i];
                }
            } else if (this.rfPerTick[i] < (float)this.rfPerTickMax[i]) {
                int n = i;
                this.rfPerTick[n] = this.rfPerTick[n] + (((float)this.rfPerTickMax[i] - this.rfPerTick[i]) / 150.0f + 0.01f);
                if (this.rfPerTick[i] > (float)this.rfPerTickMax[i]) {
                    this.rfPerTick[i] = this.rfPerTickMax[i];
                }
            }
            totalRfGenerated += (int)this.rfPerTick[i];
            if (!this.isMachineEnabled()) continue;
            int n = i;
            this.ticksRemaining[n] = this.ticksRemaining[n] - 1;
            ItemStack stack = this.items.getStackInSlot(i);
            if (this.ticksRemaining[i] <= 0) {
                this.ticksRemaining[i] = 0;
                this.rfPerTickMax[i] = 0;
                if (stack.func_190926_b()) continue;
                this.items.setStackInSlot(i, ItemStack.field_190927_a);
                continue;
            }
            if (stack.func_190926_b()) continue;
            BlazingRod.setPowerDuration(stack, this.ticksRemaining[i]);
        }
        this.energyStorage.produceEnergy((long)totalRfGenerated);
        boolean generating = totalRfGenerated > 0;
        BlockState state = this.field_145850_b.func_180495_p(this.field_174879_c);
        if ((Boolean)state.func_177229_b((Property)WORKING) != generating) {
            this.field_145850_b.func_180501_a(this.field_174879_c, (BlockState)state.func_206870_a((Property)WORKING, (Comparable)Boolean.valueOf(generating)), 3);
        }
        this.markDirtyQuick();
    }

    private void updateSlot(int slot) {
        ItemStack stack = this.items.getStackInSlot(slot);
        if (stack.func_190926_b() || !this.isMachineEnabled()) {
            this.rfPerTickMax[slot] = 0;
            this.ticksRemaining[slot] = 0;
        } else {
            this.rfPerTickMax[slot] = (int)((float)BlazingRod.getRfPerTick(stack) * (this.infusable.getInfusedFactor() * 0.1f + 1.0f));
            this.ticksRemaining[slot] = BlazingRod.getTotalTicks(stack);
        }
    }

    public void read(CompoundNBT tagCompound) {
        super.read(tagCompound);
        for (int i = 0; i < BUFFER_SIZE; ++i) {
            this.rfPerTickMax[i] = tagCompound.func_74762_e("rftMax" + i);
            this.rfPerTick[i] = tagCompound.func_74760_g("rft" + i);
            this.ticksRemaining[i] = tagCompound.func_74762_e("ticks" + i);
        }
    }

    public CompoundNBT func_189515_b(CompoundNBT tagCompound) {
        for (int i = 0; i < BUFFER_SIZE; ++i) {
            tagCompound.func_74768_a("rftMax" + i, this.rfPerTickMax[i]);
            tagCompound.func_74776_a("rft" + i, this.rfPerTick[i]);
            tagCompound.func_74768_a("ticks" + i, this.ticksRemaining[i]);
        }
        return super.func_189515_b(tagCompound);
    }

    private NoDirectionItemHander createItemHandler() {
        return new NoDirectionItemHander(this, (ContainerFactory)CONTAINER_FACTORY.get()){

            public boolean isItemValid(int slot, @Nonnull ItemStack stack) {
                return stack.func_77973_b() == BlazingModule.BLAZING_ROD.get();
            }

            public boolean isItemInsertable(int slot, @Nonnull ItemStack stack) {
                return this.isItemValid(slot, stack);
            }

            public int getSlotLimit(int slot) {
                return 1;
            }

            protected void onUpdate(int index) {
                BlazingGeneratorTileEntity.this.updateSlot(index);
                super.onUpdate(index);
            }
        };
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction facing) {
        if (cap == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return this.itemHandler.cast();
        }
        if (cap == CapabilityEnergy.ENERGY) {
            return this.energyHandler.cast();
        }
        if (cap == CapabilityContainerProvider.CONTAINER_PROVIDER_CAPABILITY) {
            return this.screenHandler.cast();
        }
        if (cap == CapabilityInfusable.INFUSABLE_CAPABILITY) {
            return this.infusableHandler.cast();
        }
        return super.getCapability(cap, facing);
    }
}

