/*
 * Decompiled with CFR 0.152.
 */
package it.zerono.mods.zerocore.lib.multiblock.cuboid;

import it.zerono.mods.zerocore.lib.CodeHelper;
import it.zerono.mods.zerocore.lib.block.BlockFacings;
import it.zerono.mods.zerocore.lib.data.geometry.CuboidBoundingBox;
import it.zerono.mods.zerocore.lib.multiblock.AbstractMultiblockController;
import it.zerono.mods.zerocore.lib.multiblock.IMultiblockPart;
import it.zerono.mods.zerocore.lib.multiblock.cuboid.AbstractCuboidMultiblockPart;
import it.zerono.mods.zerocore.lib.multiblock.cuboid.PartPosition;
import it.zerono.mods.zerocore.lib.multiblock.validation.IMultiblockValidator;
import it.zerono.mods.zerocore.lib.multiblock.validation.ValidationError;
import it.zerono.mods.zerocore.lib.world.NeighboringPositions;
import net.minecraft.block.BlockState;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public abstract class AbstractCuboidMultiblockController<Controller extends AbstractCuboidMultiblockController<Controller>>
extends AbstractMultiblockController<Controller> {
    private static final String[] s_errors = new String[5];

    @Override
    protected CuboidBoundingBox buildBoundingBox() {
        return this._connectedParts.boundingBox();
    }

    @Override
    protected NeighboringPositions getNeighboringPositionsToVisit() {
        return new NeighboringPositions(CodeHelper.POSITIVE_DIRECTIONS);
    }

    @Override
    protected boolean isMachineWhole(IMultiblockValidator validatorCallback) {
        int z;
        int y;
        int x;
        CuboidBoundingBox bb = this.getBoundingBox();
        if (this.getPartsCount() < this.getMinimumNumberOfPartsForAssembledMachine() || bb.isEmpty()) {
            validatorCallback.setLastError(ValidationError.VALIDATION_ERROR_TOO_FEW_PARTS);
            return false;
        }
        World world = this.getWorld();
        BlockPos boundingBoxMin = bb.getMin();
        BlockPos boundingBoxMax = bb.getMax();
        int minX = boundingBoxMin.func_177958_n();
        int minY = boundingBoxMin.func_177956_o();
        int minZ = boundingBoxMin.func_177952_p();
        int maxX = boundingBoxMax.func_177958_n();
        int maxY = boundingBoxMax.func_177956_o();
        int maxZ = boundingBoxMax.func_177952_p();
        if (AbstractCuboidMultiblockController.isSizeWrong(validatorCallback, Direction.Axis.X, this.getMinimumXSize(), this.getMaximumXSize(), maxX - minX + 1) || AbstractCuboidMultiblockController.isSizeWrong(validatorCallback, Direction.Axis.Y, this.getMinimumYSize(), this.getMaximumYSize(), maxY - minY + 1) || AbstractCuboidMultiblockController.isSizeWrong(validatorCallback, Direction.Axis.Z, this.getMinimumZSize(), this.getMaximumZSize(), maxZ - minZ + 1)) {
            return false;
        }
        if (null != this._detachedParts && !this._detachedParts.isEmpty()) {
            for (IMultiblockPart part : this._detachedParts) {
                boolean isValid;
                int errorIndex;
                BlockPos partLocation = part.getWorldPosition();
                x = partLocation.func_177958_n();
                y = partLocation.func_177956_o();
                z = partLocation.func_177952_p();
                int extremes = 0;
                if (x == minX) {
                    ++extremes;
                }
                if (x == maxX) {
                    ++extremes;
                }
                if (y == minY) {
                    ++extremes;
                }
                if (y == maxY) {
                    ++extremes;
                }
                if (z == minZ) {
                    ++extremes;
                }
                if (z == maxZ) {
                    ++extremes;
                }
                if (extremes >= 2) {
                    errorIndex = 0;
                    isValid = this.isBlockGoodForFrame(world, x, y, z, validatorCallback);
                } else if (1 == extremes) {
                    if (y == maxY) {
                        errorIndex = 1;
                        isValid = this.isBlockGoodForTop(world, x, y, z, validatorCallback);
                    } else if (y == minY) {
                        errorIndex = 2;
                        isValid = this.isBlockGoodForBottom(world, x, y, z, validatorCallback);
                    } else {
                        errorIndex = 3;
                        isValid = this.isBlockGoodForSides(world, x, y, z, validatorCallback);
                    }
                } else {
                    errorIndex = 4;
                    isValid = this.isBlockGoodForInterior(world, x, y, z, validatorCallback);
                }
                if (isValid) continue;
                if (validatorCallback.isLastErrorEmpty()) {
                    validatorCallback.setLastError(partLocation, s_errors[errorIndex], new Object[0]);
                }
                return false;
            }
            this._detachedParts.clear();
        }
        BlockPos.Mutable partLocation = new BlockPos.Mutable();
        for (x = minX; x <= maxX; ++x) {
            for (y = minY; y <= maxY; ++y) {
                for (z = minZ; z <= maxZ; ++z) {
                    boolean isValid;
                    int errorIndex;
                    partLocation.func_181079_c(x, y, z);
                    IMultiblockPart<AbstractCuboidMultiblockController> part = this._connectedParts.get(BlockPos.func_218276_a((int)x, (int)y, (int)z));
                    int extremes = 0;
                    boolean downFacing = false;
                    boolean upFacing = false;
                    boolean northFacing = false;
                    boolean southFacing = false;
                    boolean westFacing = false;
                    boolean eastFacing = false;
                    if (x == minX) {
                        ++extremes;
                        westFacing = true;
                    }
                    if (x == maxX) {
                        ++extremes;
                        eastFacing = true;
                    }
                    if (y == minY) {
                        ++extremes;
                        downFacing = true;
                    }
                    if (y == maxY) {
                        ++extremes;
                        upFacing = true;
                    }
                    if (z == minZ) {
                        ++extremes;
                        northFacing = true;
                    }
                    if (z == maxZ) {
                        ++extremes;
                        southFacing = true;
                    }
                    if (part instanceof AbstractCuboidMultiblockPart) {
                        PartPosition partPosition;
                        if (!part.testOnController(this::isControllerCompatible)) {
                            validatorCallback.setLastError((BlockPos)partLocation, "zerocore:api.multiblock.validation.invalid_part", new Object[0]);
                            return false;
                        }
                        if (extremes >= 2) {
                            errorIndex = 0;
                            partPosition = !eastFacing && !westFacing ? PartPosition.FrameEastWest : (!southFacing && !northFacing ? PartPosition.FrameSouthNorth : PartPosition.FrameUpDown);
                        } else if (1 == extremes) {
                            if (y == maxY) {
                                errorIndex = 1;
                                partPosition = PartPosition.TopFace;
                            } else if (y == minY) {
                                errorIndex = 2;
                                partPosition = PartPosition.BottomFace;
                            } else {
                                errorIndex = 3;
                                partPosition = eastFacing ? PartPosition.EastFace : (westFacing ? PartPosition.WestFace : (southFacing ? PartPosition.SouthFace : (northFacing ? PartPosition.NorthFace : (upFacing ? PartPosition.TopFace : PartPosition.BottomFace))));
                            }
                        } else {
                            errorIndex = 4;
                            partPosition = PartPosition.Interior;
                        }
                        BlockFacings facings = BlockFacings.from(downFacing, upFacing, northFacing, southFacing, westFacing, eastFacing);
                        ((AbstractCuboidMultiblockPart)part).setPartPosition(partPosition, facings);
                        isValid = ((AbstractCuboidMultiblockPart)part).isGoodForPosition(partPosition, validatorCallback);
                    } else if (extremes >= 2) {
                        errorIndex = 0;
                        isValid = this.isBlockGoodForFrame(world, x, y, z, validatorCallback);
                    } else if (1 == extremes) {
                        if (y == maxY) {
                            errorIndex = 1;
                            isValid = this.isBlockGoodForTop(world, x, y, z, validatorCallback);
                        } else if (y == minY) {
                            errorIndex = 2;
                            isValid = this.isBlockGoodForBottom(world, x, y, z, validatorCallback);
                        } else {
                            errorIndex = 3;
                            isValid = this.isBlockGoodForSides(world, x, y, z, validatorCallback);
                        }
                    } else {
                        errorIndex = 4;
                        isValid = this.isBlockGoodForInterior(world, x, y, z, validatorCallback);
                    }
                    if (isValid) continue;
                    if (validatorCallback.isLastErrorEmpty()) {
                        validatorCallback.setLastError((BlockPos)partLocation, s_errors[errorIndex], new Object[0]);
                    }
                    return false;
                }
            }
        }
        return true;
    }

    @Override
    public void forceStructureUpdate(World world) {
        CuboidBoundingBox bb = this.getBoundingBox();
        if (bb.isEmpty()) {
            return;
        }
        BlockPos minCoord = bb.getMin();
        BlockPos maxCoord = bb.getMax();
        int minX = minCoord.func_177958_n();
        int minY = minCoord.func_177956_o();
        int minZ = minCoord.func_177952_p();
        int maxX = maxCoord.func_177958_n();
        int maxY = maxCoord.func_177956_o();
        int maxZ = maxCoord.func_177952_p();
        BlockPos.Mutable pos = new BlockPos.Mutable();
        for (int x = minX; x <= maxX; ++x) {
            for (int y = minY; y <= maxY; ++y) {
                for (int z = minZ; z <= maxZ; ++z) {
                    BlockState state = world.func_180495_p((BlockPos)pos.func_181079_c(x, y, z));
                    world.func_184138_a((BlockPos)pos, state, state, 3);
                }
            }
        }
    }

    protected AbstractCuboidMultiblockController(World world) {
        super(world);
    }

    private static boolean isSizeWrong(IMultiblockValidator validatorCallback, Direction.Axis axis, int minSize, int maxSize, int size) {
        if (maxSize > 0 && size > maxSize) {
            validatorCallback.setLastError("zerocore:api.multiblock.validation.machine_too_large", maxSize, axis.func_176610_l());
            return true;
        }
        if (size < minSize) {
            validatorCallback.setLastError("zerocore:api.multiblock.validation.machine_too_small", minSize, axis.func_176610_l());
            return true;
        }
        return false;
    }

    static {
        AbstractCuboidMultiblockController.s_errors[0] = "zerocore:api.multiblock.validation.invalid_part_for_frame";
        AbstractCuboidMultiblockController.s_errors[1] = "zerocore:api.multiblock.validation.invalid_part_for_top";
        AbstractCuboidMultiblockController.s_errors[2] = "zerocore:api.multiblock.validation.invalid_part_for_bottom";
        AbstractCuboidMultiblockController.s_errors[3] = "zerocore:api.multiblock.validation.invalid_part_for_sides";
        AbstractCuboidMultiblockController.s_errors[4] = "zerocore:api.multiblock.validation.invalid_part_for_interior";
    }
}

