/*
 * Decompiled with CFR 0.152.
 */
package it.zerono.mods.zerocore.lib.energy;

import it.zerono.mods.zerocore.lib.data.stack.OperationMode;
import it.zerono.mods.zerocore.lib.energy.EnergySystem;
import it.zerono.mods.zerocore.lib.energy.IWideEnergyProvider;
import it.zerono.mods.zerocore.lib.energy.IWideEnergyReceiver;
import it.zerono.mods.zerocore.lib.energy.IWideEnergyStorage;
import javax.annotation.Nullable;
import net.minecraft.util.Direction;

public final class EnergyHelper {
    public static double transferEnergy(IWideEnergyStorage destination, IWideEnergyStorage source, double maxAmount, OperationMode mode) {
        EnergySystem sys = destination.getEnergySystem();
        return destination.insertEnergy(sys, source.extractEnergy(sys, maxAmount, mode.simulate()), mode.simulate());
    }

    public static int transferEnergy(IWideEnergyStorage destination, IWideEnergyStorage source, int maxAmount, OperationMode mode) {
        return (int)EnergyHelper.transferEnergy(destination, source, (double)maxAmount, mode);
    }

    public static double transferEnergy(IWideEnergyReceiver destination, @Nullable Direction destinationDirection, IWideEnergyProvider source, @Nullable Direction sourceDirection, double maxAmount, OperationMode mode) {
        EnergySystem sys = destination.getEnergySystem();
        return destination.receiveEnergy(sys, destinationDirection, source.extractEnergy(sys, sourceDirection, maxAmount, mode.simulate()), mode.simulate());
    }

    public static int transferEnergy(IWideEnergyReceiver destination, @Nullable Direction destinationDirection, IWideEnergyProvider source, @Nullable Direction sourceDirection, int maxAmount, OperationMode mode) {
        return (int)EnergyHelper.transferEnergy(destination, destinationDirection, source, sourceDirection, (double)maxAmount, mode);
    }

    private EnergyHelper() {
    }
}

