/*
 * Decompiled with CFR 0.152.
 */
package it.zerono.mods.zerocore.lib.client.gui.layout;

import it.zerono.mods.zerocore.lib.client.gui.DesiredDimension;
import it.zerono.mods.zerocore.lib.client.gui.IControl;
import it.zerono.mods.zerocore.lib.client.gui.IControlContainer;
import it.zerono.mods.zerocore.lib.client.gui.layout.AbstractLayoutEngine;
import it.zerono.mods.zerocore.lib.client.gui.layout.ILayoutEngine;
import it.zerono.mods.zerocore.lib.data.geometry.Rectangle;

public class FixedLayoutEngine
extends AbstractLayoutEngine<FixedLayoutEngine> {
    public static ILayoutEngine.ILayoutEngineHint hint(int x, int y, int width, int height) {
        return new FixedLayoutHint(x, y, width, height);
    }

    public static ILayoutEngine.ILayoutEngineHint hint(int x, int y) {
        return new FixedLayoutHint(x, y, -1, -1);
    }

    @Override
    public void layout(IControlContainer container) {
        container.forEach(control -> control.getLayoutEngineHint().filter(hint -> hint instanceof FixedLayoutHint).map(hint -> (FixedLayoutHint)hint).ifPresent(fixedHint -> control.setBounds(new Rectangle(((FixedLayoutHint)fixedHint).X, ((FixedLayoutHint)fixedHint).Y, fixedHint.getDimension(DesiredDimension.Width, (IControl)control), fixedHint.getDimension(DesiredDimension.Height, (IControl)control)))));
    }

    private static class FixedLayoutHint
    implements ILayoutEngine.ILayoutEngineHint {
        private final int X;
        private final int Y;
        private final int Width;
        private final int Height;

        FixedLayoutHint(int x, int y, int width, int height) {
            this.X = x;
            this.Y = y;
            this.Width = width;
            this.Height = height;
        }

        int getDimension(DesiredDimension dimension, IControl control) {
            int value = DesiredDimension.Width == dimension ? this.Width : this.Height;
            return -1 != value ? value : control.getDesiredDimension(dimension);
        }
    }
}

