/*
 * Decompiled with CFR 0.152.
 */
package it.zerono.mods.zerocore.lib.client.gui;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.mojang.blaze3d.matrix.MatrixStack;
import it.zerono.mods.zerocore.lib.client.gui.IRichText;
import it.zerono.mods.zerocore.lib.client.gui.sprite.ISprite;
import it.zerono.mods.zerocore.lib.client.render.ModRenderHelper;
import it.zerono.mods.zerocore.lib.data.geometry.Point;
import it.zerono.mods.zerocore.lib.data.geometry.Rectangle;
import it.zerono.mods.zerocore.lib.data.gfx.Colour;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Stream;
import net.minecraft.block.Block;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.ITextProperties;
import net.minecraft.util.text.StringTextComponent;
import net.minecraftforge.common.util.NonNullSupplier;

public class RichText
implements IRichText {
    public static final RichText EMPTY = new RichText();
    final List<TextLine> _lines;
    final NonNullSupplier<FontRenderer> _fontSupplier;
    private Colour _textColour;
    private int _interline;
    private Rectangle _bounds;
    private final boolean _dynamic;

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(int maxWidth) {
        return new WrappedBuilder(maxWidth);
    }

    @Override
    public void paint(MatrixStack matrix, int x, int y, int zLevel) {
        matrix.func_227860_a_();
        matrix.func_227861_a_(0.0, 0.0, (double)zLevel);
        for (TextLine line : this._lines) {
            line.paint(this, matrix, x, y);
            y += line.getHeight() + this._interline;
        }
        matrix.func_227865_b_();
    }

    @Override
    public Rectangle bounds() {
        if (null == this._bounds || this._dynamic) {
            this._bounds = new Rectangle(0, 0, this._lines.stream().mapToInt(TextLine::getWidth).max().orElse(0), (this._lines.size() - 1) * this._interline + this._lines.stream().mapToInt(TextLine::getHeight).sum());
        }
        return this._bounds;
    }

    @Override
    public boolean isEmpty() {
        return this._lines.isEmpty();
    }

    @Override
    public boolean isNotEmpty() {
        return !this._lines.isEmpty();
    }

    private RichText() {
        this(ModRenderHelper.DEFAULT_FONT_RENDERER, Collections.emptyList());
    }

    private RichText(NonNullSupplier<FontRenderer> font, List<TextLine> lines) {
        this._lines = lines;
        this._fontSupplier = font;
        this._textColour = Colour.BLACK;
        this._interline = 0;
        this._bounds = null;
        this._dynamic = this._lines.stream().anyMatch(TextLine::isDynamic);
    }

    private static void paintString(RichText richText, String chunk, MatrixStack matrix, int x, int y) {
        ((FontRenderer)richText._fontSupplier.get()).func_238405_a_(matrix, chunk, (float)x, (float)y, richText._textColour.toARGB());
    }

    private static void paintString(RichText richText, ITextComponent chunk, MatrixStack matrix, int x, int y) {
        ((FontRenderer)richText._fontSupplier.get()).func_243246_a(matrix, chunk, (float)x, (float)y, richText._textColour.toARGB());
    }

    private static void paintItemStack(RichText richText, ItemStack chunk, MatrixStack matrix, int x, int y) {
        ModRenderHelper.paintItemStackWithCount(matrix, chunk, x, y, false);
    }

    private static void paintItemStackNoCount(RichText richText, ItemStack chunk, MatrixStack matrix, int x, int y) {
        ModRenderHelper.paintItemStack(matrix, chunk, x, y, "", false);
    }

    private static void paintSprite(RichText richText, ISprite chunk, MatrixStack matrix, int x, int y) {
        ModRenderHelper.paintSprite(matrix, chunk, new Point(x, y), 0, 16, 16);
    }

    protected static class WrappedBuilder
    extends Builder {
        private final int _maxWidth;

        protected WrappedBuilder(int maxWidth) {
            Preconditions.checkArgument((maxWidth > 0 ? 1 : 0) != 0);
            this._maxWidth = maxWidth;
        }

        @Override
        protected List<TextLine> buildLines(List<ITextComponent> lines, List<Object> objects) {
            Function<ITextComponent, Stream> mapper = this._objects.isEmpty() ? this::splitTextOnlyLine : this::splitFormattedLine;
            return (List)this._lines.stream().flatMap(mapper).collect(ImmutableList.toImmutableList());
        }

        private Stream<TextLine> splitTextOnlyLine(ITextComponent line) {
            String text;
            FontRenderer font = (FontRenderer)this._fontSupplier.get();
            if (this._maxWidth > font.func_78256_a(text = line.getString())) {
                return Stream.of(TextLine.from(this.chunk(text)));
            }
            return ModRenderHelper.wrapLines(text, this._maxWidth, font).stream().map(s -> TextLine.from(this.chunk((String)s)));
        }

        private Stream<TextLine> splitFormattedLine(ITextComponent line) {
            List<ITextChunk> chunks = this.splitFormattedTextLineChunks(line);
            Integer[] chunksWidths = (Integer[])chunks.stream().map(ITextChunk::getWidth).toArray(Integer[]::new);
            LinkedList lines = Lists.newLinkedList();
            LinkedList currentLineChunks = Lists.newLinkedList();
            int lineWidth = 0;
            for (int i = 0; i < chunks.size(); ++i) {
                if (lineWidth + chunksWidths[i] > this._maxWidth) {
                    lines.add(TextLine.from(currentLineChunks));
                    currentLineChunks.clear();
                    lineWidth = 0;
                    continue;
                }
                currentLineChunks.add(chunks.get(i));
                lineWidth += chunksWidths[i].intValue();
            }
            if (!currentLineChunks.isEmpty()) {
                lines.add(TextLine.from(currentLineChunks));
            }
            return lines.stream();
        }
    }

    public static class Builder {
        protected List<ITextComponent> _lines = Collections.emptyList();
        protected List<Object> _objects = Collections.emptyList();
        protected NonNullSupplier<FontRenderer> _fontSupplier = ModRenderHelper.DEFAULT_FONT_RENDERER;
        protected Colour _textColour = Colour.BLACK;
        protected int _interline = 0;

        public RichText build() {
            RichText rich = new RichText(this._fontSupplier, this.buildLines(this._lines, this._objects));
            rich._textColour = this._textColour;
            rich._interline = this._interline;
            return rich;
        }

        public Builder textLines(List<ITextComponent> lines) {
            Preconditions.checkArgument((!lines.isEmpty() ? 1 : 0) != 0);
            this._lines = lines;
            return this;
        }

        public Builder textLines(ITextComponent line) {
            return this.textLines((List<ITextComponent>)ImmutableList.of((Object)line));
        }

        public Builder textLines(ITextComponent ... lines) {
            return this.textLines((List<ITextComponent>)ImmutableList.copyOf((Object[])lines));
        }

        public Builder objects(List<Object> objects) {
            this._objects = objects;
            return this;
        }

        public Builder font(NonNullSupplier<FontRenderer> font) {
            this._fontSupplier = Objects.requireNonNull(font);
            return this;
        }

        public Builder defaultColour(Colour colour) {
            this._textColour = Objects.requireNonNull(colour);
            return this;
        }

        public Builder interline(int interline) {
            this._interline = interline;
            return this;
        }

        protected Builder() {
        }

        protected List<TextLine> buildLines(List<ITextComponent> lines, List<Object> objects) {
            List textLines = objects.isEmpty() ? (List)lines.stream().map(line -> TextLine.from(this.chunk((ITextComponent)line))).collect(ImmutableList.toImmutableList()) : (List)lines.stream().map(this::formattedTextLine).collect(ImmutableList.toImmutableList());
            return textLines;
        }

        protected ITextChunk chunk(ITextComponent text) {
            int n = ((FontRenderer)this._fontSupplier.get()).func_238414_a_((ITextProperties)text);
            ((FontRenderer)this._fontSupplier.get()).getClass();
            return new TextChunk<ITextComponent>(text, n, 9, (x$0, x$1, x$2, x$3, x$4) -> RichText.paintString(x$0, x$1, x$2, x$3, x$4));
        }

        protected ITextChunk chunk(String text) {
            int n = ((FontRenderer)this._fontSupplier.get()).func_78256_a(text);
            ((FontRenderer)this._fontSupplier.get()).getClass();
            return new TextChunk<String>(text, n, 9, (x$0, x$1, x$2, x$3, x$4) -> RichText.paintString(x$0, x$1, x$2, x$3, x$4));
        }

        private ITextChunk chunk(Supplier<String> text) {
            return new DynamicTextChunk(text, this._fontSupplier);
        }

        private ITextChunk chunk(NonNullSupplier<ITextComponent> text) {
            return new TranslationTextChunk(text, this._fontSupplier);
        }

        private ITextChunk chunk(ItemStack stack) {
            return new TextChunk<ItemStack>(stack, 16, 16, (x$0, x$1, x$2, x$3, x$4) -> RichText.paintItemStack(x$0, x$1, x$2, x$3, x$4));
        }

        private ITextChunk chunk(IItemProvider item) {
            return new TextChunk<ItemStack>(new ItemStack(item), 16, 16, (x$0, x$1, x$2, x$3, x$4) -> RichText.paintItemStackNoCount(x$0, x$1, x$2, x$3, x$4));
        }

        private ITextChunk chunk(ISprite sprite) {
            return new TextChunk<ISprite>(sprite, 16, 16, (x$0, x$1, x$2, x$3, x$4) -> RichText.paintSprite(x$0, x$1, x$2, x$3, x$4));
        }

        private ITextChunk genericChunk(Object thing) {
            if (thing instanceof String) {
                return this.chunk((String)thing);
            }
            if (thing instanceof Supplier) {
                return this.chunk((Supplier)thing);
            }
            if (thing instanceof NonNullSupplier) {
                return this.chunk((NonNullSupplier<ITextComponent>)((NonNullSupplier)thing));
            }
            if (thing instanceof ItemStack) {
                return this.chunk((ItemStack)thing);
            }
            if (thing instanceof Item) {
                return this.chunk((IItemProvider)((Item)thing));
            }
            if (thing instanceof Block) {
                return this.chunk((IItemProvider)((Block)thing));
            }
            if (thing instanceof ISprite) {
                return this.chunk((ISprite)thing);
            }
            return this.chunk("");
        }

        private TextLine formattedTextLine(ITextComponent originalText) {
            return TextLine.from(this.splitFormattedTextLineChunks(originalText));
        }

        protected List<ITextChunk> splitFormattedTextLineChunks(ITextComponent originalText) {
            String line = originalText.getString();
            if (Strings.isNullOrEmpty((String)line) || !line.contains("@")) {
                return Lists.newArrayList((Object[])new ITextChunk[]{this.chunk(originalText)});
            }
            LinkedList lineChunks = Lists.newLinkedList();
            StringBuilder sb = new StringBuilder();
            for (int index = 0; index < line.length(); ++index) {
                String currentChar = line.substring(index, index + 1);
                if ("@".equals(currentChar)) {
                    int objectIndex;
                    if (16 == (objectIndex = line.charAt(++index) - 48)) {
                        sb.append('@');
                        continue;
                    }
                    if (objectIndex < 0 || objectIndex > 9 || objectIndex >= this._objects.size()) {
                        throw new IllegalArgumentException(line);
                    }
                    if (sb.length() > 0) {
                        lineChunks.add(this.chunk((ITextComponent)new StringTextComponent(sb.toString()).func_230530_a_(originalText.func_150256_b())));
                        sb = new StringBuilder();
                    }
                    lineChunks.add(this.genericChunk(this._objects.get(objectIndex)));
                    continue;
                }
                sb.append(currentChar);
            }
            if (sb.length() > 0) {
                lineChunks.add(this.chunk((ITextComponent)new StringTextComponent(sb.toString()).func_230530_a_(originalText.func_150256_b())));
            }
            return lineChunks;
        }
    }

    private static class TranslationTextChunk
    extends TextChunk<NonNullSupplier<ITextComponent>> {
        private final NonNullSupplier<FontRenderer> _fontSupplier;

        public TranslationTextChunk(NonNullSupplier<ITextComponent> thing, NonNullSupplier<FontRenderer> fontSupplier) {
            ((FontRenderer)fontSupplier.get()).getClass();
            super(thing, 0, 9, TranslationTextChunk::paintString);
            this._fontSupplier = fontSupplier;
        }

        @Override
        public int getWidth() {
            return ((FontRenderer)this._fontSupplier.get()).func_238414_a_((ITextProperties)((NonNullSupplier)this.get()).get());
        }

        private static void paintString(RichText richText, NonNullSupplier<ITextComponent> chunk, MatrixStack matrix, int x, int y) {
            RichText.paintString(richText, (ITextComponent)chunk.get(), matrix, x, y);
        }
    }

    private static class DynamicTextChunk
    extends TextChunk<Supplier<String>> {
        private final NonNullSupplier<FontRenderer> _fontSupplier;

        public DynamicTextChunk(Supplier<String> thing, NonNullSupplier<FontRenderer> fontSupplier) {
            ((FontRenderer)fontSupplier.get()).getClass();
            super(thing, 0, 9, DynamicTextChunk::paintString);
            this._fontSupplier = fontSupplier;
        }

        @Override
        public int getWidth() {
            return ((FontRenderer)this._fontSupplier.get()).func_78256_a((String)((Supplier)this.get()).get());
        }

        private static void paintString(RichText richText, Supplier<String> chunk, MatrixStack matrix, int x, int y) {
            RichText.paintString(richText, chunk.get(), matrix, x, y);
        }
    }

    private static class TextChunk<T>
    implements ITextChunk,
    NonNullSupplier<T> {
        private final T _thing;
        private final int _width;
        private final int _height;
        private final IChunkPainter<T> _painter;

        public TextChunk(T thing, int width, int height, IChunkPainter<T> painter) {
            this._thing = Objects.requireNonNull(thing);
            this._width = width;
            this._height = height;
            this._painter = Objects.requireNonNull(painter);
        }

        @Override
        public int getWidth() {
            return this._width;
        }

        @Override
        public int getHeight() {
            return this._height;
        }

        @Override
        public void paint(RichText richText, MatrixStack matrix, int x, int y) {
            this._painter.paint(richText, this._thing, matrix, x, y);
        }

        public T get() {
            return this._thing;
        }

        @FunctionalInterface
        public static interface IChunkPainter<T> {
            public void paint(RichText var1, T var2, MatrixStack var3, int var4, int var5);
        }
    }

    private static class TextLine
    implements ITextChunk {
        final List<ITextChunk> _chunks;
        final int _maxWidth;
        final int _maxHeight;
        final boolean _dynamic;

        public static TextLine from(ITextChunk chunk) {
            return new TextLine(chunk);
        }

        public static TextLine from(List<ITextChunk> chunks) {
            return 1 == chunks.size() ? new TextLine(chunks.get(0)) : new TextLine(chunks);
        }

        private TextLine(ITextChunk chunk) {
            Preconditions.checkNotNull((Object)chunk);
            this._chunks = ImmutableList.of((Object)chunk);
            this._dynamic = false;
            this._maxWidth = chunk.getWidth();
            this._maxHeight = chunk.getHeight();
        }

        private TextLine(List<ITextChunk> chunks) {
            Preconditions.checkArgument((!chunks.isEmpty() ? 1 : 0) != 0);
            this._chunks = ImmutableList.copyOf(chunks);
            this._dynamic = this._chunks.stream().anyMatch(c -> c instanceof DynamicTextChunk);
            this._maxWidth = this._dynamic ? -1 : this.computeMaxWidth();
            this._maxHeight = this._chunks.stream().mapToInt(ITextChunk::getHeight).max().orElse(0);
        }

        public boolean isDynamic() {
            return this._dynamic;
        }

        @Override
        public int getWidth() {
            return this._dynamic ? this.computeMaxWidth() : this._maxWidth;
        }

        @Override
        public int getHeight() {
            return this._maxHeight;
        }

        @Override
        public void paint(RichText richText, MatrixStack matrix, int x, int y) {
            for (ITextChunk chunk : this._chunks) {
                chunk.paint(richText, matrix, x, y + (this._maxHeight - chunk.getHeight()) / 2);
                x += chunk.getWidth();
            }
        }

        private int computeMaxWidth() {
            return this._chunks.stream().mapToInt(ITextChunk::getWidth).sum();
        }
    }

    private static interface ITextChunk {
        public int getWidth();

        public int getHeight();

        public void paint(RichText var1, MatrixStack var2, int var3, int var4);
    }
}

