/*
 * Decompiled with CFR 0.152.
 */
package it.zerono.mods.zerocore.lib.block.multiblock;

import it.zerono.mods.zerocore.lib.CodeHelper;
import it.zerono.mods.zerocore.lib.block.AbstractModBlockEntity;
import it.zerono.mods.zerocore.lib.block.ModBlock;
import it.zerono.mods.zerocore.lib.block.multiblock.IMultiblockPartType;
import it.zerono.mods.zerocore.lib.multiblock.IMultiblockController;
import it.zerono.mods.zerocore.lib.multiblock.IMultiblockPart;
import it.zerono.mods.zerocore.lib.multiblock.validation.IMultiblockValidator;
import it.zerono.mods.zerocore.lib.multiblock.validation.ValidationError;
import it.zerono.mods.zerocore.lib.multiblock.variant.IMultiblockVariant;
import it.zerono.mods.zerocore.lib.world.WorldHelper;
import java.util.Optional;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;

public class MultiblockPartBlock<Controller extends IMultiblockController<Controller>, PartType extends Enum<PartType>>
extends ModBlock {
    private final PartType _partType;
    private final IMultiblockVariant _multiblockVariant;

    public MultiblockPartBlock(MultiblockPartProperties<PartType> properties) {
        super(((MultiblockPartProperties)properties)._blockProperties);
        this._partType = ((MultiblockPartProperties)properties)._partType;
        this._multiblockVariant = ((MultiblockPartProperties)properties)._multiblockVariant;
    }

    public PartType getPartType() {
        return this._partType;
    }

    public Optional<IMultiblockVariant> getMultiblockVariant() {
        return Optional.ofNullable(this._multiblockVariant);
    }

    protected boolean openGui(ServerPlayerEntity player, AbstractModBlockEntity mbe) {
        return mbe.openGui(player);
    }

    public boolean hasTileEntity(BlockState state) {
        return true;
    }

    public TileEntity createTileEntity(BlockState state, IBlockReader world) {
        return ((IMultiblockPartType)this.getPartType()).createTileEntity(state, world);
    }

    public ActionResultType func_225533_a_(BlockState state, World world, BlockPos position, PlayerEntity player, Hand hand, BlockRayTraceResult hit) {
        if (CodeHelper.calledByLogicalServer(world)) {
            if (this.hasTileEntity(state) && Hand.MAIN_HAND == hand) {
                Optional part = WorldHelper.getMultiblockPartFrom(world, position);
                ItemStack heldItem = player.func_184586_b(hand);
                if (heldItem.func_190926_b()) {
                    ValidationError error;
                    Optional controller = part.flatMap(IMultiblockPart::getMultiblockController);
                    ValidationError validationError = error = !controller.isPresent() ? ValidationError.VALIDATION_ERROR_NOT_CONNECTED : (ValidationError)controller.filter(IMultiblockValidator::hasLastError).flatMap(IMultiblockValidator::getLastError).orElse(null);
                    if (null != error) {
                        CodeHelper.reportErrorToPlayer(player, error);
                        return ActionResultType.SUCCESS;
                    }
                }
                if (part.filter(p -> p instanceof INamedContainerProvider && p instanceof AbstractModBlockEntity).map(p -> (AbstractModBlockEntity)((Object)p)).filter(mbe -> mbe.canOpenGui(world, position, state)).map(mbe -> this.openGui((ServerPlayerEntity)player, (AbstractModBlockEntity)mbe)).orElse(false).booleanValue()) {
                    return ActionResultType.CONSUME;
                }
            }
        } else {
            return WorldHelper.getMultiblockPartFrom(world, position).filter(p -> p instanceof INamedContainerProvider && p instanceof AbstractModBlockEntity).map(p -> (AbstractModBlockEntity)((Object)p)).filter(mbe -> mbe.canOpenGui(world, position, state)).map(mbe -> ActionResultType.CONSUME).orElse(ActionResultType.PASS);
        }
        return super.func_225533_a_(state, world, position, player, hand, hit);
    }

    public static class MultiblockPartProperties<PartType extends Enum<PartType>> {
        private final AbstractBlock.Properties _blockProperties;
        private final PartType _partType;
        private IMultiblockVariant _multiblockVariant;

        public static <PartType extends Enum<PartType>> MultiblockPartProperties<PartType> create(PartType partType, AbstractBlock.Properties blockProperties) {
            return new MultiblockPartProperties<PartType>(partType, blockProperties);
        }

        public MultiblockPartProperties<PartType> variant(IMultiblockVariant variant) {
            this._multiblockVariant = variant;
            return this;
        }

        private MultiblockPartProperties(PartType partType, AbstractBlock.Properties blockProperties) {
            this._blockProperties = blockProperties;
            this._partType = partType;
            this._multiblockVariant = null;
        }
    }
}

