/*
 * Decompiled with CFR 0.152.
 */
package owmii.powah.block.energizing;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.stream.IntStream;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.IRecipeType;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.item.crafting.ShapedRecipe;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.items.wrapper.RecipeWrapper;
import net.minecraftforge.registries.ForgeRegistryEntry;
import owmii.powah.recipe.Recipes;

public class EnergizingRecipe
implements IRecipe<RecipeWrapper> {
    public static final ResourceLocation ID = new ResourceLocation("powah", "energizing");
    protected final ResourceLocation id;
    private final ItemStack output;
    private final long energy;
    private final NonNullList<Ingredient> ingredients;

    public EnergizingRecipe(ItemStack output, long energy, Ingredient ... ingredients) {
        this(ID, output, energy, (NonNullList<Ingredient>)NonNullList.func_193580_a((Object)Ingredient.field_193370_a, (Object[])ingredients));
    }

    public EnergizingRecipe(ResourceLocation id, ItemStack output, long energy, Ingredient ... ingredients) {
        this(id, output, energy, (NonNullList<Ingredient>)NonNullList.func_193580_a((Object)Ingredient.field_193370_a, (Object[])ingredients));
    }

    public EnergizingRecipe(ResourceLocation id, ItemStack output, long energy, NonNullList<Ingredient> ingredients) {
        this.id = id;
        this.output = output;
        this.energy = energy;
        this.ingredients = ingredients;
    }

    public boolean matches(RecipeWrapper inv, World world) {
        ArrayList<Ingredient> stacks = new ArrayList<Ingredient>((Collection<Ingredient>)this.func_192400_c());
        for (int i = 1; i < inv.func_70302_i_(); ++i) {
            ItemStack stack = inv.func_70301_a(i);
            if (stack.func_190926_b()) continue;
            boolean flag = false;
            Iterator itr = stacks.iterator();
            while (itr.hasNext()) {
                Ingredient ingredient = (Ingredient)itr.next();
                if (!ingredient.test(stack)) continue;
                flag = true;
                itr.remove();
                break;
            }
            if (flag) continue;
            return false;
        }
        return stacks.isEmpty();
    }

    public ItemStack getCraftingResult(RecipeWrapper inv) {
        return this.output.func_77946_l();
    }

    public boolean func_194133_a(int width, int height) {
        return true;
    }

    public ItemStack func_77571_b() {
        return this.output;
    }

    public ResourceLocation func_199560_c() {
        return this.id;
    }

    public IRecipeSerializer<?> func_199559_b() {
        return Recipes.ENERGIZING_SERIALIZER;
    }

    public IRecipeType<?> func_222127_g() {
        return Recipes.ENERGIZING;
    }

    public long getEnergy() {
        return this.energy;
    }

    public NonNullList<Ingredient> func_192400_c() {
        return this.ingredients;
    }

    public static class Serializer
    extends ForgeRegistryEntry<IRecipeSerializer<?>>
    implements IRecipeSerializer<EnergizingRecipe> {
        public EnergizingRecipe read(ResourceLocation recipeId, JsonObject json) {
            NonNullList<Ingredient> list = Serializer.readIngredients(JSONUtils.func_151214_t((JsonObject)json, (String)"ingredients"));
            long energy = Long.parseLong(JSONUtils.func_151219_a((JsonObject)json, (String)"energy", (String)"0"));
            if (list.isEmpty()) {
                throw new JsonParseException("No ingredients for energizing recipe");
            }
            if (list.size() > 6) {
                throw new JsonParseException("Too many ingredients for energizing recipe the max is 6");
            }
            if (energy <= 0L) {
                throw new JsonParseException("Energizing recipe require energy to work!!");
            }
            ItemStack result = ShapedRecipe.func_199798_a((JsonObject)JSONUtils.func_152754_s((JsonObject)json, (String)"result"));
            return new EnergizingRecipe(recipeId, result, energy, list);
        }

        private static NonNullList<Ingredient> readIngredients(JsonArray elements) {
            NonNullList list = NonNullList.func_191196_a();
            IntStream.range(0, elements.size()).mapToObj(i -> Ingredient.func_199802_a((JsonElement)elements.get(i))).filter(ingredient -> !ingredient.func_203189_d()).forEach(arg_0 -> list.add(arg_0));
            return list;
        }

        @Nullable
        public EnergizingRecipe read(ResourceLocation recipeId, PacketBuffer buffer) {
            NonNullList list = NonNullList.func_191197_a((int)buffer.readInt(), (Object)Ingredient.field_193370_a);
            IntStream.range(0, list.size()).forEach(i -> {
                Ingredient cfr_ignored_0 = (Ingredient)list.set(i, (Object)Ingredient.func_199566_b((PacketBuffer)buffer));
            });
            return new EnergizingRecipe(recipeId, buffer.func_150791_c(), buffer.readLong(), (NonNullList<Ingredient>)list);
        }

        public void write(PacketBuffer buffer, EnergizingRecipe recipe) {
            buffer.writeInt(recipe.ingredients.size());
            recipe.ingredients.forEach(ingredient -> ingredient.func_199564_a(buffer));
            buffer.func_150788_a(recipe.output);
            buffer.writeLong(recipe.energy);
        }
    }
}

