/*
 * Decompiled with CFR 0.152.
 */
package com.blakebr0.mysticalagriculture.data.recipe;

import com.blakebr0.mysticalagriculture.api.crop.ICrop;
import com.blakebr0.mysticalagriculture.crafting.ingredient.CropComponentIngredient;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import net.minecraft.data.IFinishedRecipe;
import net.minecraft.item.Item;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.Registry;

public class CraftingRecipeBuilder {
    private final Item result;
    private final int count;
    private final List<String> pattern = Lists.newArrayList();
    private final Map<Character, Ingredient> key = Maps.newLinkedHashMap();
    private final JsonArray conditions = new JsonArray();
    private String group = "";

    public CraftingRecipeBuilder(IItemProvider output, int count) {
        this.result = output.func_199767_j();
        this.count = count;
    }

    public void addKey(char key, Ingredient ingredient) {
        this.key.put(Character.valueOf(key), ingredient);
    }

    public void addPatternLine(String line) {
        this.pattern.add(line);
    }

    public void addCondition(JsonObject condition) {
        this.conditions.add((JsonElement)condition);
    }

    public static CraftingRecipeBuilder newSeedRecipe(ICrop crop) {
        CraftingRecipeBuilder builder = new CraftingRecipeBuilder((IItemProvider)crop.getSeeds(), 1);
        CropComponentIngredient essence = new CropComponentIngredient(crop, CropComponentIngredient.ComponentType.ESSENCE);
        CropComponentIngredient seed = new CropComponentIngredient(crop, CropComponentIngredient.ComponentType.SEED);
        CropComponentIngredient material = new CropComponentIngredient(crop, CropComponentIngredient.ComponentType.MATERIAL);
        builder.group = "mysticalagriculture:seeds";
        builder.addKey('E', essence);
        builder.addKey('S', seed);
        builder.addKey('M', material);
        builder.addPatternLine("MEM");
        builder.addPatternLine("ESE");
        builder.addPatternLine("MEM");
        JsonObject condition = new JsonObject();
        condition.addProperty("type", "mysticalagriculture:seed_crafting_recipes_enabled");
        builder.addCondition(condition);
        condition = new JsonObject();
        condition.addProperty("type", "mysticalagriculture:crop_enabled");
        condition.addProperty("crop", crop.getId().toString());
        builder.addCondition(condition);
        condition = new JsonObject();
        condition.addProperty("type", "mysticalagriculture:crop_has_material");
        condition.addProperty("crop", crop.getId().toString());
        builder.addCondition(condition);
        return builder;
    }

    public void build(Consumer<IFinishedRecipe> consumer, ResourceLocation id) {
        consumer.accept(new Result(id, this.result, this.count, this.group, this.pattern, this.key, this.conditions));
    }

    public static class Result
    implements IFinishedRecipe {
        private final ResourceLocation id;
        private final Item result;
        private final int count;
        private final String group;
        private final List<String> pattern;
        private final Map<Character, Ingredient> key;
        private final JsonArray conditions;

        public Result(ResourceLocation id, Item result, int count, String group, List<String> pattern, Map<Character, Ingredient> key, JsonArray conditions) {
            this.id = id;
            this.result = result;
            this.count = count;
            this.group = group;
            this.pattern = pattern;
            this.key = key;
            this.conditions = conditions;
        }

        public void func_218610_a(JsonObject json) {
            if (!this.group.isEmpty()) {
                json.addProperty("group", this.group);
            }
            json.add("conditions", (JsonElement)this.conditions);
            JsonArray pattern = new JsonArray();
            this.pattern.forEach(arg_0 -> ((JsonArray)pattern).add(arg_0));
            json.add("pattern", (JsonElement)pattern);
            JsonObject key = new JsonObject();
            this.key.forEach((c, i) -> key.add(c.toString(), i.func_200304_c()));
            json.add("key", (JsonElement)key);
            JsonObject result = new JsonObject();
            result.addProperty("item", Registry.field_212630_s.func_177774_c((Object)this.result).toString());
            if (this.count > 1) {
                result.addProperty("count", (Number)this.count);
            }
            json.add("result", (JsonElement)result);
        }

        public ResourceLocation func_200442_b() {
            return this.id;
        }

        public IRecipeSerializer<?> func_218609_c() {
            return IRecipeSerializer.field_222157_a;
        }

        public JsonObject func_200440_c() {
            return null;
        }

        public ResourceLocation func_200443_d() {
            return null;
        }
    }
}

