/*
 * Decompiled with CFR 0.152.
 */
package com.shynieke.statues.tiles;

import com.shynieke.statues.init.StatueRegistry;
import com.shynieke.statues.init.StatueTiles;
import com.shynieke.statues.recipes.LootInfo;
import com.shynieke.statues.recipes.StatueLootList;
import com.shynieke.statues.tiles.AbstractStatueTile;
import java.util.Random;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.monster.CreeperEntity;
import net.minecraft.entity.passive.RabbitEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.projectile.FireworkRocketEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.potion.Effect;
import net.minecraft.potion.EffectInstance;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;

public class StatueTile
extends AbstractStatueTile {
    public static final int[] DYE_COLORS = new int[]{0x1E1B1B, 11743532, 3887386, 5320730, 2437522, 8073150, 2651799, 0xABABAB, 0x434343, 14188952, 4312372, 14602026, 6719955, 12801229, 15435844, 0xF0F0F0};

    public StatueTile() {
        this(StatueTiles.STATUE);
    }

    public StatueTile(TileEntityType<?> tileType) {
        super(tileType);
    }

    public void playSound(SoundEvent sound, BlockPos pos) {
        this.playSound(sound, pos, 1.0f);
    }

    public void playSound(SoundEvent sound, BlockPos pos, float pitch) {
        if (this.makesSounds()) {
            this.field_145850_b.func_184133_a(null, pos, sound, SoundCategory.NEUTRAL, 1.0f, pitch);
        }
    }

    public void giveItem(LootInfo loot, PlayerEntity playerIn) {
        if (this.field_145850_b != null && this.isStatueAble()) {
            int random = this.field_145850_b.field_73012_v.nextInt(100);
            if (!this.isDecorative() && loot.hasLoot()) {
                ItemStack stack1 = loot.getStack1();
                ItemStack stack2 = loot.getStack2();
                ItemStack stack3 = loot.getStack3();
                if (stack1 != null && stack1 != ItemStack.field_190927_a) {
                    playerIn.func_71019_a(stack1, true);
                }
                if (stack2 != null && stack2 != ItemStack.field_190927_a && random <= 50) {
                    playerIn.func_71019_a(stack2, true);
                }
                if (stack3 != null && stack3 != ItemStack.field_190927_a && random <= 10) {
                    playerIn.func_71019_a(stack3, true);
                }
                this.setStatueAble(false);
            }
        }
    }

    public void summonMob(LivingEntity entityIn) {
        if (this.field_145850_b != null && this.canSpawnMobs()) {
            int random = this.field_145850_b.field_73012_v.nextInt(100);
            if (random < 1) {
                if (entityIn instanceof RabbitEntity) {
                    RabbitEntity rabbit = (RabbitEntity)entityIn;
                    rabbit.func_175529_r(99);
                    rabbit.func_70634_a((double)this.field_174879_c.func_177958_n(), (double)(this.field_174879_c.func_177956_o() + 1), (double)this.field_174879_c.func_177952_p());
                    this.field_145850_b.func_217376_c((Entity)rabbit);
                } else if (entityIn instanceof CreeperEntity) {
                    CreeperEntity creeper = (CreeperEntity)entityIn;
                    creeper.func_70012_b((double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o(), (double)this.field_174879_c.func_177952_p() + 0.5, 0.0f, 0.0f);
                    CompoundNBT tag = new CompoundNBT();
                    creeper.func_213281_b(tag);
                    tag.func_74777_a("ExplosionRadius", (short)0);
                    creeper.func_70037_a(tag);
                    this.field_145850_b.func_217376_c((Entity)creeper);
                    creeper.func_70656_aK();
                } else {
                    entityIn.func_70634_a((double)this.field_174879_c.func_177958_n(), (double)(this.field_174879_c.func_177956_o() + 1), (double)this.field_174879_c.func_177952_p());
                    this.field_145850_b.func_217376_c((Entity)entityIn);
                }
            }
            this.setStatueAble(false);
        }
    }

    public void floodBehavior(PlayerEntity playerIn, BlockPos pos, Hand hand, float hitX, float hitY, float hitZ) {
        if (this.field_145850_b != null && !this.field_145850_b.field_72995_K) {
            ItemStack stack = playerIn.func_184586_b(hand);
            int random = this.field_145850_b.field_73012_v.nextInt(100);
            if (stack.func_77973_b() == Items.field_151133_ar && !playerIn.field_71075_bZ.field_75098_d) {
                this.field_145850_b.func_184133_a(null, pos, SoundEvents.field_187630_M, SoundCategory.NEUTRAL, 1.0f, 1.0f);
                stack.func_190918_g(1);
                ItemStack floodbucket = StatueLootList.getFloodBucket();
                if (stack.func_190926_b()) {
                    playerIn.func_184611_a(hand, floodbucket);
                } else if (!playerIn.field_71071_by.func_70441_a(floodbucket)) {
                    playerIn.func_71019_a(floodbucket, false);
                }
            }
            if (random < 50) {
                FireworkRocketEntity firework = new FireworkRocketEntity(this.field_145850_b, (double)((float)pos.func_177958_n() + hitX), (double)((float)pos.func_177956_o() + hitY), (double)((float)pos.func_177952_p() + hitZ), this.getFirework(this.field_145850_b.field_73012_v));
                this.field_145850_b.func_217376_c((Entity)firework);
            }
        }
    }

    public void mooshroomBehavior(PlayerEntity playerIn, BlockPos pos, Hand hand) {
        ItemStack stack;
        if (this.field_145850_b != null && !this.field_145850_b.field_72995_K && (stack = playerIn.func_184586_b(hand)).func_77973_b() == Items.field_151054_z && !playerIn.field_71075_bZ.field_75098_d) {
            this.field_145850_b.func_184133_a(null, pos, SoundEvents.field_187564_an, SoundCategory.NEUTRAL, 1.0f, 1.0f);
            stack.func_190918_g(1);
            ItemStack soupStack = new ItemStack((IItemProvider)StatueRegistry.SOUP.get());
            if (stack.func_190926_b()) {
                playerIn.func_184611_a(hand, soupStack);
            } else if (!playerIn.field_71071_by.func_70441_a(soupStack)) {
                playerIn.func_71019_a(soupStack, false);
            }
        }
    }

    public void cowBehavior(PlayerEntity playerIn, BlockPos pos, Hand hand) {
        ItemStack stack;
        if (this.field_145850_b != null && !this.field_145850_b.field_72995_K && (stack = playerIn.func_184586_b(hand)).func_77973_b() == Items.field_151133_ar && !playerIn.field_71075_bZ.field_75098_d) {
            this.field_145850_b.func_184133_a(null, pos, SoundEvents.field_187564_an, SoundCategory.NEUTRAL, 1.0f, 1.0f);
            stack.func_190918_g(1);
            if (stack.func_190926_b()) {
                playerIn.func_184611_a(hand, new ItemStack((IItemProvider)Items.field_151117_aB));
            } else if (!playerIn.field_71071_by.func_70441_a(new ItemStack((IItemProvider)Items.field_151117_aB))) {
                playerIn.func_71019_a(new ItemStack((IItemProvider)Items.field_151117_aB), false);
            }
        }
    }

    public void giveEffect(BlockPos pos, PlayerEntity player, Effect effect) {
        if (this.isStatueAble() && this.field_145850_b != null) {
            int random = this.field_145850_b.field_73012_v.nextInt(100);
            if (this.hasExternalUse() && random < 10 && !this.field_145850_b.field_72995_K && player.func_70660_b(effect) == null) {
                player.func_195064_c(new EffectInstance(effect, 400, 1, true, true));
            }
        }
    }

    public ItemStack getFirework(Random rand) {
        ItemStack firework = new ItemStack((IItemProvider)Items.field_196152_dE);
        firework.func_196082_o();
        CompoundNBT nbt = new CompoundNBT();
        nbt.func_74757_a("Flicker", true);
        nbt.func_74757_a("Trail", true);
        int[] colors = new int[rand.nextInt(8) + 1];
        for (int i = 0; i < colors.length; ++i) {
            colors[i] = DYE_COLORS[rand.nextInt(16)];
        }
        nbt.func_74783_a("Colors", colors);
        byte type = (byte)(rand.nextInt(3) + 1);
        type = type == 3 ? (byte)4 : (byte)type;
        nbt.func_74774_a("Type", type);
        ListNBT explosions = new ListNBT();
        explosions.add((Object)nbt);
        CompoundNBT fireworkTag = new CompoundNBT();
        fireworkTag.func_218657_a("Explosions", (INBT)explosions);
        fireworkTag.func_74774_a("Flight", (byte)1);
        CompoundNBT stackTag = firework.func_196082_o();
        stackTag.func_218657_a("Fireworks", (INBT)fireworkTag);
        firework.func_77982_d(stackTag);
        return firework;
    }
}

