/*
 * Decompiled with CFR 0.152.
 */
package com.shynieke.statues.entity;

import com.mojang.authlib.GameProfile;
import com.mojang.authlib.minecraft.MinecraftProfileTexture;
import com.shynieke.statues.Statues;
import com.shynieke.statues.init.StatueRegistry;
import com.shynieke.statues.init.StatueSerializers;
import com.shynieke.statues.packets.PlayerStatueScreenMessage;
import com.shynieke.statues.tiles.PlayerTile;
import java.util.Locale;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntitySize;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.Pose;
import net.minecraft.entity.effect.LightningBoltEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.entity.projectile.AbstractArrowEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.network.IPacket;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.particles.BlockParticleData;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.management.PreYggdrasilConverter;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Hand;
import net.minecraft.util.HandSide;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.NonNullList;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Rotations;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.network.NetworkHooks;
import net.minecraftforge.fml.network.PacketDistributor;

public class PlayerStatueEntity
extends LivingEntity {
    private static final Rotations DEFAULT_HEAD_ROTATION = new Rotations(0.0f, 0.0f, 0.0f);
    private static final Rotations DEFAULT_BODY_ROTATION = new Rotations(0.0f, 0.0f, 0.0f);
    private static final Rotations DEFAULT_LEFTARM_ROTATION = new Rotations(-10.0f, 0.0f, -10.0f);
    private static final Rotations DEFAULT_RIGHTARM_ROTATION = new Rotations(-15.0f, 0.0f, 10.0f);
    private static final Rotations DEFAULT_LEFTLEG_ROTATION = new Rotations(-1.0f, 0.0f, -1.0f);
    private static final Rotations DEFAULT_RIGHTLEG_ROTATION = new Rotations(1.0f, 0.0f, 1.0f);
    private static final DataParameter<Optional<GameProfile>> GAMEPROFILE = EntityDataManager.func_187226_a(PlayerStatueEntity.class, StatueSerializers.OPTIONAL_GAME_PROFILE);
    public static final DataParameter<Byte> STATUS = EntityDataManager.func_187226_a(PlayerStatueEntity.class, (IDataSerializer)DataSerializers.field_187191_a);
    public static final DataParameter<Float> Y_OFFSET = EntityDataManager.func_187226_a(PlayerStatueEntity.class, (IDataSerializer)DataSerializers.field_187193_c);
    public static final DataParameter<Rotations> HEAD_ROTATION = EntityDataManager.func_187226_a(PlayerStatueEntity.class, (IDataSerializer)DataSerializers.field_187199_i);
    public static final DataParameter<Rotations> BODY_ROTATION = EntityDataManager.func_187226_a(PlayerStatueEntity.class, (IDataSerializer)DataSerializers.field_187199_i);
    public static final DataParameter<Rotations> LEFT_ARM_ROTATION = EntityDataManager.func_187226_a(PlayerStatueEntity.class, (IDataSerializer)DataSerializers.field_187199_i);
    public static final DataParameter<Rotations> RIGHT_ARM_ROTATION = EntityDataManager.func_187226_a(PlayerStatueEntity.class, (IDataSerializer)DataSerializers.field_187199_i);
    public static final DataParameter<Rotations> LEFT_LEG_ROTATION = EntityDataManager.func_187226_a(PlayerStatueEntity.class, (IDataSerializer)DataSerializers.field_187199_i);
    public static final DataParameter<Rotations> RIGHT_LEG_ROTATION = EntityDataManager.func_187226_a(PlayerStatueEntity.class, (IDataSerializer)DataSerializers.field_187199_i);
    public static final DataParameter<Optional<UUID>> LOCKED_BY_UUID = EntityDataManager.func_187226_a(PlayerStatueEntity.class, (IDataSerializer)DataSerializers.field_187203_m);
    private final NonNullList<ItemStack> handItems = NonNullList.func_191197_a((int)2, (Object)ItemStack.field_190927_a);
    private final NonNullList<ItemStack> armorItems = NonNullList.func_191197_a((int)4, (Object)ItemStack.field_190927_a);
    public long punchCooldown;
    private int disabledSlots;
    private boolean isSlim = false;
    private Rotations headRotation = DEFAULT_HEAD_ROTATION;
    private Rotations bodyRotation = DEFAULT_BODY_ROTATION;
    private Rotations leftArmRotation = DEFAULT_LEFTARM_ROTATION;
    private Rotations rightArmRotation = DEFAULT_RIGHTARM_ROTATION;
    private Rotations leftLegRotation = DEFAULT_LEFTLEG_ROTATION;
    private Rotations rightLegRotation = DEFAULT_RIGHTLEG_ROTATION;

    public PlayerStatueEntity(EntityType<? extends PlayerStatueEntity> entityType, World world) {
        super(entityType, world);
        this.field_70138_W = 0.0f;
    }

    public PlayerStatueEntity(World worldIn, double posX, double posY, double posZ) {
        this((EntityType<? extends PlayerStatueEntity>)((EntityType)StatueRegistry.PLAYER_STATUE_ENTITY.get()), worldIn);
        this.func_70107_b(posX, posY, posZ);
    }

    public IPacket<?> func_213297_N() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    public void func_213323_x_() {
        double d0 = this.func_226277_ct_();
        double d1 = this.func_226278_cu_();
        double d2 = this.func_226281_cx_();
        super.func_213323_x_();
        this.func_70107_b(d0, d1, d2);
    }

    private boolean func_213814_A() {
        return !this.func_189652_ae();
    }

    public boolean func_189652_ae() {
        return this.field_70173_aa > 200 && super.func_189652_ae();
    }

    public boolean func_70613_aW() {
        return super.func_70613_aW() && this.func_213814_A();
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(GAMEPROFILE, Optional.empty());
        this.field_70180_af.func_187214_a(STATUS, (Object)0);
        this.field_70180_af.func_187214_a(Y_OFFSET, (Object)Float.valueOf(0.0f));
        this.field_70180_af.func_187214_a(HEAD_ROTATION, (Object)DEFAULT_HEAD_ROTATION);
        this.field_70180_af.func_187214_a(BODY_ROTATION, (Object)DEFAULT_BODY_ROTATION);
        this.field_70180_af.func_187214_a(LEFT_ARM_ROTATION, (Object)DEFAULT_LEFTARM_ROTATION);
        this.field_70180_af.func_187214_a(RIGHT_ARM_ROTATION, (Object)DEFAULT_RIGHTARM_ROTATION);
        this.field_70180_af.func_187214_a(LEFT_LEG_ROTATION, (Object)DEFAULT_LEFTLEG_ROTATION);
        this.field_70180_af.func_187214_a(RIGHT_LEG_ROTATION, (Object)DEFAULT_RIGHTLEG_ROTATION);
        this.field_70180_af.func_187214_a(LOCKED_BY_UUID, Optional.empty());
    }

    public Optional<GameProfile> getGameProfile() {
        return (Optional)this.field_70180_af.func_187225_a(GAMEPROFILE);
    }

    public void setGameProfile(GameProfile playerProfile) {
        GameProfile profile = PlayerTile.updateGameProfile(playerProfile);
        this.field_70180_af.func_187227_b(GAMEPROFILE, Optional.of(profile));
    }

    public boolean isLocked() {
        return ((Optional)this.field_70180_af.func_187225_a(LOCKED_BY_UUID)).isPresent();
    }

    @Nullable
    public UUID getLockedBy() {
        return ((Optional)this.field_70180_af.func_187225_a(LOCKED_BY_UUID)).orElse(null);
    }

    public void setLockedBy(@Nullable UUID uuid) {
        this.field_70180_af.func_187227_b(LOCKED_BY_UUID, Optional.ofNullable(uuid));
    }

    public void setUnlocked() {
        this.field_70180_af.func_187227_b(LOCKED_BY_UUID, Optional.empty());
    }

    public void setSlim(boolean slim) {
        this.isSlim = slim;
    }

    public boolean isSlim() {
        return this.isSlim;
    }

    public void setYOffset(float yOffset) {
        this.field_70180_af.func_187227_b(Y_OFFSET, (Object)Float.valueOf(MathHelper.func_76131_a((float)yOffset, (float)-1.0f, (float)1.0f)));
    }

    public float getYOffsetData() {
        return ((Float)this.field_70180_af.func_187225_a(Y_OFFSET)).floatValue();
    }

    @Nonnull
    public Iterable<ItemStack> func_184214_aD() {
        return this.handItems;
    }

    @Nonnull
    public Iterable<ItemStack> func_184193_aE() {
        return this.armorItems;
    }

    @Nonnull
    public ItemStack func_184582_a(EquipmentSlotType slotIn) {
        switch (slotIn.func_188453_a()) {
            case HAND: {
                return (ItemStack)this.handItems.get(slotIn.func_188454_b());
            }
            case ARMOR: {
                return (ItemStack)this.armorItems.get(slotIn.func_188454_b());
            }
        }
        return ItemStack.field_190927_a;
    }

    public void func_184201_a(EquipmentSlotType slotIn, ItemStack stack) {
        switch (slotIn.func_188453_a()) {
            case HAND: {
                this.func_184606_a_(stack);
                this.handItems.set(slotIn.func_188454_b(), (Object)stack);
                break;
            }
            case ARMOR: {
                this.func_184606_a_(stack);
                this.armorItems.set(slotIn.func_188454_b(), (Object)stack);
            }
        }
    }

    public boolean func_174820_d(int inventorySlot, ItemStack itemStackIn) {
        EquipmentSlotType equipmentslottype;
        if (inventorySlot == 98) {
            equipmentslottype = EquipmentSlotType.MAINHAND;
        } else if (inventorySlot == 99) {
            equipmentslottype = EquipmentSlotType.OFFHAND;
        } else if (inventorySlot == 100 + EquipmentSlotType.HEAD.func_188454_b()) {
            equipmentslottype = EquipmentSlotType.HEAD;
        } else if (inventorySlot == 100 + EquipmentSlotType.CHEST.func_188454_b()) {
            equipmentslottype = EquipmentSlotType.CHEST;
        } else if (inventorySlot == 100 + EquipmentSlotType.LEGS.func_188454_b()) {
            equipmentslottype = EquipmentSlotType.LEGS;
        } else {
            if (inventorySlot != 100 + EquipmentSlotType.FEET.func_188454_b()) {
                return false;
            }
            equipmentslottype = EquipmentSlotType.FEET;
        }
        if (!itemStackIn.func_190926_b() && !MobEntity.func_184648_b((EquipmentSlotType)equipmentslottype, (ItemStack)itemStackIn) && equipmentslottype != EquipmentSlotType.HEAD) {
            return false;
        }
        this.func_184201_a(equipmentslottype, itemStackIn);
        return true;
    }

    public boolean func_213365_e(ItemStack itemstackIn) {
        EquipmentSlotType equipmentslottype = MobEntity.func_184640_d((ItemStack)itemstackIn);
        return this.func_184582_a(equipmentslottype).func_190926_b() && !this.isDisabled(equipmentslottype);
    }

    public void func_213281_b(CompoundNBT compound) {
        super.func_213281_b(compound);
        compound.func_74757_a("gameProfileExists", ((Optional)this.field_70180_af.func_187225_a(GAMEPROFILE)).isPresent());
        if (this.getGameProfile().isPresent()) {
            compound.func_218657_a("gameProfile", (INBT)NBTUtil.func_180708_a((CompoundNBT)new CompoundNBT(), (GameProfile)((GameProfile)((Optional)this.field_70180_af.func_187225_a(GAMEPROFILE)).get())));
        }
        compound.func_74776_a("yOffset", this.getYOffsetData());
        ListNBT listnbt = new ListNBT();
        for (ItemStack itemstack : this.armorItems) {
            CompoundNBT compoundnbt = new CompoundNBT();
            if (!itemstack.func_190926_b()) {
                itemstack.func_77955_b(compoundnbt);
            }
            listnbt.add((Object)compoundnbt);
        }
        compound.func_218657_a("ArmorItems", (INBT)listnbt);
        ListNBT listnbt1 = new ListNBT();
        for (ItemStack itemstack1 : this.handItems) {
            CompoundNBT compoundnbt1 = new CompoundNBT();
            if (!itemstack1.func_190926_b()) {
                itemstack1.func_77955_b(compoundnbt1);
            }
            listnbt1.add((Object)compoundnbt1);
        }
        compound.func_74757_a("Locked", this.isLocked());
        if (this.isLocked() && this.getLockedBy() != null) {
            compound.func_186854_a("LockedBy", this.getLockedBy());
        }
        compound.func_218657_a("HandItems", (INBT)listnbt1);
        compound.func_74757_a("Small", this.isSmall());
        compound.func_74768_a("DisabledSlots", this.disabledSlots);
        compound.func_218657_a("Pose", (INBT)this.writePose());
    }

    public CompoundNBT func_189511_e(CompoundNBT compound) {
        return super.func_189511_e(compound);
    }

    public void func_70020_e(CompoundNBT compound) {
        super.func_70020_e(compound);
        this.field_70180_af.func_187227_b(GAMEPROFILE, !compound.func_74767_n("gameProfileExists") ? Optional.empty() : Optional.ofNullable(NBTUtil.func_152459_a((CompoundNBT)compound.func_74775_l("gameProfile"))));
    }

    public void func_70037_a(CompoundNBT compound) {
        super.func_70037_a(compound);
        this.setYOffset(compound.func_74760_g("yOffset"));
        if (compound.func_150297_b("ArmorItems", 9)) {
            ListNBT listnbt = compound.func_150295_c("ArmorItems", 10);
            for (int i = 0; i < this.armorItems.size(); ++i) {
                this.armorItems.set(i, (Object)ItemStack.func_199557_a((CompoundNBT)listnbt.func_150305_b(i)));
            }
        }
        if (compound.func_74767_n("Locked")) {
            UUID uuid;
            if (compound.func_186855_b("LockedBy")) {
                uuid = compound.func_186857_a("LockedBy");
            } else {
                String s = compound.func_74779_i("LockedBy");
                uuid = PreYggdrasilConverter.func_187473_a((MinecraftServer)this.func_184102_h(), (String)s);
            }
            if (uuid != null) {
                this.setLockedBy(uuid);
            }
        }
        if (compound.func_150297_b("HandItems", 9)) {
            ListNBT listnbt1 = compound.func_150295_c("HandItems", 10);
            for (int j = 0; j < this.handItems.size(); ++j) {
                this.handItems.set(j, (Object)ItemStack.func_199557_a((CompoundNBT)listnbt1.func_150305_b(j)));
            }
        }
        this.setSmall(compound.func_74767_n("Small"));
        this.disabledSlots = compound.func_74762_e("DisabledSlots");
        this.field_70145_X = !this.func_213814_A();
        CompoundNBT compoundnbt = compound.func_74775_l("Pose");
        this.readPose(compoundnbt);
    }

    private void readPose(CompoundNBT tagCompound) {
        ListNBT listnbt = tagCompound.func_150295_c("Head", 5);
        this.setHeadRotation(listnbt.isEmpty() ? DEFAULT_HEAD_ROTATION : new Rotations(listnbt));
        ListNBT listnbt1 = tagCompound.func_150295_c("Body", 5);
        this.setBodyRotation(listnbt1.isEmpty() ? DEFAULT_BODY_ROTATION : new Rotations(listnbt1));
        ListNBT listnbt2 = tagCompound.func_150295_c("LeftArm", 5);
        this.setLeftArmRotation(listnbt2.isEmpty() ? DEFAULT_LEFTARM_ROTATION : new Rotations(listnbt2));
        ListNBT listnbt3 = tagCompound.func_150295_c("RightArm", 5);
        this.setRightArmRotation(listnbt3.isEmpty() ? DEFAULT_RIGHTARM_ROTATION : new Rotations(listnbt3));
        ListNBT listnbt4 = tagCompound.func_150295_c("LeftLeg", 5);
        this.setLeftLegRotation(listnbt4.isEmpty() ? DEFAULT_LEFTLEG_ROTATION : new Rotations(listnbt4));
        ListNBT listnbt5 = tagCompound.func_150295_c("RightLeg", 5);
        this.setRightLegRotation(listnbt5.isEmpty() ? DEFAULT_RIGHTLEG_ROTATION : new Rotations(listnbt5));
    }

    private CompoundNBT writePose() {
        CompoundNBT compoundnbt = new CompoundNBT();
        if (!DEFAULT_HEAD_ROTATION.equals((Object)this.headRotation)) {
            compoundnbt.func_218657_a("Head", (INBT)this.headRotation.func_179414_a());
        }
        if (!DEFAULT_BODY_ROTATION.equals((Object)this.bodyRotation)) {
            compoundnbt.func_218657_a("Body", (INBT)this.bodyRotation.func_179414_a());
        }
        if (!DEFAULT_LEFTARM_ROTATION.equals((Object)this.leftArmRotation)) {
            compoundnbt.func_218657_a("LeftArm", (INBT)this.leftArmRotation.func_179414_a());
        }
        if (!DEFAULT_RIGHTARM_ROTATION.equals((Object)this.rightArmRotation)) {
            compoundnbt.func_218657_a("RightArm", (INBT)this.rightArmRotation.func_179414_a());
        }
        if (!DEFAULT_LEFTLEG_ROTATION.equals((Object)this.leftLegRotation)) {
            compoundnbt.func_218657_a("LeftLeg", (INBT)this.leftLegRotation.func_179414_a());
        }
        if (!DEFAULT_RIGHTLEG_ROTATION.equals((Object)this.rightLegRotation)) {
            compoundnbt.func_218657_a("RightLeg", (INBT)this.rightLegRotation.func_179414_a());
        }
        return compoundnbt;
    }

    public boolean func_70104_M() {
        return false;
    }

    protected void func_82167_n(Entity entityIn) {
    }

    public void func_200203_b(@Nullable ITextComponent name) {
        if (name != null && !this.isLocked()) {
            super.func_200203_b(name);
            this.setGameProfile(new GameProfile((UUID)null, name.func_150261_e().toLowerCase(Locale.ROOT)));
        }
    }

    public ActionResultType func_184199_a(PlayerEntity player, Vector3d vec, Hand hand) {
        ItemStack itemstack = player.func_184586_b(hand);
        if (player.func_225608_bj_()) {
            if (!this.field_70170_p.field_72995_K && player != null) {
                if (this.isLocked() && this.getLockedBy() != null) {
                    if (player.func_110124_au().equals(this.getLockedBy())) {
                        Statues.CHANNEL.send(PacketDistributor.PLAYER.with(() -> (ServerPlayerEntity)player), (Object)new PlayerStatueScreenMessage(this.func_145782_y()));
                    }
                } else {
                    Statues.CHANNEL.send(PacketDistributor.PLAYER.with(() -> (ServerPlayerEntity)player), (Object)new PlayerStatueScreenMessage(this.func_145782_y()));
                }
            }
        } else if (itemstack.func_77973_b() != Items.field_151057_cb) {
            if (player.func_175149_v()) {
                return ActionResultType.SUCCESS;
            }
            if (player.field_70170_p.field_72995_K) {
                return ActionResultType.CONSUME;
            }
            if (!this.isLocked()) {
                EquipmentSlotType equipmentslottype = MobEntity.func_184640_d((ItemStack)itemstack);
                if (itemstack.func_190926_b()) {
                    EquipmentSlotType equipmentslottype2;
                    EquipmentSlotType equipmentslottype1 = this.getClickedSlot(vec);
                    EquipmentSlotType equipmentSlotType = equipmentslottype2 = this.isDisabled(equipmentslottype1) ? equipmentslottype : equipmentslottype1;
                    if (this.func_190630_a(equipmentslottype2) && this.equipOrSwap(player, equipmentslottype2, itemstack, hand)) {
                        return ActionResultType.SUCCESS;
                    }
                } else {
                    if (this.isDisabled(equipmentslottype)) {
                        return ActionResultType.FAIL;
                    }
                    if (this.equipOrSwap(player, equipmentslottype, itemstack, hand)) {
                        return ActionResultType.SUCCESS;
                    }
                }
            }
            return ActionResultType.PASS;
        }
        return ActionResultType.PASS;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private EquipmentSlotType getClickedSlot(Vector3d p_190772_1_) {
        EquipmentSlotType equipmentslottype = EquipmentSlotType.MAINHAND;
        boolean flag = this.isSmall();
        double d0 = flag ? p_190772_1_.field_72448_b * 2.0 : p_190772_1_.field_72448_b;
        EquipmentSlotType equipmentslottype1 = EquipmentSlotType.FEET;
        if (d0 >= 0.1) {
            double d = flag ? 0.8 : 0.45;
            if (d0 < 0.1 + d && this.func_190630_a(equipmentslottype1)) {
                return EquipmentSlotType.FEET;
            }
        }
        double d = flag ? 0.3 : 0.0;
        if (d0 >= 0.9 + d) {
            double d2 = flag ? 1.0 : 0.7;
            if (d0 < 0.9 + d2 && this.func_190630_a(EquipmentSlotType.CHEST)) {
                return EquipmentSlotType.CHEST;
            }
        }
        if (d0 >= 0.4) {
            double d3 = flag ? 1.0 : 0.8;
            if (d0 < 0.4 + d3 && this.func_190630_a(EquipmentSlotType.LEGS)) {
                return EquipmentSlotType.LEGS;
            }
        }
        if (d0 >= 1.6 && this.func_190630_a(EquipmentSlotType.HEAD)) {
            return EquipmentSlotType.HEAD;
        }
        if (this.func_190630_a(EquipmentSlotType.MAINHAND)) return equipmentslottype;
        if (!this.func_190630_a(EquipmentSlotType.OFFHAND)) return equipmentslottype;
        return EquipmentSlotType.OFFHAND;
    }

    private boolean isDisabled(EquipmentSlotType slotIn) {
        return (this.disabledSlots & 1 << slotIn.func_188452_c()) != 0;
    }

    private boolean equipOrSwap(PlayerEntity player, EquipmentSlotType slot, ItemStack stack, Hand hand) {
        ItemStack itemstack = this.func_184582_a(slot);
        if (!itemstack.func_190926_b() && (this.disabledSlots & 1 << slot.func_188452_c() + 8) != 0) {
            return false;
        }
        if (itemstack.func_190926_b() && (this.disabledSlots & 1 << slot.func_188452_c() + 16) != 0) {
            return false;
        }
        if (player.field_71075_bZ.field_75098_d && itemstack.func_190926_b() && !stack.func_190926_b()) {
            ItemStack itemstack2 = stack.func_77946_l();
            itemstack2.func_190920_e(1);
            this.func_184201_a(slot, itemstack2);
            return true;
        }
        if (!stack.func_190926_b() && stack.func_190916_E() > 1) {
            if (!itemstack.func_190926_b()) {
                return false;
            }
            ItemStack itemstack1 = stack.func_77946_l();
            itemstack1.func_190920_e(1);
            this.func_184201_a(slot, itemstack1);
            stack.func_190918_g(1);
            return true;
        }
        this.func_184201_a(slot, stack);
        player.func_184611_a(hand, itemstack);
        return true;
    }

    public boolean func_190530_aW() {
        return this.isLocked() || super.func_190530_aW();
    }

    public boolean func_180431_b(DamageSource source) {
        if (this.isLocked()) {
            return true;
        }
        return super.func_180431_b(source);
    }

    public boolean func_70097_a(DamageSource source, float amount) {
        if (!this.field_70170_p.field_72995_K && !this.field_70128_L) {
            if (DamageSource.field_76380_i.equals(source)) {
                this.func_70106_y();
                return false;
            }
            if (!this.func_180431_b(source)) {
                if (source.func_94541_c()) {
                    this.func_213816_g(source);
                    this.func_70106_y();
                    return false;
                }
                if (DamageSource.field_76372_a.equals(source)) {
                    if (this.func_70027_ad()) {
                        this.damageArmorStand(source, 0.15f);
                    } else {
                        this.func_70015_d(5);
                    }
                    return false;
                }
                if (DamageSource.field_76370_b.equals(source) && this.func_110143_aJ() > 0.5f) {
                    this.damageArmorStand(source, 4.0f);
                    return false;
                }
                boolean flag = source.func_76364_f() instanceof AbstractArrowEntity;
                boolean flag1 = flag && ((AbstractArrowEntity)source.func_76364_f()).func_213874_s() > 0;
                boolean flag2 = "player".equals(source.func_76355_l());
                if (!flag2 && !flag) {
                    return false;
                }
                if (source.func_76346_g() instanceof PlayerEntity && !((PlayerEntity)source.func_76346_g()).field_71075_bZ.field_75099_e) {
                    return false;
                }
                if (source.func_180136_u()) {
                    this.playBrokenSound();
                    this.playParticles();
                    this.func_70106_y();
                    return flag1;
                }
                long i = this.field_70170_p.func_82737_E();
                if (i - this.punchCooldown > 5L && !flag) {
                    this.field_70170_p.func_72960_a((Entity)this, (byte)32);
                    this.punchCooldown = i;
                } else {
                    this.breakPlayerStatue(source);
                    this.playParticles();
                    this.func_70106_y();
                }
                return true;
            }
            return false;
        }
        return false;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_70103_a(byte id) {
        if (id == 32) {
            if (this.field_70170_p.field_72995_K) {
                this.field_70170_p.func_184134_a(this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), SoundEvents.field_187707_l, this.func_184176_by(), 0.3f, 1.0f, false);
                this.punchCooldown = this.field_70170_p.func_82737_E();
            }
        } else {
            super.func_70103_a(id);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean func_70112_a(double distance) {
        double d0 = this.func_174813_aQ().func_72320_b() * 4.0;
        if (Double.isNaN(d0) || d0 == 0.0) {
            d0 = 4.0;
        }
        return distance < (d0 *= 64.0) * d0;
    }

    private void playParticles() {
        if (this.field_70170_p instanceof ServerWorld) {
            ((ServerWorld)this.field_70170_p).func_195598_a((IParticleData)new BlockParticleData(ParticleTypes.field_197611_d, ((Block)StatueRegistry.PLAYER_STATUE.get()).func_176223_P()), this.func_226277_ct_(), this.func_226283_e_(0.6666666666666666), this.func_226281_cx_(), 10, (double)(this.func_213311_cf() / 4.0f), (double)(this.func_213302_cg() / 4.0f), (double)(this.func_213311_cf() / 4.0f), 0.05);
        }
    }

    private void damageArmorStand(DamageSource source, float p_213817_2_) {
        float f = this.func_110143_aJ();
        if ((f -= p_213817_2_) <= 0.5f) {
            this.func_213816_g(source);
            this.func_70106_y();
        } else {
            this.func_70606_j(f);
        }
    }

    private void breakPlayerStatue(DamageSource source) {
        GameProfile profile;
        ItemStack stack = new ItemStack((IItemProvider)StatueRegistry.PLAYER_STATUE.get());
        if (this.getGameProfile().isPresent() && (profile = this.getGameProfile().get()) != null) {
            CompoundNBT stackTag = stack.func_77978_p() != null ? stack.func_77978_p() : new CompoundNBT();
            CompoundNBT nbttagcompound = new CompoundNBT();
            NBTUtil.func_180708_a((CompoundNBT)nbttagcompound, (GameProfile)profile);
            stackTag.func_218657_a("PlayerProfile", (INBT)nbttagcompound);
            stack.func_77982_d(stackTag);
            stack.func_200302_a((ITextComponent)new StringTextComponent(profile.getName()));
        }
        Block.func_180635_a((World)this.field_70170_p, (BlockPos)this.func_233580_cy_(), (ItemStack)stack);
        this.func_213816_g(source);
    }

    public ItemStack getPickedResult(RayTraceResult target) {
        GameProfile profile;
        ItemStack stack = new ItemStack((IItemProvider)StatueRegistry.PLAYER_STATUE.get());
        if (this.getGameProfile().isPresent() && (profile = this.getGameProfile().get()) != null) {
            CompoundNBT stackTag = stack.func_77978_p() != null ? stack.func_77978_p() : new CompoundNBT();
            CompoundNBT nbttagcompound = new CompoundNBT();
            NBTUtil.func_180708_a((CompoundNBT)nbttagcompound, (GameProfile)profile);
            stackTag.func_218657_a("PlayerProfile", (INBT)nbttagcompound);
            stack.func_77982_d(stackTag);
            stack.func_200302_a((ITextComponent)new StringTextComponent(profile.getName()));
        }
        return stack;
    }

    private void func_213816_g(DamageSource source) {
        this.playBrokenSound();
        this.func_213345_d(source);
        for (int i = 0; i < this.handItems.size(); ++i) {
            ItemStack itemstack = (ItemStack)this.handItems.get(i);
            if (itemstack.func_190926_b()) continue;
            Block.func_180635_a((World)this.field_70170_p, (BlockPos)this.func_233580_cy_().func_177984_a(), (ItemStack)itemstack);
            this.handItems.set(i, (Object)ItemStack.field_190927_a);
        }
        for (int j = 0; j < this.armorItems.size(); ++j) {
            ItemStack itemstack1 = (ItemStack)this.armorItems.get(j);
            if (itemstack1.func_190926_b()) continue;
            Block.func_180635_a((World)this.field_70170_p, (BlockPos)this.func_233580_cy_().func_177984_a(), (ItemStack)itemstack1);
            this.armorItems.set(j, (Object)ItemStack.field_190927_a);
        }
    }

    private void playBrokenSound() {
        this.field_70170_p.func_184148_a((PlayerEntity)null, this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), SoundEvents.field_187701_j, this.func_184176_by(), 1.0f, 1.0f);
    }

    protected float func_110146_f(float p_110146_1_, float p_110146_2_) {
        this.field_70760_ar = this.field_70126_B;
        this.field_70761_aq = this.field_70177_z;
        return 0.0f;
    }

    protected float func_213348_b(Pose poseIn, EntitySize sizeIn) {
        return sizeIn.field_220316_b * (this.func_70631_g_() ? 0.5f : 0.9f);
    }

    public double func_70033_W() {
        return (double)0.1f + (double)this.getYOffsetData();
    }

    public void func_213352_e(Vector3d travelVector) {
        if (this.func_213814_A()) {
            super.func_213352_e(travelVector);
        }
    }

    public void func_181013_g(float offset) {
        this.field_70760_ar = this.field_70126_B = offset;
        this.field_70758_at = this.field_70759_as = offset;
    }

    public void func_70034_d(float rotation) {
        this.field_70760_ar = this.field_70126_B = rotation;
        this.field_70758_at = this.field_70759_as = rotation;
    }

    public void func_70071_h_() {
        Rotations rotations5;
        Rotations rotations4;
        Rotations rotations3;
        Rotations rotations2;
        Rotations rotations1;
        super.func_70071_h_();
        Rotations rotations = (Rotations)this.field_70180_af.func_187225_a(HEAD_ROTATION);
        if (!this.headRotation.equals((Object)rotations)) {
            this.setHeadRotation(rotations);
        }
        if (!this.bodyRotation.equals((Object)(rotations1 = (Rotations)this.field_70180_af.func_187225_a(BODY_ROTATION)))) {
            this.setBodyRotation(rotations1);
        }
        if (!this.leftArmRotation.equals((Object)(rotations2 = (Rotations)this.field_70180_af.func_187225_a(LEFT_ARM_ROTATION)))) {
            this.setLeftArmRotation(rotations2);
        }
        if (!this.rightArmRotation.equals((Object)(rotations3 = (Rotations)this.field_70180_af.func_187225_a(RIGHT_ARM_ROTATION)))) {
            this.setRightArmRotation(rotations3);
        }
        if (!this.leftLegRotation.equals((Object)(rotations4 = (Rotations)this.field_70180_af.func_187225_a(LEFT_LEG_ROTATION)))) {
            this.setLeftLegRotation(rotations4);
        }
        if (!this.rightLegRotation.equals((Object)(rotations5 = (Rotations)this.field_70180_af.func_187225_a(RIGHT_LEG_ROTATION)))) {
            this.setRightLegRotation(rotations5);
        }
    }

    public boolean func_70631_g_() {
        return this.isSmall();
    }

    public void func_174812_G() {
        this.func_70106_y();
    }

    private void setSmall(boolean small) {
        this.field_70180_af.func_187227_b(STATUS, (Object)this.setBit((Byte)this.field_70180_af.func_187225_a(STATUS), 1, small));
    }

    public boolean isSmall() {
        return ((Byte)this.field_70180_af.func_187225_a(STATUS) & 1) != 0;
    }

    private byte setBit(byte p_184797_1_, int p_184797_2_, boolean p_184797_3_) {
        p_184797_1_ = p_184797_3_ ? (byte)(p_184797_1_ | p_184797_2_) : (byte)(p_184797_1_ & ~p_184797_2_);
        return p_184797_1_;
    }

    public void setHeadRotation(Rotations vec) {
        this.headRotation = vec;
        this.field_70180_af.func_187227_b(HEAD_ROTATION, (Object)vec);
    }

    public void setBodyRotation(Rotations vec) {
        this.bodyRotation = vec;
        this.field_70180_af.func_187227_b(BODY_ROTATION, (Object)vec);
    }

    public void setLeftArmRotation(Rotations vec) {
        this.leftArmRotation = vec;
        this.field_70180_af.func_187227_b(LEFT_ARM_ROTATION, (Object)vec);
    }

    public void setRightArmRotation(Rotations vec) {
        this.rightArmRotation = vec;
        this.field_70180_af.func_187227_b(RIGHT_ARM_ROTATION, (Object)vec);
    }

    public void setLeftLegRotation(Rotations vec) {
        this.leftLegRotation = vec;
        this.field_70180_af.func_187227_b(LEFT_LEG_ROTATION, (Object)vec);
    }

    public void setRightLegRotation(Rotations vec) {
        this.rightLegRotation = vec;
        this.field_70180_af.func_187227_b(RIGHT_LEG_ROTATION, (Object)vec);
    }

    public Rotations getHeadRotation() {
        return this.headRotation;
    }

    public Rotations getBodyRotation() {
        return this.bodyRotation;
    }

    @OnlyIn(value=Dist.CLIENT)
    public Rotations getLeftArmRotation() {
        return this.leftArmRotation;
    }

    @OnlyIn(value=Dist.CLIENT)
    public Rotations getRightArmRotation() {
        return this.rightArmRotation;
    }

    @OnlyIn(value=Dist.CLIENT)
    public Rotations getLeftLegRotation() {
        return this.leftLegRotation;
    }

    @OnlyIn(value=Dist.CLIENT)
    public Rotations getRightLegRotation() {
        return this.rightLegRotation;
    }

    public boolean func_70067_L() {
        return true;
    }

    public boolean func_85031_j(Entity entityIn) {
        return entityIn instanceof PlayerEntity && !this.field_70170_p.func_175660_a((PlayerEntity)entityIn, this.func_233580_cy_());
    }

    @Nonnull
    public HandSide func_184591_cq() {
        return HandSide.RIGHT;
    }

    @Nonnull
    protected SoundEvent func_184588_d(int heightIn) {
        return SoundEvents.field_187704_k;
    }

    @Nullable
    protected SoundEvent func_184601_bQ(DamageSource damageSourceIn) {
        return SoundEvents.field_187707_l;
    }

    @Nullable
    protected SoundEvent func_184615_bR() {
        return SoundEvents.field_187701_j;
    }

    public void func_241841_a(ServerWorld world, LightningBoltEntity lightning) {
    }

    public boolean func_184603_cC() {
        return false;
    }

    public void func_184206_a(DataParameter<?> key) {
        GameProfile gameprofile;
        if (STATUS.equals(key)) {
            this.func_213323_x_();
            this.field_70156_m = !this.field_70128_L;
        } else if (GAMEPROFILE.equals(key) && this.field_70170_p.func_201670_d() && (gameprofile = this.getGameProfile().get()) != null) {
            Minecraft.func_71410_x().func_152342_ad().func_152790_a(gameprofile, (textureType, textureLocation, profileTexture) -> {
                if (textureType.equals((Object)MinecraftProfileTexture.Type.SKIN)) {
                    String metadata = profileTexture.getMetadata("model");
                    this.setSlim(metadata != null && metadata.equals("slim"));
                }
            }, true);
        }
        super.func_184206_a(key);
    }

    public boolean func_190631_cK() {
        return false;
    }
}

