/*
 * Decompiled with CFR 0.152.
 */
package com.shynieke.statues.client;

import com.mojang.authlib.GameProfileRepository;
import com.mojang.authlib.minecraft.MinecraftSessionService;
import com.mojang.authlib.yggdrasil.YggdrasilAuthenticationService;
import com.shynieke.statues.blocks.statues.fish.FishStatueBlock;
import com.shynieke.statues.client.render.PlayerStatueRenderer;
import com.shynieke.statues.client.render.PlayerTileRenderer;
import com.shynieke.statues.client.render.StatueBatRenderer;
import com.shynieke.statues.init.StatueRegistry;
import com.shynieke.statues.init.StatueTiles;
import com.shynieke.statues.items.CustomSpawnEggItem;
import com.shynieke.statues.tiles.PlayerTile;
import java.io.File;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.RenderTypeLookup;
import net.minecraft.client.renderer.color.BlockColors;
import net.minecraft.client.renderer.color.ItemColors;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.item.ItemFrameEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.IItemPropertyGetter;
import net.minecraft.item.Item;
import net.minecraft.item.ItemModelsProperties;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.management.PlayerProfileCache;
import net.minecraft.util.Direction;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.ColorHandlerEvent;
import net.minecraftforge.fml.client.registry.ClientRegistry;
import net.minecraftforge.fml.client.registry.RenderingRegistry;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;

public class ClientHandler {
    public static void doClientStuff(FMLClientSetupEvent event) {
        ClientRegistry.bindTileEntityRenderer(StatueTiles.PLAYER, PlayerTileRenderer::new);
        RenderingRegistry.registerEntityRenderingHandler((EntityType)((EntityType)StatueRegistry.PLAYER_STATUE_ENTITY.get()), PlayerStatueRenderer::new);
        RenderingRegistry.registerEntityRenderingHandler((EntityType)((EntityType)StatueRegistry.STATUE_BAT.get()), StatueBatRenderer::new);
        RenderTypeLookup.setRenderLayer((Block)((Block)StatueRegistry.CAMPFIRE_STATUE.get()), (RenderType)RenderType.func_228643_e_());
        RenderTypeLookup.setRenderLayer((Block)((Block)StatueRegistry.DROWNED_STATUE.get()), (RenderType)RenderType.func_228643_e_());
        RenderTypeLookup.setRenderLayer((Block)((Block)StatueRegistry.HUSK_STATUE.get()), (RenderType)RenderType.func_228643_e_());
        RenderTypeLookup.setRenderLayer((Block)((Block)StatueRegistry.ZOMBIE_STATUE.get()), (RenderType)RenderType.func_228643_e_());
        RenderTypeLookup.setRenderLayer((Block)((Block)StatueRegistry.ENDERMAN_STATUE.get()), (RenderType)RenderType.func_228643_e_());
        RenderTypeLookup.setRenderLayer((Block)((Block)StatueRegistry.INFO_STATUE.get()), (RenderType)RenderType.func_228643_e_());
        RenderTypeLookup.setRenderLayer((Block)((Block)StatueRegistry.WASTELAND_STATUE.get()), (RenderType)RenderType.func_228643_e_());
        RenderTypeLookup.setRenderLayer((Block)((Block)StatueRegistry.ENDERMITE_STATUE.get()), (RenderType)RenderType.func_228645_f_());
        RenderTypeLookup.setRenderLayer((Block)((Block)StatueRegistry.SLIME_STATUE.get()), (RenderType)RenderType.func_228645_f_());
        Minecraft mc = Minecraft.func_71410_x();
        YggdrasilAuthenticationService yggdrasilauthenticationservice = new YggdrasilAuthenticationService(mc.func_110437_J(), UUID.randomUUID().toString());
        MinecraftSessionService minecraftsessionservice = yggdrasilauthenticationservice.createMinecraftSessionService();
        GameProfileRepository gameprofilerepository = yggdrasilauthenticationservice.createProfileRepository();
        PlayerProfileCache playerprofilecache = new PlayerProfileCache(gameprofilerepository, new File(mc.field_71412_D, MinecraftServer.field_152367_a.getName()));
        PlayerTile.setProfileCache(playerprofilecache);
        PlayerTile.setSessionService(minecraftsessionservice);
        PlayerProfileCache.func_187320_a((boolean)false);
        ItemModelsProperties.func_239418_a_((Item)((Item)StatueRegistry.PLAYER_COMPASS.get()), (ResourceLocation)new ResourceLocation("angle"), (IItemPropertyGetter)new IItemPropertyGetter(){
            private final Angle rotation = new Angle();
            private final Angle rota = new Angle();

            public float call(ItemStack stack, @Nullable ClientWorld worldIn, @Nullable LivingEntity entityIn) {
                LivingEntity entity;
                Object object = entity = entityIn != null ? entityIn : stack.func_234694_A_();
                if (entity == null) {
                    return 0.0f;
                }
                if (entity != null && entity.field_70170_p instanceof ClientWorld) {
                    worldIn = (ClientWorld)entity.field_70170_p;
                }
                if (worldIn != null) {
                    long location;
                    BlockPos blockpos = this.getWorldPos(worldIn);
                    long gameTime = worldIn.func_82737_E();
                    CompoundNBT tag = stack.func_77978_p();
                    if (tag != null && tag.func_74764_b("lastPlayerLocation") && (location = tag.func_74763_f("lastPlayerLocation")) != 0L) {
                        blockpos = BlockPos.func_218283_e((long)location);
                    }
                    if (blockpos != null && !(entity.func_213303_ch().func_186679_c((double)blockpos.func_177958_n() + 0.5, entity.func_213303_ch().func_82617_b(), (double)blockpos.func_177952_p() + 0.5) < (double)1.0E-5f)) {
                        double d3;
                        boolean flag = entity instanceof PlayerEntity && ((PlayerEntity)entityIn).func_175144_cb();
                        double d1 = 0.0;
                        if (flag) {
                            d1 = entityIn.field_70177_z;
                        } else if (entity instanceof ItemFrameEntity) {
                            d1 = this.getFrameRotation((ItemFrameEntity)entity);
                        } else if (entity instanceof ItemEntity) {
                            d1 = 180.0f - ((ItemEntity)entity).func_234272_a_(0.5f) / ((float)Math.PI * 2) * 360.0f;
                        } else if (entityIn != null) {
                            d1 = entityIn.field_70761_aq;
                        }
                        d1 = MathHelper.func_191273_b((double)(d1 / 360.0), (double)1.0);
                        double d2 = this.getLocationToAngle(Vector3d.func_237489_a_((Vector3i)blockpos), (Entity)entity) / 6.2831854820251465;
                        if (flag) {
                            if (this.rotation.func_239448_a_(gameTime)) {
                                this.rotation.func_239449_a_(gameTime, 0.5 - (d1 - 0.25));
                            }
                            d3 = d2 + this.rotation.field_239445_a_;
                        } else {
                            d3 = 0.5 - (d1 - 0.25 - d2);
                        }
                        return MathHelper.func_188207_b((float)((float)d3), (float)1.0f);
                    }
                    if (this.rota.func_239448_a_(gameTime)) {
                        this.rota.func_239449_a_(gameTime, Math.random());
                    }
                    double d0 = this.rota.field_239445_a_ + (double)((float)stack.hashCode() / 2.1474836E9f);
                    return MathHelper.func_188207_b((float)((float)d0), (float)1.0f);
                }
                double d0 = this.rota.field_239445_a_ + (double)((float)stack.hashCode() / 2.1474836E9f);
                return MathHelper.func_188207_b((float)((float)d0), (float)1.0f);
            }

            @Nullable
            private BlockPos getWorldPos(ClientWorld world) {
                return world.func_230315_m_().func_236043_f_() ? world.func_239140_u_() : null;
            }

            private double getFrameRotation(ItemFrameEntity itemFrameIn) {
                Direction direction = itemFrameIn.func_174811_aO();
                int i = direction.func_176740_k().func_200128_b() ? 90 * direction.func_176743_c().func_179524_a() : 0;
                return MathHelper.func_188209_b((int)(180 + direction.func_176736_b() * 90 + itemFrameIn.func_82333_j() * 45 + i));
            }

            private double getLocationToAngle(Vector3d location, Entity entityIn) {
                return Math.atan2(location.func_82616_c() - entityIn.func_226281_cx_(), location.func_82615_a() - entityIn.func_226277_ct_());
            }
        });
    }

    public static void registerBlockColors(ColorHandlerEvent.Block event) {
        BlockColors colors = event.getBlockColors();
        colors.func_186722_a(FishStatueBlock::getColor, new Block[]{(Block)StatueRegistry.TROPICAL_FISH_B.get(), (Block)StatueRegistry.TROPICAL_FISH_BB.get(), (Block)StatueRegistry.TROPICAL_FISH_BE.get(), (Block)StatueRegistry.TROPICAL_FISH_BM.get(), (Block)StatueRegistry.TROPICAL_FISH_BMB.get(), (Block)StatueRegistry.TROPICAL_FISH_BMS.get(), (Block)StatueRegistry.TROPICAL_FISH_E.get(), (Block)StatueRegistry.TROPICAL_FISH_ES.get(), (Block)StatueRegistry.TROPICAL_FISH_HB.get(), (Block)StatueRegistry.TROPICAL_FISH_SB.get(), (Block)StatueRegistry.TROPICAL_FISH_SD.get(), (Block)StatueRegistry.TROPICAL_FISH_SS.get()});
    }

    public static void registerItemColors(ColorHandlerEvent.Item event) {
        ItemColors colors = event.getItemColors();
        for (CustomSpawnEggItem item : CustomSpawnEggItem.getEggs()) {
            colors.func_199877_a((p_198141_1_, p_198141_2_) -> item.getColor(p_198141_2_), new IItemProvider[]{item});
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    static class Angle {
        private double field_239445_a_;
        private double field_239446_b_;
        private long field_239447_c_;

        private Angle() {
        }

        private boolean func_239448_a_(long p_239448_1_) {
            return this.field_239447_c_ != p_239448_1_;
        }

        private void func_239449_a_(long p_239449_1_, double p_239449_3_) {
            this.field_239447_c_ = p_239449_1_;
            double d0 = p_239449_3_ - this.field_239445_a_;
            d0 = MathHelper.func_191273_b((double)(d0 + 0.5), (double)1.0) - 0.5;
            this.field_239446_b_ += d0 * 0.1;
            this.field_239446_b_ *= 0.8;
            this.field_239445_a_ = MathHelper.func_191273_b((double)(this.field_239445_a_ + this.field_239446_b_), (double)1.0);
        }
    }
}

